/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.cache;

import com.complexible.common.cache.ConcurrentLRUSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ConcurrentLRUCache<K, V>
implements Map<K, V> {
    private final ConcurrentLRUSet<ConcurrentLRUSet.ObjectObjectEntry<K, V>> map;
    private final ThreadLocal<ConcurrentLRUSet.ObjectObjectEntry<K, V>> template = new ThreadLocal<ConcurrentLRUSet.ObjectObjectEntry<K, V>>(this){

        @Override
        protected ConcurrentLRUSet.ObjectObjectEntry<K, V> initialValue() {
            return new ConcurrentLRUSet.ObjectObjectEntry<Object, Object>(null, null);
        }
    };

    public static <K, V> ConcurrentLRUCache<K, V> create(int initCapacity, int maxCapacity, int concurrencyLevel, ConcurrentLRUSet.EvictionListener<ConcurrentLRUSet.ObjectObjectEntry<K, V>> listener) {
        int upperWatermark = maxCapacity;
        int evictionCount = Math.min(maxCapacity / 10, 2048);
        int lowerWatermark = upperWatermark - evictionCount;
        int acceptableWatermark = (upperWatermark + lowerWatermark) / 2;
        return new ConcurrentLRUCache<K, V>(upperWatermark, lowerWatermark, acceptableWatermark, initCapacity, concurrencyLevel, listener);
    }

    public ConcurrentLRUCache(int upperWaterMark, int lowerWaterMark, int acceptableWatermark, int initialSize, int concurrencyLevel, ConcurrentLRUSet.EvictionListener<ConcurrentLRUSet.ObjectObjectEntry<K, V>> evictionListener) {
        this.map = new ConcurrentLRUSet<ConcurrentLRUSet.ObjectObjectEntry<K, V>>(upperWaterMark, lowerWaterMark, acceptableWatermark, initialSize, concurrencyLevel, evictionListener);
    }

    public void setAlive(boolean live) {
        this.map.setAlive(live);
    }

    @Override
    public V get(Object key) {
        ConcurrentLRUSet.ObjectObjectEntry<Object, V> e = this.template.get().reset(key);
        ConcurrentLRUSet.ObjectObjectEntry<Object, V> result = this.map.get(e);
        return result == null ? null : (V)result.getValue();
    }

    @Override
    public V remove(Object key) {
        ConcurrentLRUSet.ObjectObjectEntry<Object, V> e = this.template.get().reset(key);
        ConcurrentLRUSet.ObjectObjectEntry<Object, V> result = this.map.remove(e);
        return result == null ? null : (V)result.getValue();
    }

    @Override
    public V put(K key, V val) {
        ConcurrentLRUSet.ObjectObjectEntry<K, V> result = this.map.put(new ConcurrentLRUSet.ObjectObjectEntry<K, V>(key, val));
        return result == null ? null : (V)result.getValue();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public ConcurrentLRUSet.Stats getStats() {
        return this.map.getStats();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map;
    }

    @Override
    public boolean isEmpty() {
        return this.size() > 0;
    }

    @Override
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    public Collection<ConcurrentLRUSet.ObjectObjectEntry<K, V>> getOldestAccessedItems(int n) {
        return this.map.getOldestAccessedItems(n);
    }

    public Collection<ConcurrentLRUSet.ObjectObjectEntry<K, V>> getLatestAccessedItems(int n) {
        return this.map.getLatestAccessedItems(n);
    }
}

