/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class Caches {
    public static final int DEFAULT_CONCURRENCY_LEVEL = 16;

    public static <K, V> Map<K, V> newCache(int initCapacity, int maxCapacity) {
        return Caches.newLRUCache(initCapacity, maxCapacity);
    }

    public static <K, V> Map<K, V> newLRUCache(int initCapacity, final int maxCapacity) {
        return new LinkedHashMap<K, V>(initCapacity, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > maxCapacity;
            }
        };
    }

    public static <K, V> Map<K, V> newSynchronizedCache(int initCapacity, int maxCapacity) {
        return Collections.synchronizedMap(Caches.newCache(initCapacity, maxCapacity));
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentCache(int initCapacity, int maxCapacity) {
        return Caches.newConcurrentCache(initCapacity, maxCapacity, 16);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentCache(int initCapacity, int maxCapacity, int concurrencyLevel) {
        return Caches.newGuavaCache(initCapacity, maxCapacity, concurrencyLevel, null).asMap();
    }

    public static <K, V> Cache<K, V> newGuavaCache(int initCapacity, int maxCapacity, int concurrencyLevel, RemovalListener<K, V> listener) {
        CacheBuilder cache = CacheBuilder.newBuilder().initialCapacity(initCapacity).maximumSize((long)maxCapacity).concurrencyLevel(concurrencyLevel);
        if (listener != null) {
            return cache.removalListener(listener).build();
        }
        return cache.build();
    }
}

