/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.google.common.base.Charsets;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class Strings2 {
    private Strings2() {
        throw new AssertionError();
    }

    public static String toTitleCase(String theStr) {
        char[] charArray = theStr.toLowerCase().toCharArray();
        Pattern pattern = Pattern.compile("\\b([A-Za-z])");
        Matcher matcher = pattern.matcher(theStr);
        while (matcher.find()) {
            int index = matcher.end(1) - 1;
            charArray[index] = Character.toTitleCase(charArray[index]);
        }
        return String.valueOf(charArray);
    }

    public static String hex(byte[] theArray) {
        StringBuffer sb = new StringBuffer();
        for (byte aByte : theArray) {
            sb.append(Integer.toHexString(aByte & 0xFF | 0x100).toUpperCase().substring(1, 3));
        }
        return sb.toString();
    }

    public static byte[] md5(String theString) {
        return Strings2.md5(theString.getBytes(Charsets.UTF_8));
    }

    public static byte[] md5(byte[] theBytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            return md.digest(theBytes);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getRandomString(int theLength) {
        return Strings2.getRandomString(theLength, ThreadLocalRandom.current());
    }

    public static String getRandomString(int theLength, Random random) {
        StringBuffer aBuffer = new StringBuffer();
        for (int i = 0; i < theLength; ++i) {
            int index = 97 + random.nextInt(26);
            char c = (char)index;
            aBuffer.append(c);
        }
        return aBuffer.toString();
    }

    public static String urlEncode(String theString) {
        return Strings2.urlEncode(theString, Charsets.UTF_8);
    }

    public static String urlEncode(String theString, Charset theCharset) {
        try {
            return URLEncoder.encode(theString, theCharset.displayName());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String urlDecode(String theString) {
        return Strings2.urlDecode(theString, Charsets.UTF_8);
    }

    public static String urlDecode(String theString, Charset theCharset) {
        try {
            return URLDecoder.decode(theString, theCharset.displayName());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String base64Encode(byte[] theArrayToEncode) {
        return BaseEncoding.base64().encode(theArrayToEncode);
    }

    public static byte[] base64Decode(String theStringToDecode) throws IOException {
        return BaseEncoding.base64().decode((CharSequence)theStringToDecode);
    }

    public static String withoutLastCharacter(String s) {
        if (s.isEmpty()) {
            throw new IllegalArgumentException("String must be non-empty");
        }
        return s.substring(0, s.length() - 1);
    }

    public static String withoutTrailingSlash(String s) {
        if (!s.isEmpty() && s.charAt(s.length() - 1) == '/') {
            return Strings2.withoutLastCharacter(s);
        }
        return s;
    }

    public static String indentMultiline(String input, String indentPrefix) {
        return input.replaceAll("(?m)^", indentPrefix);
    }

    public static String withoutQuotes(String s) {
        return StringUtils.unwrap((String)StringUtils.unwrap((String)s, (String)"\""), (String)"'");
    }

    public static String trimNewlines(String s) {
        return s.trim().replaceAll("\n$", "").replaceAll("^\n", "").trim();
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return str.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        int suffixLength = suffix.length();
        return str.regionMatches(true, str.length() - suffixLength, suffix, 0, suffixLength);
    }
}

