/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.complexible.common.base.CloseableIterator;
import com.complexible.common.base.Functional;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Streams {
    public static final boolean NOT_PARALLEL = false;
    public static final boolean PARALLEL = true;
    public static final long UNKNOWN_SIZE = Long.MAX_VALUE;
    private static final Consumer<Throwable> DEFAULT_THROWABLE_HANDLER = e -> {
        if (e instanceof Error) {
            throw (Error)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new UncheckedException((Throwable)e);
    };

    public Streams() {
        throw new AssertionError();
    }

    public static <T> Function<Optional<T>, Stream<T>> optional() {
        return theOpt -> theOpt.isPresent() ? Stream.of(theOpt.get()) : Stream.empty();
    }

    public static <T> Stream<T> stream(Iterable<T> theIterable) {
        if (theIterable instanceof Collection) {
            return ((Collection)theIterable).stream();
        }
        return StreamSupport.stream(theIterable.spliterator(), false);
    }

    public static <T> Stream<T> stream(Iterator<? extends T> theIter) {
        Stream<T> aStream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(theIter, 1280), false);
        if (theIter instanceof AutoCloseable) {
            return (Stream)aStream.onClose(() -> {
                try {
                    ((AutoCloseable)((Object)theIter)).close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return aStream;
    }

    public static <T> Stream<T> stream(Iterator<? extends T> theIter, long theSize) {
        Stream<T> aStream = StreamSupport.stream(Spliterators.spliterator(theIter, theSize, 1280), false);
        if (theIter instanceof AutoCloseable) {
            return (Stream)aStream.onClose(() -> {
                try {
                    ((AutoCloseable)((Object)theIter)).close();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        return aStream;
    }

    @SafeVarargs
    public static <T> Stream<T> concat(Stream<T> theStream, Stream<T> theOtherStream, Stream<T> ... theMoreStreams) {
        Stream<T> aStream = Stream.concat(theStream, theOtherStream);
        for (Stream<T> s : theMoreStreams) {
            aStream = Stream.concat(aStream, s);
        }
        return aStream;
    }

    public static <Input, Output> Output applyTerminalAndClose(Stream<Input> theStream, Function<Stream<Input>, Output> theFinisher) {
        try (Stream<Input> aStream = theStream;){
            Output Output = theFinisher.apply(aStream);
            return Output;
        }
    }

    public static <T, E extends Throwable> void forEachChecked(Stream<T> theStream, CheckedConsumer<T> theConsumer) throws E {
        try {
            theStream.forEach(Streams.uncheckedConsumer(theConsumer));
        }
        catch (UncheckedException e) {
            throw e.getCause();
        }
    }

    public static <In, Out> Function<In, Out> unchecked(CheckedFunction<In, Out> theFunction) {
        return Streams.unchecked(theFunction, DEFAULT_THROWABLE_HANDLER);
    }

    public static <In, Out> Function<In, Out> unchecked(CheckedFunction<In, Out> theFunction, Consumer<Throwable> theHandler) {
        return theInput -> {
            try {
                return theFunction.apply(theInput);
            }
            catch (Throwable e) {
                theHandler.accept(e);
                throw new IllegalStateException("Handler should throw exception");
            }
        };
    }

    public static <In1, In2, Out> BiFunction<In1, In2, Out> unchecked(CheckedBiFunction<In1, In2, Out> theBiFunction) {
        return Streams.unchecked(theBiFunction, DEFAULT_THROWABLE_HANDLER);
    }

    public static <In1, In2, Out> BiFunction<In1, In2, Out> unchecked(CheckedBiFunction<In1, In2, Out> theBiFunction, Consumer<Throwable> theHandler) {
        return (theInput1, theInput2) -> {
            try {
                return theBiFunction.apply(theInput1, theInput2);
            }
            catch (Throwable e) {
                theHandler.accept(e);
                throw new IllegalStateException("Handler should throw exception");
            }
        };
    }

    public static <In> Predicate<In> uncheckedPredicate(CheckedPredicate<In> thePredicate) {
        return Streams.uncheckedPredicate(thePredicate, DEFAULT_THROWABLE_HANDLER);
    }

    public static <In> Predicate<In> uncheckedPredicate(CheckedPredicate<In> thePredicate, Consumer<Throwable> theHandler) {
        return theInput -> {
            try {
                return thePredicate.test(theInput);
            }
            catch (Throwable e) {
                theHandler.accept(e);
                throw new IllegalStateException("Handler should throw exception");
            }
        };
    }

    public static <T> Consumer<T> uncheckedConsumer(CheckedConsumer<T> theConsumer) {
        return Streams.uncheckedConsumer(theConsumer, DEFAULT_THROWABLE_HANDLER);
    }

    public static <U, T> BiConsumer<U, T> uncheckedConsumer(CheckedBiConsumer<U, T> theConsumer) {
        return Streams.uncheckedConsumer(theConsumer, DEFAULT_THROWABLE_HANDLER);
    }

    public static <U, T> BiConsumer<U, T> uncheckedConsumer(CheckedBiConsumer<U, T> theConsumer, Consumer<Throwable> theHandler) {
        return (v1, v2) -> {
            try {
                theConsumer.accept(v1, v2);
            }
            catch (Throwable e) {
                theHandler.accept(e);
                throw new IllegalStateException("Handler should throw exception");
            }
        };
    }

    public static <T> Consumer<T> uncheckedConsumer(CheckedConsumer<T> theConsumer, Consumer<Throwable> theHandler) {
        return theValue -> {
            try {
                theConsumer.accept(theValue);
            }
            catch (Throwable e) {
                theHandler.accept(e);
                throw new IllegalStateException("Handler should throw exception");
            }
        };
    }

    public static <T> CloseableIterator<T> flatIterator(final Stream<Stream<T>> theStream) {
        final Iterator aMainIter = theStream.iterator();
        return new CloseableIterator.AbstractCloseableIterator<T>(){
            private Stream<T> mCurrentStream = null;
            private Iterator<T> mCurrentIter = null;

            protected T computeNext() {
                while (true) {
                    if (this.mCurrentIter != null) {
                        if (this.mCurrentIter.hasNext()) {
                            return this.mCurrentIter.next();
                        }
                        this.mCurrentStream.close();
                        this.mCurrentIter = null;
                        continue;
                    }
                    if (!aMainIter.hasNext()) break;
                    this.mCurrentStream = (Stream)aMainIter.next();
                    this.mCurrentIter = this.mCurrentStream.iterator();
                }
                return this.endOfData();
            }

            @Override
            public void close() throws RuntimeException {
                if (this.mCurrentStream != null) {
                    this.mCurrentStream.close();
                }
                theStream.close();
            }
        };
    }

    public static <T> Stream<T> flatten(Stream<Stream<T>> theStream) {
        return Streams.stream(Streams.flatIterator(theStream));
    }

    public static <T> Predicate<? super T> distinctByKey(Function<? super T, Object> theKey) {
        HashSet aSeenElements = Sets.newHashSet();
        return theElement -> aSeenElements.add(theKey.apply(theElement));
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, HashMap<K, V>> entriesToMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Functional.throwingCombiner(), HashMap::new);
    }

    @FunctionalInterface
    public static interface CheckedConsumer<T> {
        public void accept(T var1) throws Exception;
    }

    public static final class UncheckedException
    extends RuntimeException {
        public UncheckedException(Throwable cause) {
            super(cause);
        }

        public static Throwable unwrap(Throwable theThrowable) {
            if (theThrowable instanceof UncheckedException && theThrowable.getCause() != null) {
                return theThrowable.getCause();
            }
            return theThrowable;
        }
    }

    @FunctionalInterface
    public static interface CheckedFunction<In, Out> {
        public Out apply(In var1) throws Exception;
    }

    @FunctionalInterface
    public static interface CheckedBiFunction<In1, In2, Out> {
        public Out apply(In1 var1, In2 var2) throws Exception;
    }

    @FunctionalInterface
    public static interface CheckedPredicate<T> {
        public boolean test(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface CheckedBiConsumer<U, T> {
        public void accept(U var1, T var2) throws Throwable;
    }

    @FunctionalInterface
    public static interface CheckedSupplier<Out> {
        public Out get() throws Exception;
    }

    @FunctionalInterface
    public static interface CheckedRunnable {
        public void run() throws Throwable;
    }
}

