/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.complexible.common.base.JDKSorter;
import com.complexible.common.base.MergeSorter;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Comparator;

public abstract class Sorter<T> {
    private static final boolean USE_JDK_SORT = System.getProperty("com.complexible.common.base.sorter.jdk", "false").equalsIgnoreCase("true");
    protected final Comparator<? super T> c;

    public static <T> Sorter<T> create(int length, Comparator<? super T> comp) {
        return USE_JDK_SORT ? new JDKSorter<T>(comp) : new MergeSorter<T>(length, comp);
    }

    protected Sorter(Comparator<? super T> c) {
        this.c = c;
    }

    public abstract void sort(T[] var1, int var2, int var3);

    public static final class QuickSorter<T>
    extends Sorter<T> {
        public QuickSorter(Comparator<? super T> c) {
            super(c);
        }

        @Override
        public void sort(T[] array, int start, int end) {
            QuickSorter.quickSort(array, start, end, this.c);
        }

        private static <T> int med3(T[] array, int a, int b, int c, Comparator<T> comp) {
            T x = array[a];
            T y = array[b];
            T z = array[c];
            int comparisonxy = comp.compare(x, y);
            int comparisonxz = comp.compare(x, z);
            int comparisonyz = comp.compare(y, z);
            return comparisonxy < 0 ? (comparisonyz < 0 ? b : (comparisonxz < 0 ? c : a)) : (comparisonyz > 0 ? b : (comparisonxz > 0 ? c : a));
        }

        private static void checkBounds(int arrLength, int start, int end) {
            if (start > end) {
                throw new IllegalArgumentException("Start index " + start + " is greater than end index " + end);
            }
            if (start < 0) {
                throw new ArrayIndexOutOfBoundsException("Array index out of range " + start);
            }
            if (end > arrLength) {
                throw new ArrayIndexOutOfBoundsException("Array index out of range " + end);
            }
        }

        public static <T> void quickSort(T[] array, int start, int end, Comparator<T> comp) {
            Preconditions.checkNotNull(array, (Object)"array may not be null in quickSort");
            QuickSorter.checkBounds(array.length, start, end);
            QuickSorter.quickSort0(start, end, array, comp);
        }

        public static <T extends Comparable<? super T>> void quickSort(T[] array, int start, int end) {
            QuickSorter.quickSort(array, start, end, new ComparableAdaptor());
        }

        private static <T> void quickSort0(int start, int end, T[] array, Comparator<T> comp) {
            T temp;
            int c;
            int a;
            int length = end - start;
            if (length < 7) {
                for (int i = start + 1; i < end; ++i) {
                    for (int j = i; j > start && comp.compare(array[j - 1], array[j]) > 0; --j) {
                        T temp2 = array[j];
                        array[j] = array[j - 1];
                        array[j - 1] = temp2;
                    }
                }
                return;
            }
            int middle = (start + end) / 2;
            if (length > 7) {
                int bottom = start;
                int top = end - 1;
                if (length > 40) {
                    bottom = QuickSorter.med3(array, bottom, bottom + (length /= 8), bottom + 2 * length, comp);
                    middle = QuickSorter.med3(array, middle - length, middle, middle + length, comp);
                    top = QuickSorter.med3(array, top - 2 * length, top - length, top, comp);
                }
                middle = QuickSorter.med3(array, bottom, middle, top, comp);
            }
            T partionValue = array[middle];
            int b = a = start;
            int d = c = end - 1;
            while (true) {
                int comparison;
                if (b <= c && (comparison = comp.compare(array[b], partionValue)) <= 0) {
                    if (comparison == 0) {
                        temp = array[a];
                        array[a++] = array[b];
                        array[b] = temp;
                    }
                    ++b;
                    continue;
                }
                while (c >= b && (comparison = comp.compare(array[c], partionValue)) >= 0) {
                    if (comparison == 0) {
                        temp = array[c];
                        array[c] = array[d];
                        array[d--] = temp;
                    }
                    --c;
                }
                if (b > c) break;
                temp = array[b];
                array[b++] = array[c];
                array[c--] = temp;
            }
            length = a - start < b - a ? a - start : b - a;
            int l = start;
            int h = b - length;
            while (length-- > 0) {
                temp = array[l];
                array[l++] = array[h];
                array[h++] = temp;
            }
            length = d - c < end - 1 - d ? d - c : end - 1 - d;
            l = b;
            h = end - length;
            while (length-- > 0) {
                temp = array[l];
                array[l++] = array[h];
                array[h++] = temp;
            }
            length = b - a;
            if (length > 0) {
                QuickSorter.quickSort0(start, start + length, array, comp);
            }
            if ((length = d - c) > 0) {
                QuickSorter.quickSort0(end - length, end, array, comp);
            }
        }

        private static final class ComparableAdaptor<T extends Comparable<? super T>>
        implements Comparator<T>,
        Serializable {
            private ComparableAdaptor() {
            }

            @Override
            public int compare(T o1, T o2) {
                return o1.compareTo(o2);
            }
        }
    }
}

