/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import java.util.concurrent.atomic.AtomicLong;

public class ReportInterval {
    private long mInterval;
    private final AtomicLong mNextReport;
    private final long mStartTime;

    public ReportInterval(long theInterval) {
        this.mInterval = theInterval;
        this.mNextReport = new AtomicLong(theInterval);
        this.mStartTime = System.currentTimeMillis();
    }

    public long getInterval() {
        return this.mInterval;
    }

    public synchronized void setInterval(long theInterval) {
        this.mInterval = theInterval;
        this.mNextReport.set(this.computeNextReport(this.mNextReport.get()));
    }

    protected long getNextReport() {
        return this.mNextReport.get();
    }

    public boolean isReport(long theValue) {
        long aNextReport = this.mNextReport.get();
        if (theValue < aNextReport) {
            return false;
        }
        long aNewNextReport = aNextReport + this.mInterval;
        if (theValue >= aNewNextReport) {
            aNewNextReport = this.computeNextReport(theValue);
        }
        return this.mNextReport.compareAndSet(aNextReport, aNewNextReport);
    }

    protected long computeNextReport(long theValue) {
        return (theValue + this.mInterval - 1L) / this.mInterval * this.mInterval;
    }

    public long getElapsedTime() {
        return System.currentTimeMillis() - this.mStartTime;
    }
}

