/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public final class ImmutableCollectors {
    private ImmutableCollectors() {
        throw new AssertionError();
    }

    public static <T> Collector<T, ImmutableSet.Builder<T>, ImmutableSet<T>> toSet() {
        return new Collector<T, ImmutableSet.Builder<T>, ImmutableSet<T>>(){

            @Override
            public Supplier<ImmutableSet.Builder<T>> supplier() {
                return ImmutableSet::builder;
            }

            @Override
            public BiConsumer<ImmutableSet.Builder<T>, T> accumulator() {
                return ImmutableSet.Builder::add;
            }

            @Override
            public BinaryOperator<ImmutableSet.Builder<T>> combiner() {
                return (theBuilder, theOtherBuilder) -> theBuilder.addAll((Iterable)theOtherBuilder.build());
            }

            @Override
            public Function<ImmutableSet.Builder<T>, ImmutableSet<T>> finisher() {
                return ImmutableSet.Builder::build;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return ImmutableSet.of();
            }
        };
    }

    public static <T> Collector<T, ImmutableList.Builder<T>, ImmutableList<T>> toList() {
        return new Collector<T, ImmutableList.Builder<T>, ImmutableList<T>>(){

            @Override
            public Supplier<ImmutableList.Builder<T>> supplier() {
                return ImmutableList::builder;
            }

            @Override
            public BiConsumer<ImmutableList.Builder<T>, T> accumulator() {
                return ImmutableList.Builder::add;
            }

            @Override
            public BinaryOperator<ImmutableList.Builder<T>> combiner() {
                return (theBuilder, theOtherBuilder) -> theBuilder.addAll((Iterable)theOtherBuilder.build());
            }

            @Override
            public Function<ImmutableList.Builder<T>, ImmutableList<T>> finisher() {
                return ImmutableList.Builder::build;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return ImmutableSet.of();
            }
        };
    }

    public static <T, K, V> Collector<T, ImmutableMap.Builder<K, V>, ImmutableMap<K, V>> toMap(final Function<? super T, ? extends K> keyMapper, final Function<? super T, ? extends V> valueMapper) {
        return new Collector<T, ImmutableMap.Builder<K, V>, ImmutableMap<K, V>>(){

            @Override
            public Supplier<ImmutableMap.Builder<K, V>> supplier() {
                return ImmutableMap::builder;
            }

            @Override
            public BiConsumer<ImmutableMap.Builder<K, V>, T> accumulator() {
                return (coll, el) -> coll.put(keyMapper.apply(el), valueMapper.apply(el));
            }

            @Override
            public BinaryOperator<ImmutableMap.Builder<K, V>> combiner() {
                return (x, y) -> x.putAll((Map)y.build());
            }

            @Override
            public Function<ImmutableMap.Builder<K, V>, ImmutableMap<K, V>> finisher() {
                return ImmutableMap.Builder::build;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return Sets.newHashSet();
            }
        };
    }

    public static <T, K, V> Collector<T, HashMultimap<K, V>, Multimap<K, V>> toMultimap(final Function<? super T, ? extends K> keyMapper, final Function<? super T, ? extends V> valueMapper) {
        return new Collector<T, HashMultimap<K, V>, Multimap<K, V>>(){

            @Override
            public Supplier<HashMultimap<K, V>> supplier() {
                return HashMultimap::create;
            }

            @Override
            public BiConsumer<HashMultimap<K, V>, T> accumulator() {
                return (coll, el) -> coll.put(keyMapper.apply(el), valueMapper.apply(el));
            }

            @Override
            public BinaryOperator<HashMultimap<K, V>> combiner() {
                return (x, y) -> {
                    x.putAll((Multimap)y);
                    return x;
                };
            }

            @Override
            public Function<HashMultimap<K, V>, Multimap<K, V>> finisher() {
                return Multimap.class::cast;
            }

            @Override
            public Set<Collector.Characteristics> characteristics() {
                return Sets.newHashSet((Object[])new Collector.Characteristics[]{Collector.Characteristics.UNORDERED, Collector.Characteristics.IDENTITY_FINISH});
            }
        };
    }
}

