/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.complexible.common.base.CloseableIterator;
import com.complexible.common.base.Disposables;
import com.complexible.common.cancellation.CancelCheck;
import com.complexible.common.cancellation.Cancellable;
import com.complexible.common.collect.BufferList;
import com.complexible.common.collect.BufferLists;
import com.google.common.base.Throwables;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerBackedIterator<T>
extends CloseableIterator.AbstractCloseableIterator<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandlerBackedIterator.class);
    private static final int BATCH_QUEUE_SIZE = 2;
    private final DataProducer<T> mProducer;
    private final BlockingQueue<BufferList<T>> mQueue;
    private final CancelCheck mCancelCheck;
    private final AtomicBoolean mCancelProducer = new AtomicBoolean(false);
    private Iterator<T> mCurrentBatch = Collections.emptyIterator();
    private final Future<Throwable> mProducerFuture;

    public HandlerBackedIterator(DataProducer<T> producer, ExecutorService execService, CancelCheck cancelCheck) {
        this(producer, execService, cancelCheck, 1024);
    }

    public HandlerBackedIterator(DataProducer<T> producer, ExecutorService execService, CancelCheck cancelCheck, int batchSize) {
        this.mProducer = producer;
        this.mCancelCheck = cancelCheck;
        this.mQueue = Queues.newArrayBlockingQueue((int)2);
        this.mProducerFuture = execService.submit(new Runner<T>(this.mQueue, producer, this.mCancelProducer::get, batchSize));
        Disposables.markCreated(this);
    }

    private void cancelProducer(String message) {
        if (this.mCancelProducer.compareAndSet(false, true)) {
            this.mProducer.cancel(message);
            this.mQueue.clear();
            this.mProducerFuture.cancel(true);
        }
    }

    @Override
    public void close() {
        if (!this.mProducerFuture.isDone()) {
            this.cancelProducer("");
        }
        Disposables.markReleased(this);
    }

    protected T computeNext() {
        while (true) {
            this.mCancelCheck.check(err -> this.cancelProducer(err.getMessage()));
            if (this.mCurrentBatch.hasNext()) {
                return this.mCurrentBatch.next();
            }
            try {
                BufferList<T> nextBatch = this.mQueue.poll(1L, TimeUnit.SECONDS);
                if (nextBatch != null) {
                    LOGGER.debug("Got batch of size {} from the producer", (Object)nextBatch.size());
                    if (nextBatch.isEmpty()) {
                        this.checkAndThrowProducerError();
                        return (T)this.endOfData();
                    }
                    this.mCurrentBatch = nextBatch.iterator();
                    continue;
                }
                if (!this.mProducerFuture.isDone()) continue;
                this.checkAndThrowProducerError();
                LOGGER.warn("Producer {} finished unexpectedly, iteration could be incomplete", this.mProducer.getClass());
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.debug("Consumer interrupted");
                Thread.currentThread().interrupt();
                continue;
            }
            catch (ExecutionException e2) {
                this.throwProducerError(e2);
                continue;
            }
            break;
        }
    }

    private void checkAndThrowProducerError() throws ExecutionException {
        Throwable err = (Throwable)Uninterruptibles.getUninterruptibly(this.mProducerFuture);
        if (err != null) {
            this.throwProducerError(err);
        }
    }

    private void throwProducerError(Throwable err) {
        Throwables.throwIfUnchecked((Throwable)err);
        throw new RuntimeException(err.getMessage(), err);
    }

    @FunctionalInterface
    public static interface DataProducer<T>
    extends Cancellable {
        public void run(Consumer<T> var1);

        @Override
        default public void cancel(String message) {
        }
    }

    private static final class Runner<T>
    implements Callable<Throwable> {
        private static final BufferList POISON = BufferLists.fixed(0);
        private final BlockingQueue<BufferList<T>> mQueue;
        private final BufferList<T>[] mBatchPool;
        private int mPoolPtr = 0;
        private final DataProducer<T> mProducer;
        private final BooleanSupplier mCancel;
        private final int mBatchSize;

        Runner(BlockingQueue<BufferList<T>> queue, DataProducer<T> producer, BooleanSupplier cancel, int batchSize) {
            this.mQueue = queue;
            this.mProducer = producer;
            this.mBatchSize = batchSize;
            this.mCancel = cancel;
            this.mBatchPool = new BufferList[4];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Throwable call() {
            ProducerSink consumer = new ProducerSink<T>(){
                BufferList<T> mBatch = null;

                private BufferList<T> currentBatch() {
                    if (this.mBatch != null) {
                        return this.mBatch;
                    }
                    this.mBatch = mBatchPool[mPoolPtr];
                    if (this.mBatch == null) {
                        this.mBatch = BufferLists.fixed(mBatchSize);
                        mBatchPool[mPoolPtr] = this.mBatch;
                    } else {
                        this.mBatch.clear();
                    }
                    return this.mBatch;
                }

                private void checkCancelled() {
                    if (mCancel.getAsBoolean()) {
                        LOGGER.debug("Producer cancelled");
                        throw new ProducerFinished();
                    }
                }

                @Override
                public void finish() {
                    LOGGER.debug("Finishing the producer");
                    this.checkCancelled();
                    try {
                        if (this.mBatch != null && !this.mBatch.isEmpty()) {
                            LOGGER.debug("Adding last batch of size {} to the queue (current size: {})", (Object)this.mBatch.size(), (Object)mQueue.size());
                            mQueue.put(this.mBatch);
                        }
                        mQueue.put(POISON);
                    }
                    catch (InterruptedException e) {
                        LOGGER.debug("Producer interrupted while finishing", (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    LOGGER.debug("Producer is finished");
                }

                @Override
                public void accept(T data) {
                    this.checkCancelled();
                    this.mBatch = this.currentBatch();
                    if (this.mBatch.add(data)) {
                        try {
                            LOGGER.debug("Batch full at {} objects, adding to the queue (current size: {})", (Object)this.mBatch.size(), (Object)mQueue.size());
                            mQueue.put(this.mBatch);
                            this.mBatch = null;
                            ++mPoolPtr;
                            if (mPoolPtr >= mBatchPool.length) {
                                mPoolPtr = 0;
                            }
                        }
                        catch (InterruptedException e) {
                            LOGGER.debug("Producer interrupted");
                            Thread.currentThread().interrupt();
                        }
                    }
                }
            };
            try {
                this.mProducer.run(consumer);
            }
            catch (Throwable t) {
                LOGGER.debug("Error while producing data", t);
                Throwable throwable = t;
                return throwable;
            }
            finally {
                consumer.finish();
            }
            return null;
        }
    }

    private static interface ProducerSink<T>
    extends Consumer<T> {
        public void finish();
    }

    public static final class ProducerFinished
    extends RuntimeException {
    }
}

