/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.complexible.common.base.Durations;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public final class Duration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long durationMS;

    public Duration(long time) {
        this.durationMS = time;
    }

    public Duration(long time, TimeUnit theUnit) {
        this(theUnit.toMillis(time));
    }

    public long getMillis() {
        return this.durationMS;
    }

    public long toUnit(TimeUnit theUnit) {
        return theUnit.convert(this.durationMS, TimeUnit.MILLISECONDS);
    }

    public int hashCode() {
        return (int)(this.durationMS ^ this.durationMS >>> 32);
    }

    public boolean equals(Object obj) {
        return obj instanceof Duration && this.durationMS == ((Duration)obj).durationMS;
    }

    public String toString() {
        return Durations.readable(this.durationMS);
    }

    public static Duration valueOf(String str) {
        return new Duration(Durations.parse(str));
    }
}

