/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.complexible.common.base.AbstractAutoDisposable;
import com.complexible.common.base.ActiveResources;
import com.complexible.common.base.AutoDisposable;
import com.complexible.common.base.CloseableIterator;
import com.complexible.common.base.Disposable;
import com.complexible.common.util.ShutDownHookManager;
import com.complexible.common.util.StackTrace;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Disposables {
    private static final Logger LOGGER = LoggerFactory.getLogger(Disposables.class);
    private static final boolean trackResources;
    private static final boolean multipleCreatesAsError;
    private static final boolean multipleReleasesAsError;
    private static final AtomicReference<ActiveResources> activeResources;

    private Disposables() {
        throw new AssertionError();
    }

    public static void logActiveResources() {
        ActiveResources resources = activeResources.get();
        if (!resources.isEmpty()) {
            int numberTypesForStackTraceLogging = 10;
            TreeMultimap activeTypeNamesByCount = TreeMultimap.create((Comparator)Ordering.natural().reverse(), (Comparator)Ordering.usingToString());
            for (Map.Entry<Class<?>, Long> entry : resources.typeCounts().entrySet()) {
                activeTypeNamesByCount.put((Object)entry.getValue(), entry.getKey());
            }
            System.out.println("Tracked resources that were not released (biggest leakers only):");
            ArrayList<Class<CloseableIterator>> stackTraceLoggingTypes = new ArrayList<Class<CloseableIterator>>();
            int i = 0;
            for (Map.Entry entry : activeTypeNamesByCount.entries()) {
                if (++i > 10) break;
                stackTraceLoggingTypes.add(0, (Class)entry.getValue());
            }
            stackTraceLoggingTypes.add(CloseableIterator.class);
            for (Class clazz : stackTraceLoggingTypes) {
                StringBuilder msg = new StringBuilder();
                msg.append(clazz).append(" created at these locations:\n");
                resources.creationSites(clazz).forEach(stackTrace -> msg.append(stackTrace).append("\n"));
                System.out.println(msg);
            }
            System.out.println("Types of leaked objects by count:");
            for (Map.Entry entry : activeTypeNamesByCount.entries()) {
                System.out.println(String.valueOf(entry.getKey()) + " " + String.valueOf(entry.getValue()));
            }
            System.out.println(resources.size() + " total objects not released.");
        } else {
            System.out.println("All tracked objects released.\n");
        }
    }

    public static ActiveResources getActiveResources() {
        return activeResources.get();
    }

    public static void resetActiveResources(Iterable<Class<?>> ignoredTypes) {
        activeResources.set(new ActiveResources(ignoredTypes));
    }

    public static <T> T markCreated(T resource) {
        StackTrace previous;
        if (trackResources && (previous = activeResources.get().add(resource)) != null && multipleCreatesAsError) {
            LOGGER.error("{} was initialized twice without being released.", resource);
            LOGGER.error("Previously initialized here: {}", (Object)previous);
            throw new IllegalStateException(String.valueOf(resource) + " was initialized twice without being released.");
        }
        return resource;
    }

    public static void markReleased(Object resource) {
        StackTrace previous;
        if (trackResources && (previous = activeResources.get().remove(resource)) == null && multipleReleasesAsError) {
            throw new IllegalStateException(String.valueOf(resource) + " was released without being initialized.");
        }
    }

    public static void dispose(Disposable theDisposable, Disposable ... theOtherDisposables) {
        if (theDisposable != null) {
            theDisposable.dispose();
        }
        if (theOtherDisposables != null) {
            for (Disposable aDisposable : theOtherDisposables) {
                if (aDisposable == null) continue;
                aDisposable.dispose();
            }
        }
    }

    public static void dispose(Iterable<? extends Disposable> theDisposables) {
        for (Disposable disposable : theDisposables) {
            disposable.dispose();
        }
    }

    public static void disposeIf(Object theObj) {
        if (theObj instanceof Disposable) {
            ((Disposable)theObj).dispose();
        }
    }

    public static void disposeQuietly(Disposable theDisposable) {
        try {
            theDisposable.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static AutoDisposable autoDispose(final Disposable theDisposable) {
        return new AbstractAutoDisposable(){

            @Override
            public void dispose() {
                theDisposable.dispose();
            }
        };
    }

    public static AutoCloseable asCloseable(Disposable disposable) {
        return disposable == null ? null : disposable::dispose;
    }

    static {
        activeResources = new AtomicReference<ActiveResources>(new ActiveResources());
        String trackValue = System.getProperty("stardog.resources.track", "false");
        trackResources = trackValue.equalsIgnoreCase("true");
        if (trackResources) {
            String multipleCreatesValue = System.getProperty("stardog.resources.track.allowMultipleCreates", "true");
            String multipleReleasesValue = System.getProperty("stardog.resources.track.allowMultipleReleases", "true");
            multipleCreatesAsError = multipleCreatesValue.equalsIgnoreCase("false");
            multipleReleasesAsError = multipleReleasesValue.equalsIgnoreCase("false");
            ShutDownHookManager.register("ActiveResources", Disposables::logActiveResources, 2);
        } else {
            multipleCreatesAsError = false;
            multipleReleasesAsError = false;
        }
    }
}

