/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import jakarta.xml.bind.DatatypeConverter;
import java.sql.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;

public final class DateTime {
    private final long dateTime;

    public static DateTime now() {
        return new DateTime(System.currentTimeMillis());
    }

    public DateTime(long time) {
        this.dateTime = time;
    }

    public long getTime() {
        return this.dateTime;
    }

    public Date toDate() {
        return new Date(this.dateTime);
    }

    public GregorianCalendar toCalendar() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(this.toDate());
        return calendar;
    }

    public int hashCode() {
        return (int)(this.dateTime ^ this.dateTime >>> 32);
    }

    public boolean equals(Object obj) {
        return obj instanceof DateTime && this.dateTime == ((DateTime)obj).dateTime;
    }

    public String toString() {
        return DatatypeConverter.printDateTime((Calendar)this.toCalendar());
    }

    public static DateTime valueOf(String str) {
        return new DateTime(DatatypeConverter.parseDateTime((String)str).getTime().getTime());
    }
}

