/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.complexible.common.base.Copyable;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public final class Copyables {
    private Copyables() {
        throw new AssertionError();
    }

    public static <T> ImmutableList<T> copy(ImmutableList<T> theList) {
        ImmutableList.Builder aBuilder = ImmutableList.builder();
        for (Object aElem : theList) {
            aBuilder.add(Copyables.copy(aElem));
        }
        return aBuilder.build();
    }

    public static <T> ImmutableSet<T> copy(ImmutableSet<T> theSet) {
        ImmutableSet.Builder aBuilder = ImmutableSet.builder();
        for (Object aElem : theSet) {
            aBuilder.add(Copyables.copy(aElem));
        }
        return aBuilder.build();
    }

    public static <K, V> ImmutableMap<K, V> copy(ImmutableMap<K, V> theMap) {
        ImmutableMap.Builder aBuilder = ImmutableMap.builder();
        for (Map.Entry aEntry : theMap.entrySet()) {
            aBuilder.put(Copyables.copy(aEntry.getKey()), Copyables.copy(aEntry.getValue()));
        }
        return aBuilder.build();
    }

    public static <T extends Copyable<T>, C extends Collection<T>> C copy(C theToCopy) {
        try {
            Collection aCopy = (Collection)theToCopy.getClass().newInstance();
            for (Copyable aObj : theToCopy) {
                aCopy.add(aObj.copy());
            }
            return (C)aCopy;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T extends Copyable<T>> T[] copy(T[] theArray) {
        Copyable[] aArray = (Copyable[])Arrays.copyOf(theArray, theArray.length);
        for (int i = 0; i < theArray.length; ++i) {
            aArray[i] = theArray[i].copy();
        }
        return aArray;
    }

    public static <T> T copy(T theObject) {
        if (theObject == null) {
            return null;
        }
        if (theObject instanceof Copyable) {
            return ((Copyable)theObject).copy();
        }
        return theObject;
    }

    public static <T> Optional<T> copy(Optional<T> theObj) {
        if (theObj.isPresent()) {
            return Optional.of((Object)Copyables.copy(theObj.get()));
        }
        return theObj;
    }
}

