/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Disposables;
import com.complexible.common.collect.ArrayIterator;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.Runnables;
import com.google.errorprone.annotations.MustBeClosed;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;

public interface CloseableIterator<T>
extends Iterator<T>,
AutoCloseable {
    @Override
    public void close() throws RuntimeException;

    @MustBeClosed
    public static <T> CloseableIterator<T> onClose(final CloseableIterator<T> theIter, final Runnable theRunnable) {
        return Disposables.markCreated(new CloseableIterator<T>(){

            @Override
            public void close() throws RuntimeException {
                Disposables.markReleased(this);
                try {
                    theIter.close();
                }
                finally {
                    theRunnable.run();
                }
            }

            @Override
            public boolean hasNext() {
                return theIter.hasNext();
            }

            @Override
            public T next() {
                return theIter.next();
            }
        });
    }

    public static void closeQuietly(Iterator<?> theIterator) {
        if (theIterator instanceof AutoCloseable) {
            try {
                ((AutoCloseable)((Object)theIterator)).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static <T> CloseableIterator<T> empty() {
        return new EmptyCloseableIterator();
    }

    @MustBeClosed
    public static <T> CloseableIterator<T> singleton(T theElem) {
        return CloseableIterator.toCloseable(Iterators.singletonIterator(theElem));
    }

    @MustBeClosed
    public static <T> CloseableIterator<T> of(T ... theElements) {
        return CloseableIterator.toCloseable(ArrayIterator.create(theElements));
    }

    @MustBeClosed
    public static <T> CloseableIterator<T> concat(final Iterable<? extends CloseableIterator<T>> theIters) {
        final Iterator aIter = Iterators.concat(theIters.iterator());
        return Disposables.markCreated(new AbstractCloseableIterator<T>(){

            protected T computeNext() {
                if (aIter.hasNext()) {
                    return aIter.next();
                }
                return this.endOfData();
            }

            @Override
            public void close() throws RuntimeException {
                Disposables.markReleased(this);
                AutoCloser.close(theIters);
            }
        });
    }

    public static <T> CloseableIterator<T> concat(final Iterator<? extends CloseableIterator<T>> inputs) {
        return new AbstractCloseableIterator<T>(){
            private CloseableIterator<T> mCurr = CloseableIterator.empty();

            protected T computeNext() {
                while (!this.mCurr.hasNext() && inputs.hasNext()) {
                    this.mCurr.close();
                    this.mCurr = (CloseableIterator)inputs.next();
                }
                if (!this.mCurr.hasNext()) {
                    this.mCurr.close();
                    return this.endOfData();
                }
                return this.mCurr.next();
            }

            @Override
            public void close() throws RuntimeException {
                this.mCurr.close();
                while (inputs.hasNext()) {
                    ((CloseableIterator)inputs.next()).close();
                }
            }
        };
    }

    public static <T> Optional<T> first(CloseableIterator<T> theIter) {
        try (CloseableIterator<T> aIter = theIter;){
            Optional optional = aIter.hasNext() ? Optional.of(aIter.next()) : Optional.empty();
            return optional;
        }
    }

    public static <T> Set<T> toSet(CloseableIterator<T> theIter) {
        return CloseableIterator.collect(theIter, Collectors.toSet());
    }

    public static <T> List<T> toList(CloseableIterator<T> theIter) {
        return CloseableIterator.collect(theIter, Collectors.toList());
    }

    public static <T, A, R> R collect(CloseableIterator<T> theIter, Collector<T, A, R> theCollector) {
        try (CloseableIterator<T> aIter = theIter;){
            Object aSupplier = theCollector.supplier().get();
            aIter.forEachRemaining(theElem -> theCollector.accumulator().accept(aSupplier, theElem));
            Object a = theCollector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH) ? theCollector.finisher().apply(aSupplier) : aSupplier;
            return (R)a;
        }
    }

    public static <T> long size(CloseableIterator<T> theIter) {
        long aSize = 0L;
        try (CloseableIterator<T> ac = theIter;){
            while (theIter.hasNext()) {
                theIter.next();
                ++aSize;
            }
        }
        catch (Exception e) {
            Throwables.propagateIfInstanceOf((Throwable)e, RuntimeException.class);
            throw Throwables.propagate((Throwable)e);
        }
        return aSize;
    }

    @MustBeClosed
    public static <T> CloseableIterator<T> offset(final CloseableIterator<T> theIter, final long theOffset) {
        return new AbstractCloseableIterator<T>(){
            private long mCount;

            @Override
            public void close() throws RuntimeException {
                theIter.close();
            }

            protected T computeNext() {
                while (this.mCount < theOffset && theIter.hasNext()) {
                    ++this.mCount;
                    theIter.next();
                }
                if (theIter.hasNext()) {
                    return theIter.next();
                }
                return this.endOfData();
            }
        };
    }

    @MustBeClosed
    public static <T> CloseableIterator<T> limit(final CloseableIterator<T> theIter, final long theLimit) {
        return new AbstractCloseableIterator<T>(){
            private long mCount;

            @Override
            public void close() throws RuntimeException {
                theIter.close();
            }

            protected T computeNext() {
                if (this.mCount < theLimit && theIter.hasNext()) {
                    ++this.mCount;
                    return theIter.next();
                }
                return this.endOfData();
            }
        };
    }

    @MustBeClosed
    public static <T> CloseableIterator<T> filter(final CloseableIterator<T> theIter, final Predicate<T> thePredicate) {
        return Disposables.markCreated(new AbstractCloseableIterator<T>(){

            protected T computeNext() {
                while (theIter.hasNext()) {
                    Object aObj = theIter.next();
                    if (!thePredicate.test(aObj)) continue;
                    return aObj;
                }
                return this.endOfData();
            }

            @Override
            public void close() throws RuntimeException {
                Disposables.markReleased(this);
                theIter.close();
            }
        });
    }

    @MustBeClosed
    public static <In, Out> CloseableIterator<Out> transform(final CloseableIterator<In> theIter, final Function<In, Out> theFunction) {
        return Disposables.markCreated(new AbstractCloseableIterator<Out>(){

            protected Out computeNext() {
                if (theIter.hasNext()) {
                    return theFunction.apply(theIter.next());
                }
                return this.endOfData();
            }

            @Override
            public void close() {
                Disposables.markReleased(this);
                theIter.close();
            }
        });
    }

    @MustBeClosed
    public static <T> CloseableIterator<T> toCloseable(Stream<T> theStream) {
        return new DelegatingCloseableIterator(theStream.iterator(), theStream::close);
    }

    @MustBeClosed
    public static <T> CloseableIterator<T> toCloseable(Iterator<? extends T> theIterator) {
        return CloseableIterator.toCloseable(theIterator, Runnables.doNothing());
    }

    @MustBeClosed
    public static <T> CloseableIterator<T> toCloseable(Iterator<? extends T> theIterator, Runnable theOnClose) {
        if (theIterator instanceof CloseableIterator) {
            return (CloseableIterator)theIterator;
        }
        if (theIterator instanceof AutoCloseable) {
            return new DelegatingCloseableIterator<T>(theIterator, () -> AutoCloser.close((AutoCloseable)((Object)theIterator)));
        }
        return new DelegatingCloseableIterator<T>(theIterator, theOnClose);
    }

    public static boolean isEmpty(CloseableIterator<?> theIterator) {
        try (CloseableIterator<?> ignored = theIterator;){
            boolean bl = !theIterator.hasNext();
            return bl;
        }
    }

    public static <I, O> CloseableIterator<O> map(final CloseableIterator<I> theIterator, final Function<? super I, O> theFunction) {
        return new AbstractCloseableIterator<O>(){

            @Override
            public void close() throws RuntimeException {
                theIterator.close();
            }

            protected O computeNext() {
                if (theIterator.hasNext()) {
                    return theFunction.apply(theIterator.next());
                }
                return this.endOfData();
            }
        };
    }

    public static <I, O> CloseableIterator<O> flatMap(final CloseableIterator<I> theIterator, final Function<? super I, ? extends CloseableIterator<O>> theFunction) {
        return new AbstractCloseableIterator<O>(){
            private CloseableIterator<O> mBatch = CloseableIterator.empty();

            @Override
            public void close() throws RuntimeException {
                AutoCloser.close(this.mBatch, theIterator);
            }

            @CheckForNull
            protected O computeNext() {
                while (!this.mBatch.hasNext()) {
                    this.mBatch.close();
                    this.mBatch = CloseableIterator.empty();
                    if (!theIterator.hasNext()) {
                        return this.endOfData();
                    }
                    this.mBatch = (CloseableIterator)theFunction.apply(theIterator.next());
                }
                return this.mBatch.next();
            }
        };
    }

    public static <I> CloseableIterator<I> concat(final CloseableIterator<I> theFirst, final CloseableIterator<I> theSecond) {
        return new AbstractCloseableIterator<I>(){
            private boolean mFirstDone = false;

            @Override
            public void close() throws RuntimeException {
                theFirst.close();
                theSecond.close();
            }

            protected I computeNext() {
                if (!this.mFirstDone) {
                    if (theFirst.hasNext()) {
                        return theFirst.next();
                    }
                    this.mFirstDone = true;
                }
                if (theSecond.hasNext()) {
                    return theSecond.next();
                }
                return this.endOfData();
            }
        };
    }

    public static class EmptyCloseableIterator<T>
    extends AbstractCloseableIterator<T> {
        protected T computeNext() {
            return (T)this.endOfData();
        }

        @Override
        public void close() throws RuntimeException {
        }
    }

    public static class DelegatingCloseableIterator<T>
    extends AbstractCloseableIterator<T> {
        private final Iterator<? extends T> mIter;
        private final Runnable mCloser;

        DelegatingCloseableIterator(Iterator<? extends T> theIter, Runnable theCloser) {
            this.mIter = theIter;
            this.mCloser = theCloser;
        }

        protected T computeNext() {
            if (this.mIter.hasNext()) {
                return this.mIter.next();
            }
            return (T)this.endOfData();
        }

        @Override
        public void close() {
            this.mCloser.run();
        }
    }

    public static abstract class AbstractCloseableIterator<T>
    extends AbstractIterator<T>
    implements CloseableIterator<T> {
    }
}

