/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Change;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;

public final class ChangeList<E extends Enum, T>
implements Iterable<Change<E, T>>,
AutoCloseable {
    private final List<Change<E, T>> mChanges = Lists.newArrayList();

    private ChangeList() {
    }

    public static <T, E extends Enum> ChangeList<E, T> create() {
        return new ChangeList<E, T>();
    }

    public void clear() {
        this.mChanges.clear();
    }

    @Override
    public void close() throws Exception {
        AutoCloser.close(this.mChanges);
    }

    public ChangeList<E, T> append(Change<E, T> theChange) {
        this.mChanges.add(theChange);
        return this;
    }

    public ChangeList<E, T> appendAll(Iterable<Change<E, T>> theChange) {
        Iterables.addAll(this.mChanges, theChange);
        return this;
    }

    public ChangeList<E, T> append(E theType, T theChange) {
        this.mChanges.add(Change.of(theType, theChange));
        return this;
    }

    public int size() {
        return this.mChanges.size();
    }

    public boolean isEmpty() {
        return this.mChanges.isEmpty();
    }

    @Override
    public Iterator<Change<E, T>> iterator() {
        return Iterators.unmodifiableIterator(this.mChanges.iterator());
    }
}

