/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.google.common.base.MoreObjects;
import java.util.Objects;

public final class Change<E extends Enum, T>
implements AutoCloseable {
    private final E mChangeType;
    private final T mChange;

    private Change(E theChangeType, T theChange) {
        this.mChangeType = theChangeType;
        this.mChange = theChange;
    }

    @Override
    public void close() throws Exception {
        if (this.mChange instanceof AutoCloseable) {
            ((AutoCloseable)this.mChange).close();
        }
    }

    public E getChangeType() {
        return this.mChangeType;
    }

    public <C extends Enum> boolean is(C theType) {
        return this.mChangeType == theType;
    }

    public T getChange() {
        return this.mChange;
    }

    public static <E extends Enum, T> Change<E, T> of(E theType, T theChange) {
        return new Change<E, T>(theType, theChange);
    }

    public boolean equals(Object theObj) {
        if (theObj == this) {
            return true;
        }
        if (theObj == null) {
            return false;
        }
        if (theObj instanceof Change) {
            Change aChange = (Change)theObj;
            return this.mChangeType == aChange.getChangeType() && Objects.equals(this.mChange, aChange.getChange());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mChange, this.mChangeType);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Change").add("type", this.mChangeType).add("data", this.mChange).toString();
    }
}

