/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.complexible.common.primitives.ArrayUtil;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class AtomicState<S extends Enum<S>> {
    private final AtomicBoolean mCancelFlag = new AtomicBoolean(false);
    private final ReentrantLock mLock = new ReentrantLock();
    private volatile S mState;

    public static <S extends Enum<S>> AtomicState<S> newState(S theInitState) {
        return new AtomicState<S>(theInitState);
    }

    public AtomicState(S theInitState) {
        Preconditions.checkNotNull(theInitState, (Object)"Initial state cannot be null");
        this.mState = theInitState;
    }

    public S beginTransitionFrom(S ... theStates) {
        this.mLock.lock();
        try {
            boolean aNotFound;
            S aState = this.mState;
            int aLength = theStates.length;
            boolean bl = aNotFound = aLength > 0 && ArrayUtil.sequentialSearch(theStates, aLength, aState) < 0;
            if (aNotFound) {
                throw new IllegalStateException("Unexpected state: " + String.valueOf(aState));
            }
            this.mCancelFlag.set(false);
            return aState;
        }
        catch (RuntimeException e) {
            this.mLock.unlock();
            throw e;
        }
    }

    public S tryBeginTransition(S ... thePossibleInitialStates) {
        boolean aNotFound;
        this.mLock.lock();
        S aState = this.mState;
        int aLength = thePossibleInitialStates.length;
        boolean bl = aNotFound = aLength > 0 && ArrayUtil.sequentialSearch(thePossibleInitialStates, aLength, aState) < 0;
        if (aNotFound) {
            this.mLock.unlock();
            return null;
        }
        this.mCancelFlag.set(false);
        return aState;
    }

    public void endTransition(S theFinalState) {
        this.set(theFinalState);
        this.endTransition();
    }

    public void endTransition() {
        this.mLock.unlock();
        this.mCancelFlag.set(false);
    }

    public void transitionTo(S theFinalState, S ... theInitialStates) {
        this.beginTransitionFrom((Enum[])theInitialStates);
        try {
            this.set(theFinalState);
        }
        finally {
            this.endTransition();
        }
    }

    public void cancelTransition() {
        this.mCancelFlag.set(true);
    }

    public boolean isTransitionCanceled() {
        return this.mCancelFlag.get();
    }

    public S get() {
        return this.mState;
    }

    public void set(S theState) {
        Preconditions.checkState((boolean)this.mLock.isHeldByCurrentThread(), (String)"Cannot set state to %s, did not start a transition", theState);
        this.mState = theState;
    }

    public void checkState(S theState) {
        Preconditions.checkState((theState == this.mState ? 1 : 0) != 0, (String)"Invalid state, expected: %s but got: %s", theState, this.mState);
    }

    public void checkState(Collection<S> theStates) {
        Preconditions.checkState((boolean)theStates.contains(this.mState), (String)"Invalid state, expected: %s but got: %s", theStates, this.mState);
    }

    public void checkStateNot(S theState) {
        Preconditions.checkState((theState != this.mState ? 1 : 0) != 0, (String)"Invalid state: %s", theState);
    }

    public boolean isInTransition() {
        return this.mLock.isLocked();
    }
}

