/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.complexible.common.util.StackTrace;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class ActiveResources {
    private static final int MAX_STACK_TRACE_DEPTH = 100;
    private final Map<Object, StackTrace> activeResources = Collections.synchronizedMap(new IdentityHashMap());
    private final ImmutableSet<Class<?>> trackedTypes;

    ActiveResources() {
        this.trackedTypes = ImmutableSet.of();
    }

    ActiveResources(Iterable<Class<?>> trackedTypes) {
        this.trackedTypes = ImmutableSet.copyOf(trackedTypes);
    }

    @Nullable
    public StackTrace add(Object object) {
        if (this.trackedTypes.isEmpty() || this.trackedTypes.stream().anyMatch(type -> type.isInstance(object))) {
            return this.activeResources.put(object, new StackTrace(100));
        }
        return null;
    }

    @Nullable
    public StackTrace remove(Object object) {
        return this.activeResources.remove(object);
    }

    public boolean isEmpty() {
        return this.activeResources.isEmpty();
    }

    public int size() {
        return this.activeResources.size();
    }

    public void clear() {
        this.activeResources.clear();
    }

    @Nullable
    public StackTrace creationStackTrace(Object object) {
        return this.activeResources.get(object);
    }

    public Stream<Object> resources() {
        return this.activeResources.keySet().stream();
    }

    public Stream<Object> resources(Class<?> type) {
        return this.resources().filter(type::isInstance);
    }

    public Stream<? extends Class> types() {
        return this.resources().map(Object::getClass).distinct();
    }

    public Stream<StackTrace> creationSites() {
        return this.resources().map(this::creationStackTrace).distinct();
    }

    public Stream<StackTrace> creationSites(Class<?> type) {
        return this.resources().filter(type::isInstance).map(this::creationStackTrace).distinct();
    }

    public Map<Class<?>, Long> typeCounts() {
        return this.resources().collect(Collectors.groupingBy(Object::getClass, Collectors.counting()));
    }

    public Map<StackTrace, Long> creationSiteCounts() {
        return this.resources().collect(Collectors.groupingBy(this::creationStackTrace, Collectors.counting()));
    }
}

