/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.base;

import com.complexible.common.base.AutoDisposable;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAutoDisposable
implements AutoDisposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAutoDisposable.class);
    private final AtomicInteger mRefCount = new AtomicInteger(0);

    @Override
    public <T extends AutoDisposable> T acquire() {
        int aRefCount = this.mRefCount.incrementAndGet();
        LOGGER.trace("RefCount++ {} {}", (Object)aRefCount, (Object)this);
        return (T)this;
    }

    @Override
    public <T extends AutoDisposable> T tryAcquire() {
        int aRefCount = this.mRefCount.getAndIncrement();
        if (aRefCount > 0) {
            LOGGER.trace("RefCount++ {} {}", (Object)aRefCount, (Object)this);
            return (T)this;
        }
        this.mRefCount.decrementAndGet();
        LOGGER.trace("Acquire failed on {}", (Object)this);
        return null;
    }

    @Override
    public void release() {
        int aRefCount = this.mRefCount.decrementAndGet();
        LOGGER.trace("RefCount-- {} {}", (Object)aRefCount, (Object)this);
        if (aRefCount == 0) {
            this.dispose();
        }
    }

    @Override
    public int getRefCount() {
        return this.mRefCount.get();
    }
}

