/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LinuxDistribution {
    private static final Logger logger = LoggerFactory.getLogger(LinuxDistribution.class);
    private Distribution distribution = Distribution.UNKNOWN;
    private String versionId = "";
    private int majorVersion = -1;
    private int minorVersion = 0;

    private LinuxDistribution() {
    }

    @VisibleForTesting
    public LinuxDistribution(Distribution distribution, String versionId, int majorversion, int minorVersion) {
        this.distribution = distribution;
        this.versionId = versionId;
        this.majorVersion = majorversion;
        this.minorVersion = minorVersion;
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public String toString() {
        return this.distribution.toString() + " " + String.valueOf(this.majorVersion) + "." + String.valueOf(this.minorVersion) + " (" + this.versionId + ")";
    }

    static LinuxDistribution determineDistribution() {
        Preconditions.checkState((boolean)System.getProperty("os.name").toLowerCase(Locale.US).contains("linux"));
        return LinuxDistribution.determineDistribution((List<String>)ImmutableList.of((Object)"/etc/os-release", (Object)"/etc/lsb-release", (Object)"/etc/centos-release", (Object)"/etc/redhat-release", (Object)"/etc/issue"));
    }

    @VisibleForTesting
    static LinuxDistribution determineDistribution(List<String> indicatorFiles) {
        ArrayList<String> availableFiles = new ArrayList<String>();
        for (String filename : indicatorFiles) {
            File file = new File(filename);
            if (!file.exists() || !file.canRead()) continue;
            availableFiles.add(filename);
            ImmutableList parsers = ImmutableList.of((Object)new OsReleaseParser(), (Object)new LsbReleaseParser(), (Object)new IssueParser());
            for (LinuxDistributionParser parser : parsers) {
                if (!parser.matches(file)) continue;
                try {
                    LinuxDistribution result = parser.parse(file);
                    logger.info("Determined Linux distribution from file '" + file.getAbsolutePath() + "': " + String.valueOf(result));
                    return result;
                }
                catch (IOException iOException) {
                }
            }
        }
        if (availableFiles.isEmpty()) {
            logger.warn("Could not determine Linux distribution. No indicator file present and readable. Files tried: " + indicatorFiles.toString());
        } else {
            logger.warn("Could not determine Linux distribution. Could not find suitable parser for any of the available files. Files tried: " + ((Object)availableFiles).toString());
        }
        return new LinuxDistribution();
    }

    public static enum Distribution {
        UNKNOWN{

            public String toString() {
                return "Unknown";
            }
        }
        ,
        UBUNTU{

            public String toString() {
                return "Ubuntu";
            }
        }
        ,
        CENTOS{

            public String toString() {
                return "CentOS";
            }
        }
        ,
        RHEL{

            public String toString() {
                return "RHEL";
            }
        }
        ,
        AMAZON_LINUX{

            public String toString() {
                return "Amazon Linux";
            }
        };

    }

    private static final class OsReleaseParser
    implements LinuxDistributionParser {
        private OsReleaseParser() {
        }

        @Override
        public boolean matches(File file) {
            try {
                List lines = Files.readLines((File)file, (Charset)Charsets.UTF_8);
                for (String line : lines) {
                    if (!line.startsWith("NAME=")) continue;
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        public LinuxDistribution parse(File file) throws IOException {
            LinuxDistribution result = new LinuxDistribution();
            ImmutableMap lineHandlers = ImmutableMap.of((Object)"ID=ubuntu", matcher -> {
                result.distribution = Distribution.UBUNTU;
            }, (Object)"ID=\"centos\"", matcher -> {
                result.distribution = Distribution.CENTOS;
            }, (Object)"ID=\"rhel\"", matcher -> {
                result.distribution = Distribution.RHEL;
            }, (Object)"ID=\"amzn\"", matcher -> {
                result.distribution = Distribution.AMAZON_LINUX;
            }, (Object)"VERSION_ID=\"(?<versionId>(?<majorVersion>\\d+)\\.?(?<minorVersion>\\d*))\"", matcher -> LinuxDistributionParser.handleVersionMatch(matcher, result));
            List lines = Files.readLines((File)file, (Charset)Charsets.UTF_8);
            for (String line : lines) {
                lineHandlers.forEach((pattern, action) -> {
                    Matcher matcher = Pattern.compile(pattern).matcher(line);
                    if (matcher.matches()) {
                        action.accept(matcher);
                    }
                });
            }
            return result;
        }
    }

    private static final class LsbReleaseParser
    implements LinuxDistributionParser {
        private LsbReleaseParser() {
        }

        @Override
        public boolean matches(File file) {
            try {
                List lines = Files.readLines((File)file, (Charset)Charsets.UTF_8);
                for (String line : lines) {
                    if (!line.startsWith("DISTRIB_ID=")) continue;
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        public LinuxDistribution parse(File file) throws IOException {
            LinuxDistribution result = new LinuxDistribution();
            ImmutableMap lineHandlers = ImmutableMap.of((Object)"DISTRIB_ID=Ubuntu", matcher -> {
                result.distribution = Distribution.UBUNTU;
            }, (Object)"DISTRIB_RELEASE=(?<versionId>(?<majorVersion>\\d+)\\.?(?<minorVersion>\\d*))", matcher -> LinuxDistributionParser.handleVersionMatch(matcher, result));
            List lines = Files.readLines((File)file, (Charset)Charsets.UTF_8);
            for (String line : lines) {
                lineHandlers.forEach((pattern, action) -> {
                    Matcher matcher = Pattern.compile(pattern).matcher(line);
                    if (matcher.matches()) {
                        action.accept(matcher);
                    }
                });
            }
            return result;
        }
    }

    private static final class IssueParser
    implements LinuxDistributionParser {
        private IssueParser() {
        }

        @Override
        public boolean matches(File file) {
            try {
                LinuxDistribution result = this.parse(file);
                return result.distribution != Distribution.UNKNOWN;
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        public LinuxDistribution parse(File file) throws IOException {
            LinuxDistribution result = new LinuxDistribution();
            ImmutableMap lineHandlers = ImmutableMap.of((Object)"CentOS release (?<versionId>(?<majorVersion>\\d+)\\.?(?<minorVersion>\\d*)) \\(\\w+\\)", matcher -> {
                result.distribution = Distribution.CENTOS;
                LinuxDistributionParser.handleVersionMatch(matcher, result);
            }, (Object)"Red Hat Enterprise Linux Server release (?<versionId>(?<majorVersion>\\d+)\\.?(?<minorVersion>\\d*)) \\(\\w+\\)", matcher -> {
                result.distribution = Distribution.RHEL;
                LinuxDistributionParser.handleVersionMatch(matcher, result);
            }, (Object)"Red Hat Enterprise Linux release (?<versionId>(?<majorVersion>\\d+)\\.?(?<minorVersion>\\d*)) \\(\\w+\\)", matcher -> {
                result.distribution = Distribution.RHEL;
                LinuxDistributionParser.handleVersionMatch(matcher, result);
            });
            List lines = Files.readLines((File)file, (Charset)Charsets.UTF_8);
            for (String line : lines) {
                lineHandlers.forEach((pattern, action) -> {
                    Matcher matcher = Pattern.compile(pattern).matcher(line);
                    if (matcher.matches()) {
                        action.accept(matcher);
                    }
                });
            }
            return result;
        }
    }

    private static interface LinuxDistributionParser {
        public static final String GROUP_VERSION_ID = "versionId";
        public static final String GROUP_MAJOR_VERSION = "majorVersion";
        public static final String GROUP_MINOR_VERSION = "minorVersion";
        public static final String VERSION_REGULAR_EXPRESSION = "(?<versionId>(?<majorVersion>\\d+)\\.?(?<minorVersion>\\d*))";

        public boolean matches(File var1);

        public LinuxDistribution parse(File var1) throws IOException;

        public static void handleVersionMatch(Matcher matcher, LinuxDistribution result) {
            result.versionId = matcher.group(GROUP_VERSION_ID);
            result.majorVersion = Integer.parseInt(matcher.group(GROUP_MAJOR_VERSION));
            String minorVersionString = matcher.group(GROUP_MINOR_VERSION);
            result.minorVersion = minorVersionString.isEmpty() ? 0 : Integer.parseInt(minorVersionString);
        }
    }
}

