/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.language;

import com.stardog.stark.Literal;
import com.stardog.stark.Values;
import com.stardog.stark.io.InvalidLiteral;
import com.stardog.stark.io.LanguageHandler;
import java.util.IllformedLocaleException;
import java.util.Locale;
import javax.annotation.Nonnull;

public final class BCP47LanguageHandler
implements LanguageHandler {
    @Override
    public boolean isRecognizedLanguage(@Nonnull String theLang) {
        try {
            this.normalizeLanguageTag(theLang);
        }
        catch (IllformedLocaleException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean verifyLanguage(@Nonnull String theValue, @Nonnull String theLang) throws InvalidLiteral {
        if (this.isRecognizedLanguage(theLang)) {
            return true;
        }
        throw new InvalidLiteral("Could not verify BCP47 language tag " + theLang);
    }

    @Override
    @Nonnull
    public Literal normalizeLanguage(@Nonnull String theValue, @Nonnull String theLang) throws InvalidLiteral {
        try {
            return Values.literal((String)theValue, (String)this.normalizeLanguageTag(theLang));
        }
        catch (IllformedLocaleException e) {
            throw new InvalidLiteral("Could not normalize BCP47 language tag: " + theLang, e);
        }
    }

    @Override
    @Nonnull
    public String key() {
        return "com.stardog.stark.io.languages.BCP47";
    }

    @Override
    public String normalizeLanguageTag(@Nonnull String theLang) throws IllformedLocaleException {
        return new Locale.Builder().setLanguageTag(theLang).build().toLanguageTag().intern();
    }
}

