/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io;

import com.complexible.common.net.MediaTypes;
import com.google.common.io.Files;
import com.stardog.stark.io.FileFormat;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public final class SupportedFileFormats<T extends FileFormat> {
    private final Set<T> mFormats;
    private final Map<String, T> mAliases;

    public SupportedFileFormats() {
        this(new LinkedHashSet(), new LinkedHashMap());
    }

    protected SupportedFileFormats(Set<T> theFormats, Map<String, T> theAliases) {
        this.mFormats = theFormats;
        this.mAliases = theAliases;
    }

    @Nonnull
    public SupportedFileFormats<T> add(@Nonnull T theFormat) {
        this.mFormats.add(theFormat);
        return this;
    }

    public boolean contains(@Nonnull T theFormat) {
        return this.mFormats.contains(theFormat);
    }

    public SupportedFileFormats<T> alias(@Nonnull String theAlias, @Nonnull T theFormat) {
        this.add(theFormat);
        this.mAliases.put(theAlias, theFormat);
        return this;
    }

    @Nonnull
    public Optional<T> forFile(@Nonnull Path thePath) {
        return this.forFileName(thePath.toString());
    }

    @Nonnull
    public Optional<T> forFileName(@Nonnull String thePath) {
        String aExtension = Files.getFileExtension((String)thePath).toLowerCase();
        if ("".equals(aExtension)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.mFormats.stream().filter(f -> f.defaultExtension().toLowerCase().equals(aExtension)).findFirst().orElseGet(() -> this.mFormats.stream().filter(f -> f.extensions().map(String::toLowerCase).anyMatch(aExtension::equals)).findFirst().orElse(null)));
    }

    @Nonnull
    public Optional<T> forName(@Nonnull String theName) {
        if (theName.isEmpty()) {
            return Optional.empty();
        }
        String aName = theName.toUpperCase();
        FileFormat aFormat = this.mAliases.getOrDefault(aName, null);
        if (aFormat != null) {
            return Optional.of(aFormat);
        }
        aFormat = this.mFormats.stream().filter(f -> f.name().toUpperCase().equals(aName)).findFirst().orElse(null);
        return Optional.ofNullable(aFormat);
    }

    @Nonnull
    public Optional<T> forMime(@Nonnull String theMime) {
        if (theMime.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.mFormats.stream().filter(f -> MediaTypes.isCompatibleWith((String)f.defaultMimeType(), (String)theMime)).findFirst().orElseGet(() -> this.mFormats.stream().filter(f -> f.mimeTypes().map(MediaTypes::parseMime).anyMatch(MediaTypes.isCompatibleWith((String)theMime))).findFirst().orElse(null)));
    }

    @Nonnull
    public SupportedFileFormats<T> only(@Nonnull Predicate<T> thePredicate) {
        return new SupportedFileFormats<FileFormat>(this.mFormats.stream().filter(thePredicate).collect(Collectors.toSet()), this.mAliases.entrySet().stream().filter(e -> thePredicate.test((FileFormat)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public void forEach(@Nonnull Consumer<T> theConsumer) {
        this.mFormats.forEach(theConsumer);
    }
}

