/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io;

import com.complexible.common.base.Options;
import com.complexible.common.util.ServiceLoaders;
import com.google.common.base.Preconditions;
import com.stardog.stark.Statement;
import com.stardog.stark.io.CollectingRDFHandler;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.io.ParserOptions;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFHandlers;
import com.stardog.stark.io.RDFParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public final class RDFParsers {
    private static final Map<RDFFormat, RDFParser> PARSERS = new HashMap<RDFFormat, RDFParser>();

    private RDFParsers() {
        throw new AssertionError();
    }

    public static void register(RDFParser theParser) {
        PARSERS.put(theParser.format(), theParser);
        RDFFormats.register(theParser.format());
    }

    @Nonnull
    public static Optional<RDFParser> forFormat(@Nonnull RDFFormat theFormat) {
        Preconditions.checkNotNull((Object)theFormat);
        RDFFormat aBaseFormat = RDFFormats.baseFormat(theFormat);
        return Optional.ofNullable(PARSERS.get(aBaseFormat));
    }

    @Nonnull
    public static Set<Statement> read(@Nonnull InputStream theStream, @Nonnull RDFFormat theFormat) throws IOException {
        return RDFParsers.read(theStream, theFormat, ParserOptions.defaults());
    }

    @Nonnull
    public static Set<Statement> read(@Nonnull String theInput, @Nonnull RDFFormat theFormat) throws IOException {
        return RDFParsers.read(theInput, theFormat, ParserOptions.defaults());
    }

    @Nonnull
    public static Set<Statement> read(@Nonnull String theInput, @Nonnull RDFFormat theFormat, @Nonnull Options theOptions) throws IOException {
        try (ByteArrayInputStream aIn = new ByteArrayInputStream(theInput.getBytes(theFormat.charset()));){
            Set<Statement> set = RDFParsers.read(aIn, theFormat, theOptions);
            return set;
        }
    }

    @Nonnull
    public static Set<Statement> read(@Nonnull InputStream theStream, @Nonnull RDFFormat theFormat, @Nonnull Options theOptions) throws IOException {
        return RDFParsers.read(theStream, theFormat, theOptions, RDFHandlers.toSet());
    }

    @Nonnull
    public static Set<Statement> read(@Nonnull Path thePath) throws IOException {
        return RDFParsers.read(thePath, RDFFormats.forFile(thePath).orElseThrow(() -> new IllegalArgumentException(String.format("'%s' is not a recognized RDF file format", com.google.common.io.Files.getFileExtension((String)thePath.toString())))), ParserOptions.defaults());
    }

    @Nonnull
    public static Set<Statement> read(@Nonnull Path thePath, @Nonnull RDFFormat theFormat) throws IOException {
        return RDFParsers.read(thePath, theFormat, ParserOptions.defaults());
    }

    @Nonnull
    public static Set<Statement> read(@Nonnull Path thePath, @Nonnull RDFFormat theFormat, @Nonnull Options theOptions) throws IOException {
        return RDFParsers.read(thePath, theFormat, theOptions, RDFHandlers.toSet());
    }

    public static <T> T read(@Nonnull Path thePath, @Nonnull RDFFormat theFormat, @Nonnull Options theOptions, @Nonnull CollectingRDFHandler<T> theHandler) throws IOException {
        try (InputStream aStream = Files.newInputStream(thePath, new OpenOption[0]);){
            T t = RDFParsers.read(aStream, theFormat, theOptions, theHandler);
            return t;
        }
    }

    public static <T> T read(@Nonnull InputStream theStream, @Nonnull RDFFormat theFormat, @Nonnull Options theOptions, @Nonnull CollectingRDFHandler<T> theHandler) throws IOException {
        RDFParsers.read(theStream, theFormat, theOptions, theHandler);
        return theHandler.result();
    }

    public static void read(@Nonnull InputStream theStream, @Nonnull RDFFormat theFormat, @Nonnull Options theOptions, @Nonnull RDFHandler theHandler) throws IOException {
        FileFormat.Compression aCompression = RDFFormats.compressionOf(theFormat);
        InputStream aInput = aCompression.decompress(theStream);
        RDFParser aParser = RDFParsers.forFormat(theFormat).orElseThrow(() -> new IllegalArgumentException("Unknown rdf format: " + String.valueOf(theFormat)));
        aParser.parse(aInput, theHandler, theOptions);
    }

    static {
        ServiceLoaders.instancesOf(RDFParser.class).forEach(p -> PARSERS.put(p.format(), (RDFParser)p));
        PARSERS.keySet().forEach(RDFFormats::register);
    }
}

