/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io;

import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.google.common.collect.ImmutableSet;
import com.stardog.stark.Namespace;
import com.stardog.stark.Namespaces;
import com.stardog.stark.io.LanguageHandler;
import com.stardog.stark.io.language.BCP47LanguageHandler;
import javax.annotation.Nonnull;

public final class ParserOptions {
    public static final Option<String> BASE_IRI = Option.create((String)"stark.io.base.iri", (Object)"http://api.stardog.com/");
    public static final Option<Iterable<Namespace>> NAMESPACES = Option.create((String)"stark.io.namespaces", (Object)Namespaces.EXTENDED);
    public static final Option<Boolean> VERIFY_DATATYPES = Option.create((String)"stark.io.verify.datatypes", (Object)false);
    public static final Option<Boolean> VERIFY_LANG = Option.create((String)"stark.io.verify.lang", (Object)true);
    public static final Option<Boolean> VERIFY_RELATIVE_IRIS = Option.create((String)"stark.io.verify.iri.relative", (Object)true);
    public static final Option<Boolean> VERIFY_IRI_SYNTAX = Option.create((String)"stark.io.verify.iri.syntax", (Object)true);
    public static final Option<Boolean> NORMALIZE_DATATYPES = Option.create((String)"stark.io.normalize.datatypes", (Object)false);
    public static final Option<Boolean> NORMALIZE_LANG = Option.create((String)"stark.io.normalize.lang", (Object)false);
    public static final Option<LanguageHandler> LANG_HANDLER = Option.create((String)"stark.io.handler.lang", (Object)new BCP47LanguageHandler());
    public static final Option<Boolean> PRESERVE_BNODE_IDS = Option.create((String)"stark.io.preserve.bnode.ids", (Object)true);
    public static final Option<Boolean> CASE_INSENSITIVE_DIRECTIVES = Option.create((String)"stark.io.ttl.case.insensitive.directives", (Object)false);
    public static final Option<Boolean> FAIL_ON_INVALID_LINES = Option.create((String)"stark.io.nt.fail.invalid.lines", (Object)true);
    public static final Option<Boolean> SECURE_PROCESSING = Option.create((String)"http://javax.xml.XMLConstants/feature/secure-processing", (Object)true);
    public static final Option<Boolean> FAIL_ON_SAX_NON_FATAL_ERRORS = Option.create((String)"stark.io.rdfxml.fail.saxnonfatalerrors", (Object)true);
    public static final Option<Boolean> FAIL_ON_NON_STANDARD_ATTRIBUTES = Option.create((String)"stark.io.rdfxml.fail.nonstandardattributes", (Object)true);
    public static final Option<Boolean> FAIL_ON_INVALID_NCNAME = Option.create((String)"stark.io.rdfxml.fail.invalidncname", (Object)true);
    public static final Option<Boolean> FAIL_ON_DUPLICATE_RDF_ID = Option.create((String)"stark.io.rdfxml.fail.duplicaterdfid", (Object)true);
    public static final Option<Boolean> FAIL_ON_INVALID_QNAME = Option.create((String)"stark.io.rdfxml.fail.invalidqname", (Object)true);
    public static final Option<Boolean> FAIL_ON_MISMATCHED_TAGS = Option.create((String)"stark.io.rdfxml.fail.mismatchedtags", (Object)true);
    private static final ImmutableSet<Option> STRICT_SETTINGS = ImmutableSet.of(VERIFY_DATATYPES, VERIFY_LANG, NORMALIZE_DATATYPES, VERIFY_RELATIVE_IRIS, VERIFY_IRI_SYNTAX, FAIL_ON_DUPLICATE_RDF_ID, (Object[])new Option[]{FAIL_ON_INVALID_NCNAME, FAIL_ON_INVALID_QNAME, FAIL_ON_NON_STANDARD_ATTRIBUTES, FAIL_ON_MISMATCHED_TAGS, FAIL_ON_SAX_NON_FATAL_ERRORS, FAIL_ON_INVALID_LINES});

    private ParserOptions() {
        throw new AssertionError();
    }

    @Nonnull
    public static Options defaults() {
        return Options.create();
    }

    @Nonnull
    public static Options namespaces(@Nonnull Iterable<Namespace> theNamespaces) {
        return ParserOptions.defaults().set(NAMESPACES, theNamespaces);
    }

    @Nonnull
    public static Options baseIRI(@Nonnull String theIRI) {
        return ParserOptions.defaults().set(BASE_IRI, (Object)theIRI);
    }

    @Nonnull
    public static Options strict() {
        Options aOpts = ParserOptions.defaults();
        STRICT_SETTINGS.forEach(aOpt -> aOpts.set(aOpt, (Object)true));
        return aOpts;
    }

    @Nonnull
    public static Options lax() {
        Options aOpts = ParserOptions.defaults();
        aOpts.set(LANG_HANDLER, null);
        STRICT_SETTINGS.forEach(aOpt -> aOpts.set(aOpt, (Object)false));
        return aOpts;
    }
}

