/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io;

import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.google.common.hash.Hashing;
import com.stardog.stark.BNode;
import com.stardog.stark.Datatype;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.impl.NamespacesImpl;
import com.stardog.stark.io.AbstractRDFHandler;
import com.stardog.stark.io.DatatypeHandler;
import com.stardog.stark.io.DatatypeHandlers;
import com.stardog.stark.io.InvalidLiteral;
import com.stardog.stark.io.InvalidRDF;
import com.stardog.stark.io.LanguageHandler;
import com.stardog.stark.io.ParserOptions;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.util.ParsedURI;
import com.stardog.stark.vocabs.RDF;
import jakarta.xml.bind.DatatypeConverter;
import java.io.UnsupportedEncodingException;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ParserContext
extends AbstractRDFHandler {
    public static final Option<String> BNODE_ID_PREFIX = Option.create((String)"stark.io.bnode.ids.prefix");
    private final boolean verifyDatatypeValues;
    private final boolean normalizeDatatypeValues;
    private final LanguageHandler languageHandler;
    private final boolean normalizeLanguageTags;
    private final boolean verifyLanguageTags;
    public final boolean caseInsensitiveDirectives;
    private final Options mOptions;
    private final RDFHandler mHandler;
    protected final NamespacesImpl mNamespaces = new NamespacesImpl();
    private final String nextBNodePrefix;
    private long nextBNodeId = 0L;
    public long mLineNumber = 1L;
    public long mColumnNumber = -1L;
    public Resource mSubject;
    public IRI mPredicate;
    public Value mObject;
    public Resource mContext = Values.DEFAULT_GRAPH;
    public ParsedURI mBaseIRI;
    private final StringBuilder mUriBuilder = new StringBuilder(512);

    public ParserContext(@Nonnull RDFHandler theHandler, @Nonnull Options theOptions) {
        this.mOptions = theOptions;
        this.mHandler = theHandler;
        this.languageHandler = (LanguageHandler)theOptions.get(ParserOptions.LANG_HANDLER);
        this.normalizeLanguageTags = theOptions.is(ParserOptions.NORMALIZE_LANG);
        this.normalizeDatatypeValues = theOptions.is(ParserOptions.NORMALIZE_DATATYPES);
        this.verifyDatatypeValues = theOptions.is(ParserOptions.VERIFY_DATATYPES);
        this.verifyLanguageTags = theOptions.is(ParserOptions.VERIFY_LANG);
        this.mBaseIRI = new ParsedURI((String)theOptions.get(ParserOptions.BASE_IRI));
        this.caseInsensitiveDirectives = theOptions.is(ParserOptions.CASE_INSENSITIVE_DIRECTIVES);
        String bnodeIdPrefix = (String)theOptions.get(BNODE_ID_PREFIX);
        this.nextBNodePrefix = bnodeIdPrefix != null ? bnodeIdPrefix : ParserContext.getRandomBnodeIdPrefix();
        ((Iterable)theOptions.get(ParserOptions.NAMESPACES)).forEach(arg_0 -> ((NamespacesImpl)this.mNamespaces).add(arg_0));
    }

    @Nonnull
    public IRI resolveURI(@Nonnull String theIRISpec) throws InvalidRDF {
        ParsedURI uri = new ParsedURI(theIRISpec);
        if (uri.isRelative()) {
            if (this.mBaseIRI == null) {
                throw this.error("Unable to resolve URIs, no base URI has been set");
            }
            if (this.is(ParserOptions.VERIFY_RELATIVE_IRIS) && uri.isRelative() && !uri.isSelfReference() && this.mBaseIRI.isOpaque()) {
                this.error("Relative URI '" + theIRISpec + "' cannot be resolved using the opaque base URI '" + String.valueOf(this.mBaseIRI) + "'", ParseError.OpaqueBaseWithRelativeIRI);
            }
            uri = this.mBaseIRI.resolve(uri);
        }
        this.mUriBuilder.setLength(0);
        String aIRI = uri.toString(this.mUriBuilder);
        if (this.is(ParserOptions.VERIFY_IRI_SYNTAX)) {
            if (Values.containsInvalidIRICharacters((String)aIRI)) {
                throw this.error(String.format("%s includes invalid characters", aIRI));
            }
            if (Values.containsLeadingOrTrailingWhitespace((String)aIRI)) {
                throw this.error(String.format("%s includes leading or trailing whitespace", aIRI));
            }
        }
        return Values.iri((String)aIRI);
    }

    public boolean is(Option<Boolean> theParserOption) {
        return this.mOptions.is(theParserOption);
    }

    @Override
    public void start() {
        this.mHandler.start();
    }

    @Override
    public void end() {
        this.mHandler.end();
    }

    @Override
    public void handle(@Nonnull Statement theStatement) {
        this.mHandler.handle(theStatement);
    }

    @Override
    public void namespace(@Nonnull String thePrefix, @Nonnull String theIRI) {
        this.mNamespaces.add(thePrefix, theIRI);
        this.mHandler.namespace(thePrefix, theIRI);
    }

    @Nonnull
    public String namespace(@Nonnull String thePrefix) {
        Optional aNS = this.mNamespaces.iri(thePrefix);
        if (aNS.isPresent()) {
            return (String)aNS.get();
        }
        throw this.error((String)("".equals(thePrefix) ? "Default namespace used but not defined" : "Namespace prefix '" + thePrefix + "' used but not defined"));
    }

    public Statement currentStatement() {
        return Values.statement((Resource)this.mSubject, (IRI)this.mPredicate, (Value)this.mObject, (Resource)this.mContext);
    }

    public void reportStatement() {
        this.mHandler.handle(this.currentStatement());
    }

    public void resetStatement() {
        this.mSubject = null;
        this.mPredicate = null;
        this.mObject = null;
        this.mContext = Values.DEFAULT_GRAPH;
    }

    public InvalidRDF error(String theMsg) {
        this.error(theMsg, ParseError.Fatal);
        return null;
    }

    public void error(String theMsg, ParseError theError) {
        throw new InvalidRDF(theMsg, this.mLineNumber, this.mColumnNumber);
    }

    public Literal createLiteral(@Nonnull String label, @Nullable String lang, @Nullable IRI datatype) throws InvalidRDF {
        Datatype aDt;
        DatatypeHandler nextHandler;
        Literal result = null;
        String workingLabel = label;
        String workingLang = lang;
        IRI workingDatatype = datatype;
        if (workingLang != null && (workingDatatype == null || RDF.LANG_STRING.equals((Object)workingDatatype))) {
            if (this.verifyLanguageTags) {
                try {
                    if (!this.languageHandler.isRecognizedLanguage(workingLang) || !this.languageHandler.verifyLanguage(workingLabel, workingLang)) {
                        this.error(String.format("'%s' is not a valid language tag ", lang), ParseError.Unknown_Lang);
                    }
                }
                catch (InvalidLiteral e) {
                    this.error(String.format("'%s' did not have a valid value for language %s: %s", label, lang, e.getMessage()), ParseError.Invalid_Lang);
                }
            }
            if (this.normalizeLanguageTags) {
                try {
                    workingLang = this.languageHandler.normalizeLanguageTag(workingLang);
                }
                catch (Exception e) {
                    this.error(String.format("'%s' did not have a valid value for language %s: %s", label, lang, e.getMessage()), ParseError.Invalid_Lang);
                }
            }
        } else if (workingDatatype != null && (this.verifyDatatypeValues || this.normalizeDatatypeValues) && (nextHandler = DatatypeHandlers.handlerFor(aDt = Datatype.of((IRI)workingDatatype))) != null) {
            if (this.verifyDatatypeValues) {
                try {
                    if (!nextHandler.verifyDatatype(workingLabel, aDt)) {
                        this.error(String.format("'%s' is not a valid value for datatype %s", label, datatype), ParseError.Invalid_Datatype);
                    }
                }
                catch (InvalidLiteral e) {
                    this.error(String.format("'%s' could not be verified by a datatype handler that recognised it. datatype was %s", label, datatype), ParseError.UNKNOWN_DATATYPE);
                }
            }
            if (this.normalizeDatatypeValues) {
                try {
                    result = nextHandler.normalizeDatatype(workingLabel, aDt);
                    workingLabel = result.label();
                    workingLang = result.lang().orElse(null);
                    workingDatatype = result.datatypeIRI();
                }
                catch (InvalidLiteral e) {
                    this.error(String.format("'%s' is not a valid value for datatype %s: %s and could not be normalised", label, datatype, e.getMessage()), ParseError.Invalid_Datatype);
                }
            }
        }
        if (result == null) {
            result = workingLang != null && (workingDatatype == null || RDF.LANG_STRING.equals((Object)workingDatatype)) ? Values.literal((String)workingLabel, (String)workingLang) : (workingDatatype != null ? Values.literal((String)workingLabel, (IRI)workingDatatype) : Values.literal((String)workingLabel));
        }
        return result;
    }

    public BNode createBNode() {
        return Values.bnode((String)("anon-" + this.nextBNodePrefix + this.nextBNodeId++));
    }

    public BNode createBNode(@Nonnull String theNodeID) {
        if (this.is(ParserOptions.PRESERVE_BNODE_IDS)) {
            return Values.bnode((String)theNodeID);
        }
        String toAppend = theNodeID;
        if (theNodeID.length() > 32) {
            byte[] chars = null;
            try {
                chars = theNodeID.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            toAppend = DatatypeConverter.printHexBinary((byte[])Hashing.md5().hashBytes(chars).asBytes());
        }
        return Values.bnode((String)(this.nextBNodePrefix + toAppend));
    }

    public static String getRandomBnodeIdPrefix() {
        return "genid-" + UUID.randomUUID().toString().replaceAll("-", "") + "-";
    }

    public static enum ParseError {
        Unknown_Lang,
        Invalid_Lang,
        UNKNOWN_DATATYPE,
        OpaqueBaseWithRelativeIRI,
        Invalid_IRI_Escapes,
        Invalid_Lang_Start,
        Invalid_Lang_Char,
        Invalid_BNode_Start,
        InvalidIRI,
        INVALID_STRING_ENCODING,
        Invalid_Number,
        Invalid_Datatype,
        Fatal;

        private final boolean mIsFatal;

        private ParseError() {
            this(true);
        }

        private ParseError(boolean isFatal) {
            this.mIsFatal = isFatal;
        }

        boolean isFatal() {
            return this.mIsFatal;
        }
    }
}

