/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io;

import com.complexible.common.base.Streams;
import com.complexible.common.util.concurrent.SharedExecutor;
import com.google.common.collect.Lists;
import com.google.common.io.CountingInputStream;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.io.LineBatch;
import com.stardog.stark.io.RDFFormats;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineSupplier
implements Supplier<LineBatch> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LineSupplier.class);
    private static final int DEFAULT_BATCH_SIZE = 10000;
    private final InputStreamSupplier input;
    private final FileFormat.Compression compression;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final ArrayBlockingQueue<LineBatch> queue;
    private final AtomicReference<Exception> mException = new AtomicReference();
    private int batchSize = 10000;
    private AtomicLong mBytesRead = new AtomicLong();

    public LineSupplier(Path theFile, FileFormat.Compression theCompression, int queueSize) {
        this(() -> Files.newInputStream(theFile, new OpenOption[0]), theCompression, queueSize);
    }

    public LineSupplier(InputStream theInput, FileFormat.Compression theCompression, int queueSize) {
        this(() -> theInput, theCompression, queueSize);
    }

    public LineSupplier(InputStreamSupplier theInput, FileFormat.Compression theCompression, int queueSize) {
        this.input = theInput;
        this.compression = theCompression;
        this.queue = new ArrayBlockingQueue(queueSize);
    }

    public void setBatchSize(int theBatchSize) {
        assert (!this.started.get()) : "Cannot change batch size after parsing started";
        this.batchSize = theBatchSize;
    }

    public void start() throws IOException {
        if (this.started.compareAndSet(false, true)) {
            InputStream stream = this.input.get();
            try {
                Future<Long> future = SharedExecutor.get().submit(() -> this.produceLines(stream));
            }
            catch (RuntimeException e) {
                stream.close();
                throw e;
            }
        }
    }

    public void stop() {
        this.stopped.set(true);
        this.queue.clear();
        this.queue.offer(LineBatch.EMPTY);
        this.checkException();
    }

    private void checkException() {
        Exception e = this.mException.get();
        if (e != null && this.mException.compareAndSet(e, null)) {
            throw new RuntimeException(e);
        }
    }

    public long bytesRead() {
        return this.mBytesRead.get();
    }

    @Override
    public LineBatch get() {
        assert (this.started.get()) : "LineSupplier.start() needs to be called before getting lines";
        if (this.stopped.get()) {
            this.checkException();
            return LineBatch.EMPTY;
        }
        try {
            LineBatch batch = this.queue.take();
            if (batch.getLines().isEmpty()) {
                this.queue.offer(LineBatch.EMPTY);
                this.checkException();
            }
            return batch;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long produceLines(InputStream stream) throws InterruptedException {
        long lineNumber = 1L;
        try (CountingInputStream counting = new CountingInputStream(stream);
             BufferedReader reader = new BufferedReader(new InputStreamReader(this.compression.decompress((InputStream)counting), RDFFormats.NTRIPLES.charset()));){
            ArrayList batch = Lists.newArrayListWithCapacity((int)this.batchSize);
            boolean eof = false;
            while (!eof && !this.stopped.get()) {
                String line = reader.readLine();
                boolean bl = eof = line == null;
                if (!eof) {
                    batch.add(line);
                }
                if (batch.size() == this.batchSize || eof && !batch.isEmpty()) {
                    this.queue.put(new LineBatch(batch, lineNumber));
                    lineNumber += (long)batch.size();
                    batch = Lists.newArrayListWithCapacity((int)this.batchSize);
                }
                this.mBytesRead.set(counting.getCount());
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error during multi-threaded parsing", (Throwable)e);
            this.mException.set(e);
            this.stopped.set(true);
            this.queue.clear();
        }
        finally {
            this.queue.put(LineBatch.EMPTY);
        }
        LOGGER.info("Parsed {} lines from file", (Object)lineNumber);
        return lineNumber;
    }

    public static interface InputStreamSupplier
    extends Streams.CheckedSupplier<InputStream> {
        public InputStream get() throws IOException;
    }
}

