/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io;

import com.complexible.common.base.Options;
import com.stardog.stark.io.InvalidRDF;
import com.stardog.stark.io.ParserContext;
import com.stardog.stark.io.RDFHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import javax.annotation.Nonnull;

public class IOParserContext
extends ParserContext {
    private static final int SB_SIZE = 1024;
    private final PushbackReader mReader;
    private StringBuilder mBuffer = new StringBuilder(1024);
    private final StringBuilder mLangBuffer = new StringBuilder(4);
    private final StringBuilder mDatatypeBuffer = new StringBuilder(80);

    public IOParserContext(@Nonnull Reader theReader, @Nonnull RDFHandler theHandler, @Nonnull Options theOptions) {
        super(theHandler, theOptions);
        this.mReader = new PushbackReader(theReader instanceof BufferedReader ? theReader : new BufferedReader(theReader), 8);
    }

    public StringBuilder langBuffer() {
        this.mLangBuffer.setLength(0);
        return this.mLangBuffer;
    }

    public StringBuilder datatypeBuffer() {
        this.mDatatypeBuffer.setLength(0);
        return this.mDatatypeBuffer;
    }

    public StringBuilder resetSB() {
        this.mBuffer.setLength(0);
        return this.mBuffer;
    }

    public StringBuilder trimSB() {
        if (this.mBuffer.capacity() > 1024) {
            this.mBuffer.setLength(1024);
            this.mBuffer.trimToSize();
        }
        return this.resetSB();
    }

    public int peekCodePoint() throws IOException {
        int result = this.readCodePoint();
        this.unread(result);
        return result;
    }

    public int readCodePoint() throws IOException {
        int next = this.mReader.read();
        return next;
    }

    public void unread(int theCodePoint) throws IOException {
        if (theCodePoint != -1) {
            if (Character.isSupplementaryCodePoint(theCodePoint)) {
                char[] surrogatePair = Character.toChars(theCodePoint);
                this.mReader.unread(surrogatePair);
            } else {
                this.mReader.unread(theCodePoint);
            }
        }
    }

    public void unread(@Nonnull String theStr) {
        try {
            for (int i = theStr.length() - 1; i >= 0; --i) {
                this.mReader.unread(theStr.charAt(i));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public int verifyCharacterOrFail(@Nonnull String expected) throws IOException {
        return this.verifyCharacterOrFail(this.readCodePoint(), expected);
    }

    public int verifyCharacterOrFail(@Nonnull char expected) throws IOException {
        int codePoint = this.readCodePoint();
        if (codePoint != expected) {
            StringBuilder msg = new StringBuilder(32);
            msg.append("Expected ").append(expected);
            msg.append(", found '");
            msg.append((char)codePoint);
            msg.append("'");
            throw this.error(msg.toString());
        }
        return codePoint;
    }

    public int verifyCharacterOrFail(int codePoint, @Nonnull String expected) throws InvalidRDF {
        if (codePoint == -1) {
            throw this.error("Unexpected end of file");
        }
        if (expected.indexOf((char)codePoint) == -1) {
            StringBuilder msg = new StringBuilder(32);
            msg.append("Expected ");
            for (int i = 0; i < expected.length(); ++i) {
                if (i > 0) {
                    msg.append(" or ");
                }
                msg.append('\'');
                msg.append(expected.charAt(i));
                msg.append('\'');
            }
            msg.append(", found '");
            msg.append((char)codePoint);
            msg.append("'");
            throw this.error(msg.toString());
        }
        return codePoint;
    }
}

