/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io;

import com.google.common.base.Preconditions;
import com.stardog.stark.io.FileFormat;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class FileFormatImpl
implements FileFormat {
    protected final String mName;
    protected final List<String> mMimetypes;
    protected final List<String> mFileExtensions;

    public FileFormatImpl(@Nonnull String theName, @Nonnull List<String> theMimetypes, @Nonnull List<String> theFileExtensions) {
        Preconditions.checkArgument((theMimetypes.size() > 0 ? 1 : 0) != 0, (Object)"Must have at least one supported mimetype");
        Preconditions.checkArgument((theFileExtensions.size() > 0 ? 1 : 0) != 0, (Object)"Must have at least one supported file extension");
        this.mName = theName;
        this.mMimetypes = theMimetypes;
        this.mFileExtensions = theFileExtensions;
    }

    @Override
    @Nonnull
    public String name() {
        return this.mName;
    }

    @Override
    @Nonnull
    public String defaultExtension() {
        return this.mFileExtensions.get(0);
    }

    @Override
    @Nonnull
    public String defaultMimeType() {
        return this.mMimetypes.get(0);
    }

    @Override
    @Nonnull
    public Stream<String> extensions() {
        return this.mFileExtensions.stream();
    }

    @Override
    @Nonnull
    public Stream<String> mimeTypes() {
        return this.mMimetypes.stream();
    }

    public String toString() {
        return this.name();
    }
}

