/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io;

import com.google.common.base.Charsets;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;

public interface FileFormat {
    @Nonnull
    public String name();

    @Nonnull
    default public Charset charset() {
        return Charsets.UTF_8;
    }

    @Nonnull
    public String defaultExtension();

    @Nonnull
    public String defaultMimeType();

    @Nonnull
    public Stream<String> extensions();

    @Nonnull
    public Stream<String> mimeTypes();

    public static enum Compression {
        NONE(""),
        GZIP(".gz"),
        BZIP2(".bz2"),
        ZIP(".zip");

        public final String mExt;

        private Compression(String theExt) {
            this.mExt = theExt;
        }

        public String extension() {
            return this.mExt;
        }

        public boolean supportsUnknownBaseFormat() {
            return this == ZIP;
        }

        public InputStream decompress(InputStream theStream) throws IOException {
            switch (this.ordinal()) {
                case 1: {
                    return new GZIPInputStream(theStream, 8192);
                }
                case 2: {
                    return new BZip2CompressorInputStream(theStream, true);
                }
                case 3: {
                    return new ZipInputStream(new BufferedInputStream(theStream));
                }
                case 0: {
                    return theStream;
                }
            }
            throw new UnsupportedOperationException();
        }

        public OutputStream compress(OutputStream theStream) throws IOException {
            switch (this.ordinal()) {
                case 1: {
                    return new GZIPOutputStream(theStream, 8192);
                }
                case 2: {
                    return new BZip2CompressorOutputStream(theStream);
                }
                case 3: {
                    return new ZipOutputStream(new BufferedOutputStream(theStream));
                }
                case 0: {
                    return theStream;
                }
            }
            throw new UnsupportedOperationException();
        }

        public static Compression of(String theValue) {
            if ("gz".equalsIgnoreCase(theValue)) {
                return GZIP;
            }
            if ("bz2".equalsIgnoreCase(theValue)) {
                return BZIP2;
            }
            if ("".equalsIgnoreCase(theValue)) {
                return NONE;
            }
            if (theValue != null) {
                return Compression.valueOf(theValue.toUpperCase());
            }
            throw new IllegalArgumentException();
        }
    }
}

