/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.stardog.cache;

import com.complexible.stardog.api.Connection;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.function.Function;

public abstract class CacheTarget {
    public static final String CACHE_DB = "stardog-cache";
    public static final String LOCAL_CACHE_TARGET_NAME = "localhost";
    private final String mName;
    private final String mHostname;
    private final int mPort;
    private final String mUsername;
    private final String mPassword;

    public CacheTarget(String name, String hostname, int port, String username, String password) {
        Preconditions.checkNotNull((Object)name, (Object)"Cache target name is missing");
        Preconditions.checkNotNull((Object)hostname, (Object)"Cache target hostname is missing");
        Preconditions.checkArgument((hostname.length() > 0 ? 1 : 0) != 0, (Object)"Cache target hostname is missing");
        Preconditions.checkNotNull((Object)username, (Object)"Cache target hostname is missing");
        Preconditions.checkNotNull((Object)password, (Object)"Cache target hostname is missing");
        this.mName = name;
        this.mHostname = hostname;
        this.mPort = port;
        this.mUsername = username;
        this.mPassword = password;
    }

    @Deprecated
    public Connection connect() {
        throw new IllegalStateException();
    }

    public <T> T withConnection(Function<Connection, T> action) {
        try (Connection conn = this.connect();){
            T t = action.apply(conn);
            return t;
        }
    }

    public String getName() {
        return this.mName;
    }

    public String getHostname() {
        return this.mHostname;
    }

    public int getPort() {
        return this.mPort;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mName, this.mHostname, this.mPort, this.mUsername, this.mPassword});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CacheTarget)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        CacheTarget ct = (CacheTarget)obj;
        return this.mName.equals(ct.mName) && this.mHostname.equals(ct.mHostname) && this.mPort == ct.mPort && this.mUsername.equals(ct.mUsername) && this.mPassword.equals(ct.mPassword);
    }
}

