/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.trig;

import com.complexible.common.base.Options;
import com.stardog.common.io.block.BlockMarker;
import com.stardog.common.io.block.BlockSpec;
import com.stardog.common.io.block.Bracket;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Values;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFWriter;
import com.stardog.stark.io.RDFWriterFactory;
import com.stardog.stark.io.WritingFailed;
import com.stardog.stark.io.turtle.TurtleWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import javax.annotation.Nonnull;

public class TrigWriter
extends TurtleWriter {
    private boolean inActiveContext;
    private Resource currentContext;

    public TrigWriter(OutputStream theWriter, Options theOptions) {
        super(theWriter, theOptions);
    }

    public void start() {
        super.start();
        this.inActiveContext = false;
        this.currentContext = Values.DEFAULT_GRAPH;
    }

    public void handle(@Nonnull Statement theStmt) {
        try {
            Resource aContext = theStmt.context();
            if (this.inActiveContext && !Objects.equals(aContext, this.currentContext)) {
                this.closePreviousStatement();
                this.closeActiveContext();
            }
            if (!this.inActiveContext) {
                this.mWriter.println();
                if (!Values.isDefaultGraph((Resource)aContext)) {
                    this.writeResource(aContext);
                    this.mWriter.write(32);
                }
                this.mWriter.beginBlock(BlockSpec.INDENTED.copy().indentSize(4).marker((BlockMarker)Bracket.CURLY).newLineBeforeEnd(true).newLineAfterEnd(true).immutable());
                this.currentContext = aContext;
                this.inActiveContext = true;
            }
        }
        catch (IOException e) {
            throw new WritingFailed((Throwable)e);
        }
        super.handle(theStmt);
    }

    public void end() {
        super.end();
        try {
            this.closeActiveContext();
            this.mWriter.flush();
        }
        catch (IOException e) {
            throw new WritingFailed((Throwable)e);
        }
    }

    public void comment(@Nonnull String theComment) {
        this.closeActiveContext();
        super.comment(theComment);
    }

    protected void writeNamespace(@Nonnull String thePrefix, @Nonnull String theName) {
        this.closeActiveContext();
        super.writeNamespace(thePrefix, theName);
    }

    protected void closeActiveContext() {
        if (this.inActiveContext) {
            try {
                this.mWriter.endBlock();
            }
            catch (IOException e) {
                throw new WritingFailed((Throwable)e);
            }
            finally {
                this.inActiveContext = false;
                this.currentContext = Values.DEFAULT_GRAPH;
            }
        }
    }

    @Nonnull
    public RDFFormat format() {
        return RDFFormats.TRIG;
    }

    public static final class TrigWriterFactory
    implements RDFWriterFactory {
        @Nonnull
        public RDFFormat format() {
            return RDFFormats.TRIG;
        }

        @Nonnull
        public RDFWriter create(@Nonnull OutputStream theStream, @Nonnull Options theOptions) {
            return new TrigWriter(theStream, theOptions);
        }
    }
}

