/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.trig;

import com.stardog.stark.BNode;
import com.stardog.stark.Resource;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.IOParserContext;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.turtle.TurtleParser;
import com.stardog.stark.io.turtle.TurtleParserContext;
import com.stardog.stark.io.turtle.TurtleUtil;
import java.io.IOException;
import javax.annotation.Nonnull;

public class TrigParser
extends TurtleParser {
    @Nonnull
    public RDFFormat format() {
        return RDFFormats.TRIG;
    }

    protected void parseStatement(@Nonnull TurtleParserContext theContext) throws IOException {
        StringBuilder sb = new StringBuilder(8);
        do {
            int c;
            if ((c = theContext.readCodePoint()) == -1 || TurtleUtil.isWhitespace((int)c)) {
                theContext.unread(c);
                break;
            }
            sb.append((char)c);
        } while (sb.length() < 8);
        String directive = sb.toString();
        if (this.parseDirective(theContext, directive)) {
            this.skipWSC((IOParserContext)theContext);
        } else {
            theContext.unread(directive);
            this.parseGraph(theContext, false);
        }
    }

    protected boolean parseDirective(TurtleParserContext theContext, String directive) throws IOException {
        if (directive.length() == 6 && directive.substring(0, 5).equalsIgnoreCase("GRAPH") && directive.substring(5, 6).equals(":")) {
            theContext.unread(directive);
            this.parseGraph(theContext, true);
            return true;
        }
        if (directive.length() == 5 && directive.substring(0, 5).equalsIgnoreCase("GRAPH")) {
            this.skipWSC((IOParserContext)theContext);
            this.parseGraph(theContext, true);
            return true;
        }
        return super.parseDirective(theContext, directive);
    }

    protected void parseGraph(@Nonnull TurtleParserContext theContext, boolean theGraphKeywordWasUsed) throws IOException {
        int c = theContext.readCodePoint();
        int c2 = theContext.peekCodePoint();
        BNode contextOrSubject = null;
        boolean foundContextOrSubject = false;
        if (c == 91) {
            this.skipWSC((IOParserContext)theContext);
            c2 = theContext.readCodePoint();
            if (c2 == 93) {
                contextOrSubject = theContext.createBNode();
                foundContextOrSubject = true;
                this.skipWSC((IOParserContext)theContext);
            } else {
                theContext.unread(c2);
                theContext.unread(c);
            }
            c = theContext.readCodePoint();
        } else if (c == 60 && c2 != 60 || TurtleUtil.isPrefixStartChar((int)c) || c == 58 && c2 != 45 || c == 95 && c2 == 58) {
            theContext.unread(c);
            Value value = this.parseValue((IOParserContext)theContext);
            if (!(value instanceof Resource)) {
                throw theContext.error("Illegal graph name: " + String.valueOf(value));
            }
            contextOrSubject = (Resource)value;
            foundContextOrSubject = true;
            this.skipWSC((IOParserContext)theContext);
            c = theContext.readCodePoint();
        } else {
            if (theGraphKeywordWasUsed) {
                throw theContext.error("GRAPH is not used with the default graph");
            }
            theContext.mContext = Values.DEFAULT_GRAPH;
        }
        if (c == 123) {
            theContext.mContext = contextOrSubject;
            c = this.skipWSC((IOParserContext)theContext);
            if (c != 125) {
                this.parseTriples(theContext);
                c = this.skipWSC((IOParserContext)theContext);
                while (c == 46) {
                    theContext.readCodePoint();
                    c = this.skipWSC((IOParserContext)theContext);
                    if (c == 125) break;
                    this.parseTriples(theContext);
                    c = this.skipWSC((IOParserContext)theContext);
                }
                theContext.verifyCharacterOrFail(c, "}");
                theContext.resetStatement();
            }
        } else {
            if (theGraphKeywordWasUsed) {
                throw theContext.error("GRAPH keyword requires {}");
            }
            theContext.mContext = Values.DEFAULT_GRAPH;
            if (foundContextOrSubject) {
                theContext.mSubject = contextOrSubject;
                theContext.unread(c);
                this.parsePredicateObjectList(theContext);
            } else {
                theContext.unread(c);
                this.parseTriples(theContext);
            }
        }
        theContext.readCodePoint();
    }

    protected void parseTriples(@Nonnull TurtleParserContext theContext) throws IOException {
        int c = theContext.readCodePoint();
        int c2 = theContext.peekCodePoint();
        if (c == 91) {
            this.skipWSC((IOParserContext)theContext);
            c = theContext.peekCodePoint();
            if (c == 93) {
                c = theContext.readCodePoint();
                theContext.mSubject = theContext.createBNode();
                this.skipWSC((IOParserContext)theContext);
                this.parsePredicateObjectList(theContext);
            } else {
                theContext.unread(91);
                theContext.mSubject = this.parseImplicitBlank(theContext);
            }
            this.skipWSC((IOParserContext)theContext);
            c = theContext.peekCodePoint();
            if (c != 46 && c != 125) {
                this.parsePredicateObjectList(theContext);
            }
        } else if (c == 60 && c2 == 60) {
            theContext.unread(c);
            theContext.mSubject = this.parseEmbeddedTriple((IOParserContext)theContext);
            this.skipWSC((IOParserContext)theContext);
            this.parsePredicateObjectList(theContext);
        } else {
            theContext.unread(c);
            this.parseSubject(theContext);
            this.skipWSC((IOParserContext)theContext);
            this.parsePredicateObjectList(theContext);
        }
        Resource aContext = theContext.mContext;
        theContext.resetStatement();
        theContext.mContext = aContext;
    }
}

