/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io.ntriples;

import com.complexible.common.base.Options;
import com.stardog.stark.Values;
import com.stardog.stark.io.IOParserContext;
import com.stardog.stark.io.InvalidRDF;
import com.stardog.stark.io.ParserOptions;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFParser;
import com.stardog.stark.io.ntriples.NTriplesUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NTParser
implements RDFParser {
    protected static final Logger LOGGER = LoggerFactory.getLogger(NTParser.class);

    @Nonnull
    public RDFFormat format() {
        return RDFFormats.NTRIPLES;
    }

    public void parse(@Nonnull InputStream theStream, @Nonnull RDFHandler theRDFHandler, @Nonnull Options theOptions) throws IOException {
        IOParserContext aContext = new IOParserContext((Reader)new InputStreamReader(theStream, RDFFormats.NTRIPLES.charset()), theRDFHandler, theOptions);
        this.parse(aContext);
    }

    public void parse(@Nonnull IOParserContext theContext) throws IOException {
        theContext.start();
        int c = theContext.readCodePoint();
        c = this.skipWhitespace(theContext, c);
        while (c != -1) {
            c = c == 35 ? this.skipLine(c, theContext) : (c == 13 || c == 10 ? this.skipLine(c, theContext) : this.parseTriple(theContext, c));
            c = this.skipWhitespace(theContext, c);
        }
        theContext.end();
    }

    private int parseTriple(@Nonnull IOParserContext theContext, int theChar) throws IOException {
        int c = theChar;
        boolean ignoredAnError = false;
        try {
            c = this.parseSubject(theContext, c);
            c = this.skipWhitespace(theContext, c);
            c = this.parsePredicate(theContext, c);
            c = this.skipWhitespace(theContext, c);
            c = this.parseObject(theContext, c);
            c = this.skipWhitespace(theContext, c);
            if (c == -1) {
                throw theContext.error("Unexpected end of file");
            }
            if (c != 46) {
                throw theContext.error("Expected '.', found: " + new String(Character.toChars(c)));
            }
            c = this.assertLineTerminates(theContext);
        }
        catch (InvalidRDF e) {
            if (!theContext.is(ParserOptions.FAIL_ON_INVALID_LINES)) {
                LOGGER.warn("Skipping triple: {}", (Object)e.getMessage());
                ignoredAnError = true;
            }
            throw e;
        }
        c = this.skipLine(c, theContext);
        if (!ignoredAnError) {
            theContext.reportStatement();
        }
        theContext.resetStatement();
        return c;
    }

    protected int parseSubject(@Nonnull IOParserContext theContext, int ch) throws IOException {
        int c = ch;
        int c2 = theContext.peekCodePoint();
        StringBuilder sb = theContext.resetSB();
        if (c == 60 && c2 == 60) {
            theContext.readCodePoint();
            c = this.parseEmbeddedTriple(theContext, theContext.readCodePoint());
            c = this.skipWhitespace(theContext, c);
        } else if (c == 60) {
            c = this.parseUriRef(theContext, c, sb);
            try {
                theContext.mSubject = Values.iri((String)NTriplesUtil.unescapeString(sb.toString()));
            }
            catch (IllegalArgumentException theE) {
                throw theContext.error(theE.getMessage());
            }
        } else if (c == 95) {
            c = this.parseNodeID(theContext, c, sb);
            theContext.mSubject = theContext.createBNode(sb.toString());
        } else {
            if (c == -1) {
                throw theContext.error("Unexpected end of file");
            }
            throw theContext.error("Expected '<' or '_', found: " + new String(Character.toChars(c)));
        }
        return c;
    }

    private int parseEmbeddedTriple(IOParserContext theContext, int c) throws IOException {
        c = this.skipWhitespace(theContext, c);
        try {
            c = this.parseSubject(theContext, c);
            c = this.skipWhitespace(theContext, c);
            c = this.parsePredicate(theContext, c);
            c = this.skipWhitespace(theContext, c);
            c = this.parseObject(theContext, c);
            c = this.skipWhitespace(theContext, c);
            theContext.verifyCharacterOrFail(c, ">");
            c = theContext.verifyCharacterOrFail(">");
            if (c == -1) {
                throw theContext.error("Unexpected end of file");
            }
        }
        catch (InvalidRDF e) {
            if (!theContext.is(ParserOptions.FAIL_ON_INVALID_LINES)) {
                LOGGER.warn("Skipping triple: {}", (Object)e.getMessage());
            }
            throw e;
        }
        theContext.mSubject = theContext.currentStatement();
        return theContext.readCodePoint();
    }

    protected int parsePredicate(@Nonnull IOParserContext theContext, int ch) throws IOException {
        int c = ch;
        StringBuilder sb = theContext.resetSB();
        if (c == 60) {
            c = this.parseUriRef(theContext, c, sb);
            try {
                theContext.mPredicate = Values.iri((String)NTriplesUtil.unescapeString(sb.toString()));
            }
            catch (IllegalArgumentException theE) {
                throw theContext.error(theE.getMessage());
            }
        } else {
            if (c == -1) {
                throw theContext.error("Unexpected end of file");
            }
            throw theContext.error("Expected '<', found: " + new String(Character.toChars(c)));
        }
        return c;
    }

    protected int parseObject(@Nonnull IOParserContext theContext, int ch) throws IOException {
        int c = ch;
        StringBuilder sb = theContext.resetSB();
        if (c == 60) {
            c = this.parseUriRef(theContext, c, sb);
            try {
                theContext.mObject = Values.iri((String)NTriplesUtil.unescapeString(sb.toString()));
            }
            catch (IllegalArgumentException e) {
                throw theContext.error(e.getMessage());
            }
        } else if (c == 95) {
            c = this.parseNodeID(theContext, c, sb);
            theContext.mObject = theContext.createBNode(sb.toString());
        } else if (c == 34) {
            StringBuilder lang = theContext.langBuffer();
            StringBuilder datatype = theContext.datatypeBuffer();
            c = this.parseLiteral(theContext, c, sb, lang, datatype);
            try {
                theContext.mObject = theContext.createLiteral(NTriplesUtil.unescapeString(sb.toString()), lang.length() > 0 ? lang.toString() : null, datatype.length() > 0 ? Values.iri((String)datatype.toString()) : null);
            }
            catch (IllegalArgumentException e) {
                throw theContext.error(e.getMessage());
            }
        } else {
            if (c == -1) {
                throw theContext.error("Unexpected end of file");
            }
            throw theContext.error("Expected '<', '_' or '\"', found: " + new String(Character.toChars(c)));
        }
        return c;
    }

    protected int parseUriRef(@Nonnull IOParserContext theContext, int ch, StringBuilder uriRef) throws IOException {
        int c = ch;
        if (c != 60) {
            throw theContext.error("Supplied char should be a '<', is: " + new String(Character.toChars(c)));
        }
        c = theContext.readCodePoint();
        while (c != 62) {
            if (c == -1) {
                throw theContext.error("Unexpected end of file");
            }
            if (c == 32) {
                throw theContext.error("IRI included an unencoded space: " + new String(Character.toChars(c)));
            }
            uriRef.appendCodePoint(c);
            if (c == 92) {
                c = theContext.readCodePoint();
                if (c == -1) {
                    throw theContext.error("Unexpected end of file");
                }
                if (c != 117 && c != 85) {
                    throw theContext.error("IRI includes string escapes: '\\" + c + "'");
                }
                uriRef.appendCodePoint(c);
            }
            c = theContext.readCodePoint();
        }
        c = theContext.readCodePoint();
        return c;
    }

    protected int parseNodeID(@Nonnull IOParserContext theContext, int c, @Nonnull StringBuilder name) throws IOException {
        int next;
        if (c != 95) {
            throw theContext.error("Supplied char should be a '_', is: " + new String(Character.toChars(c)));
        }
        c = theContext.readCodePoint();
        if (c == -1) {
            throw theContext.error("Unexpected end of file");
        }
        if (c != 58) {
            throw theContext.error("Expected ':', found: " + new String(Character.toChars(c)));
        }
        c = theContext.readCodePoint();
        if (c == -1) {
            throw theContext.error("Unexpected end of file");
        }
        if (!NTriplesUtil.isStartingBnodeLabelChar(c)) {
            throw theContext.error("Expected bnode label to start with a letter, number or underscore, found: " + new String(Character.toChars(c)));
        }
        name.appendCodePoint(c);
        c = theContext.readCodePoint();
        while (c != -1 && NTriplesUtil.isBnodeLabelChar(c) && (c != 46 || NTriplesUtil.isBnodeLabelChar(next = theContext.peekCodePoint()))) {
            name.appendCodePoint(c);
            c = theContext.readCodePoint();
        }
        return c;
    }

    private int parseLiteral(@Nonnull IOParserContext theContext, int ch, @Nonnull StringBuilder value, @Nonnull StringBuilder lang, @Nonnull StringBuilder datatype) throws IOException {
        int c = ch;
        if (c != 34) {
            throw theContext.error("Supplied char should be a '\"', is: " + c);
        }
        c = theContext.readCodePoint();
        while (c != 34) {
            if (c == -1) {
                throw theContext.error("Unexpected end of file");
            }
            value.appendCodePoint(c);
            if (c == 92) {
                c = theContext.readCodePoint();
                if (c == -1) {
                    throw theContext.error("Unexpected end of file");
                }
                value.appendCodePoint(c);
            }
            c = theContext.readCodePoint();
        }
        c = theContext.readCodePoint();
        if (c == 64) {
            c = theContext.readCodePoint();
            if (!NTriplesUtil.isLetter(c)) {
                throw theContext.error("Expected a letter, found: " + new String(Character.toChars(c)));
            }
            while (c != -1 && c != 46 && c != 94 && c != 32 && c != 9) {
                lang.appendCodePoint(c);
                c = theContext.readCodePoint();
            }
        } else if (c == 94) {
            c = theContext.readCodePoint();
            if (c == -1) {
                throw theContext.error("Unexpected end of file");
            }
            if (c != 94) {
                throw theContext.error("Expected '^', found: " + new String(Character.toChars(c)));
            }
            c = theContext.readCodePoint();
            if (c == -1) {
                throw theContext.error("Unexpected end of file");
            }
            if (c != 60) {
                throw theContext.error("Expected '<', found: " + new String(Character.toChars(c)));
            }
            c = this.parseUriRef(theContext, c, datatype);
        }
        return c;
    }

    protected int assertLineTerminates(@Nonnull IOParserContext theContext) throws IOException {
        int c = theContext.readCodePoint();
        if ((c = this.skipWhitespace(theContext, c)) != 35 && c != -1 && c != 13 && c != 10) {
            throw theContext.error("Content after '.' is not allowed");
        }
        return c;
    }

    protected int skipToEndOfLine(@Nonnull IOParserContext theContext, int theChar) throws IOException {
        int c = theChar;
        while (c != -1 && c != 13 && c != 10) {
            c = theContext.readCodePoint();
        }
        return c;
    }

    protected int skipLine(int theChar, @Nonnull IOParserContext theContext) throws IOException {
        int c = theChar;
        while (c != -1 && c != 13 && c != 10) {
            c = theContext.readCodePoint();
        }
        if (c == 10) {
            ++theContext.mLineNumber;
            c = theContext.readCodePoint();
        } else if (c == 13) {
            ++theContext.mLineNumber;
            c = theContext.readCodePoint();
            if (c == 10) {
                c = theContext.readCodePoint();
            }
        }
        return c;
    }

    protected int skipWhitespace(@Nonnull IOParserContext theContext, int theChar) throws IOException {
        int aChar = theChar;
        while (aChar == 32 || aChar == 9) {
            aChar = theContext.readCodePoint();
        }
        return aChar;
    }
}

