/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.Directives;
import graphql.ExperimentalApi;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.Node;
import graphql.language.NullValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

@ExperimentalApi
public class DeferDirectiveLabel
extends AbstractRule {
    private Set<String> checkedLabels = new LinkedHashSet<String>();

    public DeferDirectiveLabel(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkDirective(Directive directive, List<Node> ancestors) {
        if (!this.isExperimentalApiKeyEnabled("ENABLE_INCREMENTAL_SUPPORT").booleanValue() || !Directives.DeferDirective.getName().equals(directive.getName()) || directive.getArguments().size() == 0) {
            return;
        }
        Argument labelArgument = directive.getArgument("label");
        if (labelArgument == null || labelArgument.getValue() instanceof NullValue) {
            return;
        }
        Value labelArgumentValue = labelArgument.getValue();
        if (!(labelArgumentValue instanceof StringValue)) {
            String message = this.i18n(ValidationErrorType.WrongType, "DeferDirective.labelMustBeStaticString", new Object[0]);
            this.addError(ValidationErrorType.WrongType, directive.getSourceLocation(), message);
        } else if (this.checkedLabels.contains(((StringValue)labelArgumentValue).getValue())) {
            String message = this.i18n(ValidationErrorType.DuplicateIncrementalLabel, "IncrementalDirective.uniqueArgument", labelArgument.getName(), directive.getName());
            this.addError(ValidationErrorType.DuplicateIncrementalLabel, directive.getSourceLocation(), message);
        } else {
            this.checkedLabels.add(((StringValue)labelArgumentValue).getValue());
        }
    }
}

