/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.Internal;
import graphql.collect.ImmutableKit;
import graphql.com.google.common.collect.ImmutableList;
import graphql.introspection.Introspection;
import graphql.language.Argument;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.Value;
import graphql.schema.GraphQLAppliedDirective;
import graphql.schema.GraphQLAppliedDirectiveArgument;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphqlDirectivesContainerTypeBuilder;
import graphql.schema.GraphqlTypeComparatorRegistry;
import graphql.schema.idl.SchemaGeneratorHelper;
import graphql.util.FpKit;
import graphql.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

@Internal
class SchemaGeneratorAppliedDirectiveHelper {
    SchemaGeneratorAppliedDirectiveHelper() {
    }

    static void buildAppliedDirectives(SchemaGeneratorHelper.BuildContext buildCtx, GraphqlDirectivesContainerTypeBuilder<?, ?> builder, Pair<List<GraphQLDirective>, List<GraphQLAppliedDirective>> appliedDirectives) {
        builder.clearDirectives();
        if (!buildCtx.options.isUseAppliedDirectivesOnly()) {
            for (GraphQLDirective directive : (List)appliedDirectives.first) {
                builder.withDirective(directive);
            }
        }
        for (GraphQLAppliedDirective appliedDirective : (List)appliedDirectives.second) {
            builder.withAppliedDirective(appliedDirective);
        }
    }

    static Pair<List<GraphQLDirective>, List<GraphQLAppliedDirective>> buildAppliedDirectives(SchemaGeneratorHelper.BuildContext buildCtx, Function<Type<?>, GraphQLInputType> inputTypeFactory, List<Directive> directives, List<Directive> extensionDirectives, Introspection.DirectiveLocation directiveLocation, Set<GraphQLDirective> runtimeDirectives, GraphqlTypeComparatorRegistry comparatorRegistry) {
        Pair<GraphQLDirective, GraphQLAppliedDirective> pair;
        directives = Optional.ofNullable(directives).orElse(ImmutableKit.emptyList());
        extensionDirectives = Optional.ofNullable(extensionDirectives).orElse(ImmutableKit.emptyList());
        ArrayList<GraphQLDirective> output = new ArrayList<GraphQLDirective>();
        ArrayList<GraphQLAppliedDirective> outputApplied = new ArrayList<GraphQLAppliedDirective>();
        for (Directive directive : directives) {
            pair = SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirective(buildCtx, inputTypeFactory, directive, runtimeDirectives, directiveLocation, comparatorRegistry);
            output.add((GraphQLDirective)pair.first);
            outputApplied.add((GraphQLAppliedDirective)pair.second);
        }
        for (Directive directive : extensionDirectives) {
            pair = SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirective(buildCtx, inputTypeFactory, directive, runtimeDirectives, directiveLocation, comparatorRegistry);
            output.add((GraphQLDirective)pair.first);
            outputApplied.add((GraphQLAppliedDirective)pair.second);
        }
        return Pair.pair(output, outputApplied);
    }

    private static Pair<GraphQLDirective, GraphQLAppliedDirective> buildAppliedDirective(SchemaGeneratorHelper.BuildContext buildCtx, Function<Type<?>, GraphQLInputType> inputTypeFactory, Directive directive, Set<GraphQLDirective> directiveDefinitions, Introspection.DirectiveLocation directiveLocation, GraphqlTypeComparatorRegistry comparatorRegistry) {
        GraphQLDirective.Builder builder = ((GraphQLDirective.Builder)GraphQLDirective.newDirective().name(directive.getName()).description(SchemaGeneratorHelper.buildDescription(buildCtx, directive, null)).comparatorRegistry(comparatorRegistry)).validLocations(directiveLocation);
        GraphQLAppliedDirective.Builder builderAppliedDirective = (GraphQLAppliedDirective.Builder)((GraphQLAppliedDirective.Builder)((GraphQLAppliedDirective.Builder)GraphQLAppliedDirective.newDirective().name(directive.getName())).description(SchemaGeneratorHelper.buildDescription(buildCtx, directive, null))).comparatorRegistry(comparatorRegistry);
        Optional<GraphQLDirective> directiveDefOpt = FpKit.findOne(directiveDefinitions, dd -> dd.getName().equals(directive.getName()));
        GraphQLDirective graphQLDirective = directiveDefOpt.orElseGet(() -> SchemaGeneratorAppliedDirectiveHelper.buildDirectiveDefinitionFromAst(buildCtx, buildCtx.getTypeRegistry().getDirectiveDefinition(directive.getName()).get(), inputTypeFactory));
        builder.repeatable(graphQLDirective.isRepeatable());
        builder.definition(buildCtx.isCaptureAstDefinitions() ? graphQLDirective.getDefinition() : null);
        builderAppliedDirective.definition(buildCtx.isCaptureAstDefinitions() ? directive : null);
        List<GraphQLArgument> directiveArguments = new ArrayList<GraphQLArgument>();
        List<GraphQLAppliedDirectiveArgument> appliedArguments = new ArrayList<GraphQLAppliedDirectiveArgument>();
        for (Argument arg : directive.getArguments()) {
            directiveArguments.add(SchemaGeneratorAppliedDirectiveHelper.buildDirectiveArg(buildCtx, arg, graphQLDirective));
            appliedArguments.add(SchemaGeneratorAppliedDirectiveHelper.buildAppliedArg(buildCtx, arg, graphQLDirective));
        }
        directiveArguments = SchemaGeneratorAppliedDirectiveHelper.transferMissingArguments(buildCtx, directiveArguments, graphQLDirective);
        directiveArguments.forEach(builder::argument);
        appliedArguments = SchemaGeneratorAppliedDirectiveHelper.transferMissingAppliedArguments(appliedArguments, graphQLDirective);
        appliedArguments.forEach(builderAppliedDirective::argument);
        return Pair.pair(builder.build(), builderAppliedDirective.build());
    }

    private static GraphQLArgument buildDirectiveArg(SchemaGeneratorHelper.BuildContext buildCtx, Argument arg, GraphQLDirective directiveDefinition) {
        GraphQLArgument directiveDefArgument = directiveDefinition.getArgument(arg.getName());
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
        GraphQLInputType inputType = directiveDefArgument.getType();
        builder.name(arg.getName()).type(inputType).definition(buildCtx.isCaptureAstDefinitions() ? directiveDefArgument.getDefinition() : null);
        if (directiveDefArgument.getArgumentDefaultValue().isSet()) {
            builder.defaultValueLiteral((Value)directiveDefArgument.getArgumentDefaultValue().getValue());
        }
        if (arg.getValue() != null) {
            builder.valueLiteral(arg.getValue());
        }
        return builder.build();
    }

    private static GraphQLAppliedDirectiveArgument buildAppliedArg(SchemaGeneratorHelper.BuildContext buildCtx, Argument arg, GraphQLDirective directiveDefinition) {
        GraphQLArgument directiveDefArgument = directiveDefinition.getArgument(arg.getName());
        GraphQLAppliedDirectiveArgument.Builder builder = GraphQLAppliedDirectiveArgument.newArgument();
        ((GraphQLAppliedDirectiveArgument.Builder)builder.name(arg.getName())).type(directiveDefArgument.getType()).definition(buildCtx.isCaptureAstDefinitions() ? arg : null);
        if (arg.getValue() != null) {
            builder.valueLiteral(arg.getValue());
        } else if (directiveDefArgument.getArgumentDefaultValue().isSet()) {
            builder.valueLiteral((Value)directiveDefArgument.getArgumentDefaultValue().getValue());
        }
        return builder.build();
    }

    private static List<GraphQLArgument> transferMissingArguments(SchemaGeneratorHelper.BuildContext buildCtx, List<GraphQLArgument> arguments, GraphQLDirective directiveDefinition) {
        Map<String, GraphQLArgument> declaredArgs = FpKit.getByName(arguments, GraphQLArgument::getName, FpKit.mergeFirst());
        ArrayList<GraphQLArgument> argumentsOut = new ArrayList<GraphQLArgument>(arguments);
        for (GraphQLArgument directiveDefArg : directiveDefinition.getArguments()) {
            if (declaredArgs.containsKey(directiveDefArg.getName())) continue;
            GraphQLArgument.Builder missingArg = GraphQLArgument.newArgument().name(directiveDefArg.getName()).description(directiveDefArg.getDescription()).definition(buildCtx.isCaptureAstDefinitions() ? directiveDefArg.getDefinition() : null).type(directiveDefArg.getType());
            if (directiveDefArg.hasSetDefaultValue()) {
                missingArg.defaultValueLiteral((Value)directiveDefArg.getArgumentDefaultValue().getValue());
            }
            if (directiveDefArg.hasSetValue()) {
                missingArg.valueLiteral((Value)directiveDefArg.getArgumentValue().getValue());
            }
            argumentsOut.add(missingArg.build());
        }
        return argumentsOut;
    }

    private static List<GraphQLAppliedDirectiveArgument> transferMissingAppliedArguments(List<GraphQLAppliedDirectiveArgument> arguments, GraphQLDirective directiveDefinition) {
        Map<String, GraphQLAppliedDirectiveArgument> declaredArgs = FpKit.getByName(arguments, GraphQLAppliedDirectiveArgument::getName, FpKit.mergeFirst());
        ArrayList<GraphQLAppliedDirectiveArgument> argumentsOut = new ArrayList<GraphQLAppliedDirectiveArgument>(arguments);
        for (GraphQLArgument directiveDefArg : directiveDefinition.getArguments()) {
            if (declaredArgs.containsKey(directiveDefArg.getName())) continue;
            GraphQLAppliedDirectiveArgument.Builder missingArg = (GraphQLAppliedDirectiveArgument.Builder)((GraphQLAppliedDirectiveArgument.Builder)GraphQLAppliedDirectiveArgument.newArgument().name(directiveDefArg.getName())).type(directiveDefArg.getType()).description(directiveDefArg.getDescription());
            if (directiveDefArg.hasSetDefaultValue()) {
                missingArg.valueLiteral((Value)directiveDefArg.getArgumentDefaultValue().getValue());
            }
            if (directiveDefArg.hasSetValue()) {
                missingArg.valueLiteral((Value)directiveDefArg.getArgumentValue().getValue());
            }
            argumentsOut.add(missingArg.build());
        }
        return argumentsOut;
    }

    static GraphQLDirective buildDirectiveDefinitionFromAst(SchemaGeneratorHelper.BuildContext buildCtx, DirectiveDefinition directiveDefinition, Function<Type<?>, GraphQLInputType> inputTypeFactory) {
        GraphQLDirective.Builder builder = GraphQLDirective.newDirective().name(directiveDefinition.getName()).definition(buildCtx.isCaptureAstDefinitions() ? directiveDefinition : null).repeatable(directiveDefinition.isRepeatable()).description(SchemaGeneratorHelper.buildDescription(buildCtx, directiveDefinition, directiveDefinition.getDescription()));
        List<Introspection.DirectiveLocation> locations = SchemaGeneratorAppliedDirectiveHelper.buildLocations(directiveDefinition);
        locations.forEach(xva$0 -> builder.validLocations((Introspection.DirectiveLocation)((Object)xva$0)));
        ImmutableList<GraphQLArgument> arguments = ImmutableKit.map(directiveDefinition.getInputValueDefinitions(), arg -> SchemaGeneratorAppliedDirectiveHelper.buildDirectiveArgumentDefinitionFromAst(buildCtx, arg, inputTypeFactory));
        arguments.forEach(builder::argument);
        return builder.build();
    }

    private static List<Introspection.DirectiveLocation> buildLocations(DirectiveDefinition directiveDefinition) {
        return ImmutableKit.map(directiveDefinition.getDirectiveLocations(), dl -> Introspection.DirectiveLocation.valueOf(dl.getName().toUpperCase()));
    }

    static GraphQLArgument buildDirectiveArgumentDefinitionFromAst(SchemaGeneratorHelper.BuildContext buildCtx, InputValueDefinition valueDefinition, Function<Type<?>, GraphQLInputType> inputTypeFactory) {
        GraphQLArgument.Builder builder = GraphQLArgument.newArgument();
        builder.definition(buildCtx.isCaptureAstDefinitions() ? valueDefinition : null);
        builder.name(valueDefinition.getName());
        builder.description(SchemaGeneratorHelper.buildDescription(buildCtx, valueDefinition, valueDefinition.getDescription()));
        builder.deprecate(SchemaGeneratorAppliedDirectiveHelper.buildDeprecationReason(valueDefinition.getDirectives()));
        builder.comparatorRegistry(buildCtx.getComparatorRegistry());
        GraphQLInputType inputType = inputTypeFactory.apply(valueDefinition.getType());
        builder.type(inputType);
        if (valueDefinition.getDefaultValue() != null) {
            builder.valueLiteral(valueDefinition.getDefaultValue());
            builder.defaultValueLiteral(valueDefinition.getDefaultValue());
        }
        Pair<List<GraphQLDirective>, List<GraphQLAppliedDirective>> appliedDirectives = SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirectives(buildCtx, inputTypeFactory, valueDefinition.getDirectives(), ImmutableKit.emptyList(), Introspection.DirectiveLocation.ARGUMENT_DEFINITION, buildCtx.getDirectives(), buildCtx.getComparatorRegistry());
        SchemaGeneratorAppliedDirectiveHelper.buildAppliedDirectives(buildCtx, builder, appliedDirectives);
        return builder.build();
    }

    static String buildDeprecationReason(List<Directive> directives) {
        Optional<Directive> directive = (directives = (List)Optional.ofNullable(directives).orElse(ImmutableKit.emptyList())).stream().filter(d -> "deprecated".equals(d.getName())).findFirst();
        if (directive.isPresent()) {
            Map<String, String> args = directive.get().getArguments().stream().collect(Collectors.toMap(Argument::getName, arg -> ((StringValue)arg.getValue()).getValue()));
            if (args.isEmpty()) {
                return "No longer supported";
            }
            return args.get("reason");
        }
        return null;
    }
}

