/*
 * Decompiled with CFR 0.152.
 */
package graphql.language;

import graphql.Assert;
import graphql.PublicApi;
import graphql.collect.ImmutableKit;
import graphql.language.AbstractDescribedNode;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.BooleanValue;
import graphql.language.Description;
import graphql.language.Directive;
import graphql.language.DirectiveDefinition;
import graphql.language.DirectiveLocation;
import graphql.language.Document;
import graphql.language.EnumTypeDefinition;
import graphql.language.EnumTypeExtensionDefinition;
import graphql.language.EnumValue;
import graphql.language.EnumValueDefinition;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.language.FloatValue;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.InputObjectTypeDefinition;
import graphql.language.InputObjectTypeExtensionDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.IntValue;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.InterfaceTypeExtensionDefinition;
import graphql.language.ListType;
import graphql.language.Node;
import graphql.language.NonNullType;
import graphql.language.NullValue;
import graphql.language.ObjectField;
import graphql.language.ObjectTypeDefinition;
import graphql.language.ObjectTypeExtensionDefinition;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.ScalarTypeDefinition;
import graphql.language.ScalarTypeExtensionDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.SchemaExtensionDefinition;
import graphql.language.SelectionSet;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.UnionTypeDefinition;
import graphql.language.UnionTypeExtensionDefinition;
import graphql.language.Value;
import graphql.language.VariableDefinition;
import graphql.language.VariableReference;
import graphql.util.EscapeUtil;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

@PublicApi
public class AstPrinter {
    private final Map<Class<? extends Node>, NodePrinter<? extends Node>> printers = new LinkedHashMap<Class<? extends Node>, NodePrinter<? extends Node>>();
    private final boolean compactMode;

    AstPrinter(boolean compactMode) {
        this.compactMode = compactMode;
        this.printers.put(Argument.class, this.argument());
        this.printers.put(ArrayValue.class, this.value());
        this.printers.put(BooleanValue.class, this.value());
        this.printers.put(NullValue.class, this.value());
        this.printers.put(Directive.class, this.directive());
        this.printers.put(DirectiveDefinition.class, this.directiveDefinition());
        this.printers.put(DirectiveLocation.class, this.directiveLocation());
        this.printers.put(Document.class, this.document());
        this.printers.put(EnumTypeDefinition.class, this.enumTypeDefinition());
        this.printers.put(EnumTypeExtensionDefinition.class, this.enumTypeExtensionDefinition());
        this.printers.put(EnumValue.class, this.enumValue());
        this.printers.put(EnumValueDefinition.class, this.enumValueDefinition());
        this.printers.put(Field.class, this.field());
        this.printers.put(FieldDefinition.class, this.fieldDefinition());
        this.printers.put(FloatValue.class, this.value());
        this.printers.put(FragmentDefinition.class, this.fragmentDefinition());
        this.printers.put(FragmentSpread.class, this.fragmentSpread());
        this.printers.put(InlineFragment.class, this.inlineFragment());
        this.printers.put(InputObjectTypeDefinition.class, this.inputObjectTypeDefinition());
        this.printers.put(InputObjectTypeExtensionDefinition.class, this.inputObjectTypeExtensionDefinition());
        this.printers.put(InputValueDefinition.class, this.inputValueDefinition());
        this.printers.put(InterfaceTypeDefinition.class, this.interfaceTypeDefinition());
        this.printers.put(InterfaceTypeExtensionDefinition.class, this.interfaceTypeExtensionDefinition());
        this.printers.put(IntValue.class, this.value());
        this.printers.put(ListType.class, this.type());
        this.printers.put(NonNullType.class, this.type());
        this.printers.put(ObjectField.class, this.objectField());
        this.printers.put(ObjectTypeDefinition.class, this.objectTypeDefinition());
        this.printers.put(ObjectTypeExtensionDefinition.class, this.objectTypeExtensionDefinition());
        this.printers.put(ObjectValue.class, this.value());
        this.printers.put(OperationDefinition.class, this.operationDefinition());
        this.printers.put(OperationTypeDefinition.class, this.operationTypeDefinition());
        this.printers.put(ScalarTypeDefinition.class, this.scalarTypeDefinition());
        this.printers.put(ScalarTypeExtensionDefinition.class, this.scalarTypeExtensionDefinition());
        this.printers.put(SchemaDefinition.class, this.schemaDefinition());
        this.printers.put(SchemaExtensionDefinition.class, this.schemaExtensionDefinition());
        this.printers.put(SelectionSet.class, this.selectionSet());
        this.printers.put(StringValue.class, this.value());
        this.printers.put(TypeName.class, this.type());
        this.printers.put(UnionTypeDefinition.class, this.unionTypeDefinition());
        this.printers.put(UnionTypeExtensionDefinition.class, this.unionTypeExtensionDefinition());
        this.printers.put(VariableDefinition.class, this.variableDefinition());
        this.printers.put(VariableReference.class, this.variableReference());
    }

    private NodePrinter<Argument> argument() {
        if (this.compactMode) {
            return (out, node) -> out.append(node.getName()).append(':').append(this.value(node.getValue()));
        }
        return (out, node) -> out.append(node.getName()).append(": ").append(this.value(node.getValue()));
    }

    private NodePrinter<Document> document() {
        if (this.compactMode) {
            return (out, node) -> out.append(this.join(node.getDefinitions(), " "));
        }
        return (out, node) -> out.append(this.join(node.getDefinitions(), "\n\n")).append("\n");
    }

    private NodePrinter<Directive> directive() {
        String argSep = this.compactMode ? "," : ", ";
        return (out, node) -> {
            String arguments = this.wrap("(", this.join(node.getArguments(), argSep), ")");
            out.append('@').append(node.getName()).append(arguments);
        };
    }

    private NodePrinter<DirectiveDefinition> directiveDefinition() {
        String argSep = this.compactMode ? "," : ", ";
        return (out, node) -> {
            out.append(this.description(node));
            String arguments = this.wrap("(", this.join(node.getInputValueDefinitions(), argSep), ")");
            String locations = this.join(node.getDirectiveLocations(), " | ");
            String repeatable = node.isRepeatable() ? "repeatable " : "";
            out.append("directive @").append(node.getName()).append(arguments).append(" ").append(repeatable).append("on ").append(locations);
        };
    }

    private NodePrinter<DirectiveLocation> directiveLocation() {
        return (out, node) -> out.append(node.getName());
    }

    private NodePrinter<EnumTypeDefinition> enumTypeDefinition() {
        return (out, node) -> {
            out.append(this.description(node));
            out.append(this.spaced("enum", node.getName(), this.directives(node.getDirectives()), this.block(node.getEnumValueDefinitions())));
        };
    }

    private NodePrinter<EnumValue> enumValue() {
        return (out, node) -> out.append(node.getName());
    }

    private NodePrinter<EnumValueDefinition> enumValueDefinition() {
        return (out, node) -> {
            out.append(this.description(node));
            out.append(this.spaced(node.getName(), this.directives(node.getDirectives())));
        };
    }

    private NodePrinter<Field> field() {
        String argSep = this.compactMode ? "," : ", ";
        String aliasSuffix = this.compactMode ? ":" : ": ";
        return (out, node) -> {
            String alias = this.wrap("", node.getAlias(), aliasSuffix);
            String name = node.getName();
            String arguments = this.wrap("(", this.join(node.getArguments(), argSep), ")");
            String directives = this.directives(node.getDirectives());
            String selectionSet = this.node(node.getSelectionSet());
            if (this.compactMode) {
                out.append(this.spaced(alias + name + arguments, directives));
                out.append(selectionSet);
            } else {
                out.append(this.spaced(alias + name + arguments, directives, selectionSet));
            }
        };
    }

    private NodePrinter<FieldDefinition> fieldDefinition() {
        String argSep = this.compactMode ? "," : ", ";
        return (out, node) -> {
            if (this.hasDescription(Collections.singletonList(node)) && !this.compactMode) {
                out.append(this.description(node));
                String args = this.join(node.getInputValueDefinitions(), "\n");
                out.append(node.getName()).append(this.wrap("(\n", args, ")")).append(": ").append(this.spaced(this.type(node.getType()), this.directives(node.getDirectives())));
            } else {
                String args = this.join(node.getInputValueDefinitions(), argSep);
                out.append(node.getName()).append(this.wrap("(", args, ")")).append(": ").append(this.spaced(this.type(node.getType()), this.directives(node.getDirectives())));
            }
        };
    }

    private boolean hasDescription(List<? extends Node> nodes) {
        for (Node node : nodes) {
            AbstractDescribedNode describedNode;
            if (!(node instanceof AbstractDescribedNode) || (describedNode = (AbstractDescribedNode)node).getDescription() == null) continue;
            return true;
        }
        return false;
    }

    private NodePrinter<FragmentDefinition> fragmentDefinition() {
        return (out, node) -> {
            String name = node.getName();
            String typeCondition = this.type(node.getTypeCondition());
            String directives = this.directives(node.getDirectives());
            String selectionSet = this.node(node.getSelectionSet());
            out.append("fragment ").append(name).append(" on ").append(typeCondition).append(' ').append(directives).append(selectionSet);
        };
    }

    private NodePrinter<FragmentSpread> fragmentSpread() {
        return (out, node) -> {
            String name = node.getName();
            String directives = this.directives(node.getDirectives());
            out.append("...").append(name).append(directives);
        };
    }

    private NodePrinter<InlineFragment> inlineFragment() {
        return (out, node) -> {
            TypeName typeName = node.getTypeCondition();
            String typeCondition = typeName == null ? "" : this.wrap("on ", this.type(typeName), "");
            String directives = this.directives(node.getDirectives());
            String selectionSet = this.node(node.getSelectionSet());
            if (this.compactMode) {
                out.append("...");
                out.append(this.spaced(typeCondition, directives));
                out.append(selectionSet);
            } else {
                out.append(this.spaced("...", typeCondition, directives, selectionSet));
            }
        };
    }

    private NodePrinter<InputObjectTypeDefinition> inputObjectTypeDefinition() {
        return (out, node) -> {
            out.append(this.description(node));
            out.append(this.spaced("input", node.getName(), this.directives(node.getDirectives()), this.block(node.getInputValueDefinitions())));
        };
    }

    private NodePrinter<InputValueDefinition> inputValueDefinition() {
        String nameTypeSep = this.compactMode ? ":" : ": ";
        String defaultValueEquals = this.compactMode ? "=" : "= ";
        return (out, node) -> {
            Value defaultValue = node.getDefaultValue();
            out.append(this.description(node));
            out.append(this.spaced(node.getName() + nameTypeSep + this.type(node.getType()), this.wrap(defaultValueEquals, defaultValue, ""), this.directives(node.getDirectives())));
        };
    }

    private NodePrinter<InterfaceTypeDefinition> interfaceTypeDefinition() {
        return (out, node) -> {
            out.append(this.description(node));
            out.append(this.spaced("interface", node.getName(), this.wrap("implements ", this.join(node.getImplements(), " & "), ""), this.directives(node.getDirectives()), this.block(node.getFieldDefinitions())));
        };
    }

    private NodePrinter<ObjectField> objectField() {
        String nameValueSep = this.compactMode ? ":" : " : ";
        return (out, node) -> out.append(node.getName()).append(nameValueSep).append(this.value(node.getValue()));
    }

    private NodePrinter<OperationDefinition> operationDefinition() {
        String argSep = this.compactMode ? "," : ", ";
        return (out, node) -> {
            String op = node.getOperation().toString().toLowerCase();
            String name = node.getName();
            String varDefinitions = this.wrap("(", this.join(this.nvl(node.getVariableDefinitions()), argSep), ")");
            String directives = this.directives(node.getDirectives());
            String selectionSet = this.node(node.getSelectionSet());
            if (this.isEmpty(name) && this.isEmpty(directives) && this.isEmpty(varDefinitions) && op.equals("query")) {
                out.append(selectionSet);
            } else if (this.compactMode) {
                out.append(this.spaced(op, this.smooshed(name, varDefinitions), directives));
                out.append(selectionSet);
            } else {
                out.append(this.spaced(op, this.smooshed(name, varDefinitions), directives, selectionSet));
            }
        };
    }

    private NodePrinter<OperationTypeDefinition> operationTypeDefinition() {
        String nameTypeSep = this.compactMode ? ":" : ": ";
        return (out, node) -> out.append(node.getName()).append(nameTypeSep).append(this.type(node.getTypeName()));
    }

    private NodePrinter<ObjectTypeDefinition> objectTypeDefinition() {
        return (out, node) -> {
            out.append(this.description(node));
            out.append(this.spaced("type", node.getName(), this.wrap("implements ", this.join(node.getImplements(), " & "), ""), this.directives(node.getDirectives()), this.block(node.getFieldDefinitions())));
        };
    }

    private NodePrinter<SelectionSet> selectionSet() {
        return (out, node) -> {
            String block = this.block(node.getSelections());
            out.append(block);
        };
    }

    private NodePrinter<ScalarTypeDefinition> scalarTypeDefinition() {
        return (out, node) -> {
            out.append(this.description(node));
            out.append(this.spaced("scalar", node.getName(), this.directives(node.getDirectives())));
        };
    }

    private NodePrinter<SchemaDefinition> schemaDefinition() {
        return (out, node) -> {
            out.append(this.description(node));
            out.append(this.spaced("schema", this.directives(node.getDirectives()), this.block(node.getOperationTypeDefinitions())));
        };
    }

    private NodePrinter<Type> type() {
        return (out, node) -> out.append(this.type((Type)node));
    }

    private String type(Type type) {
        if (type instanceof NonNullType) {
            NonNullType inner = (NonNullType)type;
            return this.wrap("", this.type(inner.getType()), "!");
        }
        if (type instanceof ListType) {
            ListType inner = (ListType)type;
            return this.wrap("[", this.type(inner.getType()), "]");
        }
        TypeName inner = (TypeName)type;
        return inner.getName();
    }

    private NodePrinter<ObjectTypeExtensionDefinition> objectTypeExtensionDefinition() {
        return (out, node) -> out.append("extend ").append(this.node(node, ObjectTypeDefinition.class));
    }

    private NodePrinter<EnumTypeExtensionDefinition> enumTypeExtensionDefinition() {
        return (out, node) -> out.append("extend ").append(this.node(node, EnumTypeDefinition.class));
    }

    private NodePrinter<InterfaceTypeDefinition> interfaceTypeExtensionDefinition() {
        return (out, node) -> out.append("extend ").append(this.node(node, InterfaceTypeDefinition.class));
    }

    private NodePrinter<UnionTypeExtensionDefinition> unionTypeExtensionDefinition() {
        return (out, node) -> out.append("extend ").append(this.node(node, UnionTypeDefinition.class));
    }

    private NodePrinter<ScalarTypeExtensionDefinition> scalarTypeExtensionDefinition() {
        return (out, node) -> out.append("extend ").append(this.node(node, ScalarTypeDefinition.class));
    }

    private NodePrinter<InputObjectTypeExtensionDefinition> inputObjectTypeExtensionDefinition() {
        return (out, node) -> out.append("extend ").append(this.node(node, InputObjectTypeDefinition.class));
    }

    private NodePrinter<SchemaExtensionDefinition> schemaExtensionDefinition() {
        return (out, node) -> out.append("extend ").append(this.node(node, SchemaDefinition.class));
    }

    private NodePrinter<UnionTypeDefinition> unionTypeDefinition() {
        String barSep = this.compactMode ? "|" : " | ";
        String equals = this.compactMode ? "=" : "= ";
        return (out, node) -> {
            out.append(this.description(node));
            out.append(this.spaced("union", node.getName(), this.directives(node.getDirectives()), equals + this.join(node.getMemberTypes(), barSep)));
        };
    }

    private NodePrinter<VariableDefinition> variableDefinition() {
        String nameTypeSep = this.compactMode ? ":" : ": ";
        String defaultValueEquals = this.compactMode ? "=" : " = ";
        return (out, node) -> out.append('$').append(node.getName()).append(nameTypeSep).append(this.type(node.getType())).append(this.wrap(defaultValueEquals, node.getDefaultValue(), "")).append(this.directives(node.getDirectives()));
    }

    private NodePrinter<VariableReference> variableReference() {
        return (out, node) -> out.append('$').append(node.getName());
    }

    private String node(Node node) {
        return this.node(node, null);
    }

    private String node(Node node, Class startClass) {
        if (startClass != null) {
            Assert.assertTrue(startClass.isInstance(node), () -> "The starting class must be in the inherit tree");
        }
        StringBuilder builder = new StringBuilder();
        NodePrinter<Node> printer = this._findPrinter(node, startClass);
        printer.print(builder, node);
        return builder.toString();
    }

    <T extends Node> NodePrinter<T> _findPrinter(Node node) {
        return this._findPrinter(node, null);
    }

    <T extends Node> NodePrinter<T> _findPrinter(Node node, Class startClass) {
        Class<?> clazz;
        if (node == null) {
            return (out, type) -> {};
        }
        Class<?> clazz2 = clazz = startClass != null ? startClass : node.getClass();
        while (clazz != Object.class) {
            NodePrinter<? extends Node> nodePrinter = this.printers.get(clazz);
            if (nodePrinter != null) {
                return nodePrinter;
            }
            clazz = clazz.getSuperclass();
        }
        return (NodePrinter)Assert.assertShouldNeverHappen("We have a missing printer implementation for %s : report a bug!", clazz);
    }

    private <T> boolean isEmpty(List<T> list) {
        return list == null || list.isEmpty();
    }

    private boolean isEmpty(String s) {
        return s == null || s.isBlank();
    }

    private <T> List<T> nvl(List<T> list) {
        return list != null ? list : ImmutableKit.emptyList();
    }

    private NodePrinter<Value> value() {
        return (out, node) -> out.append(this.value((Value)node));
    }

    private String value(Value value) {
        String argSep;
        String string = argSep = this.compactMode ? "," : ", ";
        if (value instanceof IntValue) {
            return String.valueOf(((IntValue)value).getValue());
        }
        if (value instanceof FloatValue) {
            return String.valueOf(((FloatValue)value).getValue());
        }
        if (value instanceof StringValue) {
            return "\"" + EscapeUtil.escapeJsonString(((StringValue)value).getValue()) + "\"";
        }
        if (value instanceof EnumValue) {
            return String.valueOf(((EnumValue)value).getName());
        }
        if (value instanceof BooleanValue) {
            return String.valueOf(((BooleanValue)value).isValue());
        }
        if (value instanceof NullValue) {
            return "null";
        }
        if (value instanceof ArrayValue) {
            return "[" + this.join(((ArrayValue)value).getValues(), argSep) + "]";
        }
        if (value instanceof ObjectValue) {
            return "{" + this.join(((ObjectValue)value).getObjectFields(), argSep) + "}";
        }
        if (value instanceof VariableReference) {
            return "$" + ((VariableReference)value).getName();
        }
        return "";
    }

    private String description(Node<?> node) {
        boolean startNewLine;
        Description description = ((AbstractDescribedNode)node).getDescription();
        if (description == null || description.getContent() == null || this.compactMode) {
            return "";
        }
        boolean bl = startNewLine = description.getContent().length() > 0 && description.getContent().charAt(0) == '\n';
        String s = description.isMultiLine() ? "\"\"\"" + (startNewLine ? "" : "\n") + description.getContent() + "\n\"\"\"\n" : "\"" + EscapeUtil.escapeJsonString(description.getContent()) + "\"\n";
        return s;
    }

    private String directives(List<Directive> directives) {
        return this.join(this.nvl(directives), this.compactMode ? "" : " ");
    }

    private <T extends Node> String join(List<T> nodes, String delim) {
        return this.join(nodes, delim, "", "");
    }

    private <T extends Node> String joinTight(List<T> nodes, String delim, String prefix, String suffix) {
        StringBuilder joined = new StringBuilder();
        joined.append(prefix);
        String lastNodeText = "";
        boolean first = true;
        for (Node node : nodes) {
            String nodeText;
            if (first) {
                first = false;
            } else {
                boolean canButtTogether = lastNodeText.endsWith("}");
                if (!canButtTogether) {
                    joined.append(delim);
                }
            }
            lastNodeText = nodeText = this.node(node);
            joined.append(nodeText);
        }
        joined.append(suffix);
        return joined.toString();
    }

    private <T extends Node> String join(List<T> nodes, String delim, String prefix, String suffix) {
        StringJoiner joiner = new StringJoiner(delim, prefix, suffix);
        for (Node node : nodes) {
            joiner.add(this.node(node));
        }
        return joiner.toString();
    }

    private String spaced(String ... args) {
        return this.join(" ", args);
    }

    private String smooshed(String ... args) {
        return this.join("", args);
    }

    private String join(String delim, String ... args) {
        StringJoiner joiner = new StringJoiner(delim);
        for (String arg : args) {
            if (this.isEmpty(arg)) continue;
            joiner.add(arg);
        }
        return joiner.toString();
    }

    String wrap(String start, String maybeString, String end) {
        if (this.isEmpty(maybeString)) {
            if (start.equals("\"") && end.equals("\"")) {
                return "\"\"";
            }
            return "";
        }
        return start + maybeString + (!this.isEmpty(end) ? end : "");
    }

    private <T extends Node> String block(List<T> nodes) {
        if (this.isEmpty(nodes)) {
            return "{}";
        }
        if (this.compactMode) {
            String joinedNodes = this.joinTight(nodes, " ", "", "");
            return "{" + joinedNodes + "}";
        }
        return this.indent(new StringBuilder().append("{\n").append(this.join(nodes, "\n"))) + "\n}";
    }

    private StringBuilder indent(StringBuilder maybeString) {
        for (int i = 0; i < maybeString.length(); ++i) {
            char c = maybeString.charAt(i);
            if (c != '\n') continue;
            maybeString.replace(i, i + 1, "\n  ");
            i += 3;
        }
        return maybeString;
    }

    String wrap(String start, Node maybeNode, String end) {
        if (maybeNode == null) {
            return "";
        }
        return start + this.node(maybeNode) + (this.isEmpty(end) ? "" : end);
    }

    public static String printAst(Node node) {
        StringBuilder builder = new StringBuilder();
        AstPrinter.printImpl(builder, node, false);
        return builder.toString();
    }

    public static void printAst(Writer writer, Node node) {
        String ast = AstPrinter.printAst(node);
        PrintWriter printer = new PrintWriter(writer);
        printer.write(ast);
    }

    public static String printAstCompact(Node node) {
        StringBuilder builder = new StringBuilder();
        AstPrinter.printImpl(builder, node, true);
        return builder.toString();
    }

    private static void printImpl(StringBuilder writer, Node node, boolean compactMode) {
        AstPrinter astPrinter = new AstPrinter(compactMode);
        NodePrinter<Node> printer = astPrinter._findPrinter(node);
        printer.print(writer, node);
    }

    void replacePrinter(Class<? extends Node> nodeClass, NodePrinter<? extends Node> nodePrinter) {
        this.printers.put(nodeClass, nodePrinter);
    }

    static interface NodePrinter<T extends Node> {
        public void print(StringBuilder var1, T var2);
    }
}

