/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.incremental;

import graphql.ExceptionWhileDataFetching;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.execution.ResultPath;
import graphql.language.SourceLocation;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@Internal
public class DeferredCallContext {
    private final List<GraphQLError> errors = new CopyOnWriteArrayList<GraphQLError>();

    public void onFetchingException(ResultPath path, SourceLocation sourceLocation, Throwable throwable) {
        ExceptionWhileDataFetching error = new ExceptionWhileDataFetching(path, throwable, sourceLocation);
        this.onError(error);
    }

    public void onError(GraphQLError graphqlError) {
        this.errors.add(graphqlError);
    }

    public List<GraphQLError> getErrors() {
        return this.errors;
    }
}

