/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQLContext;
import graphql.GraphQLError;
import graphql.Internal;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.AsyncSerialExecutionStrategy;
import graphql.execution.CoercedVariables;
import graphql.execution.DataLoaderDispatchStrategy;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionContextBuilder;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionStepInfo;
import graphql.execution.ExecutionStrategy;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.FieldCollector;
import graphql.execution.FieldCollectorParameters;
import graphql.execution.MergedSelectionSet;
import graphql.execution.NonNullableFieldValidator;
import graphql.execution.NonNullableFieldWasNullException;
import graphql.execution.RawVariables;
import graphql.execution.ResultPath;
import graphql.execution.ValueUnboxer;
import graphql.execution.ValuesResolver;
import graphql.execution.incremental.IncrementalCallState;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.dataloader.EmptyDataLoaderRegistryInstance;
import graphql.execution.instrumentation.dataloader.FallbackDataLoaderDispatchStrategy;
import graphql.execution.instrumentation.dataloader.PerLevelDataLoaderDispatchStrategy;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.extensions.ExtensionsBuilder;
import graphql.incremental.DelayedIncrementalPartialResult;
import graphql.incremental.IncrementalExecutionResultImpl;
import graphql.language.Document;
import graphql.language.FragmentDefinition;
import graphql.language.NodeUtil;
import graphql.language.OperationDefinition;
import graphql.language.VariableDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.impl.SchemaUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

@Internal
public class Execution {
    private final FieldCollector fieldCollector = new FieldCollector();
    private final ExecutionStrategy queryStrategy;
    private final ExecutionStrategy mutationStrategy;
    private final ExecutionStrategy subscriptionStrategy;
    private final Instrumentation instrumentation;
    private final ValueUnboxer valueUnboxer;
    private final boolean doNotAutomaticallyDispatchDataLoader;

    public Execution(ExecutionStrategy queryStrategy, ExecutionStrategy mutationStrategy, ExecutionStrategy subscriptionStrategy, Instrumentation instrumentation, ValueUnboxer valueUnboxer, boolean doNotAutomaticallyDispatchDataLoader) {
        this.queryStrategy = queryStrategy != null ? queryStrategy : new AsyncExecutionStrategy();
        this.mutationStrategy = mutationStrategy != null ? mutationStrategy : new AsyncSerialExecutionStrategy();
        this.subscriptionStrategy = subscriptionStrategy != null ? subscriptionStrategy : new AsyncExecutionStrategy();
        this.instrumentation = instrumentation;
        this.valueUnboxer = valueUnboxer;
        this.doNotAutomaticallyDispatchDataLoader = doNotAutomaticallyDispatchDataLoader;
    }

    public CompletableFuture<ExecutionResult> execute(Document document, GraphQLSchema graphQLSchema, ExecutionId executionId, ExecutionInput executionInput, InstrumentationState instrumentationState) {
        CoercedVariables coercedVariables;
        NodeUtil.GetOperationResult getOperationResult = NodeUtil.getOperation(document, executionInput.getOperationName());
        Map<String, FragmentDefinition> fragmentsByName = getOperationResult.fragmentsByName;
        OperationDefinition operationDefinition = getOperationResult.operationDefinition;
        RawVariables inputVariables = executionInput.getRawVariables();
        List<VariableDefinition> variableDefinitions = operationDefinition.getVariableDefinitions();
        try {
            coercedVariables = ValuesResolver.coerceVariableValues(graphQLSchema, variableDefinitions, inputVariables, executionInput.getGraphQLContext(), executionInput.getLocale());
        }
        catch (RuntimeException rte) {
            if (rte instanceof GraphQLError) {
                return CompletableFuture.completedFuture(new ExecutionResultImpl((GraphQLError)((Object)rte)));
            }
            throw rte;
        }
        ExecutionContext executionContext = ExecutionContextBuilder.newExecutionContextBuilder().instrumentation(this.instrumentation).instrumentationState(instrumentationState).executionId(executionId).graphQLSchema(graphQLSchema).queryStrategy(this.queryStrategy).mutationStrategy(this.mutationStrategy).subscriptionStrategy(this.subscriptionStrategy).context(executionInput.getContext()).graphQLContext(executionInput.getGraphQLContext()).localContext(executionInput.getLocalContext()).root(executionInput.getRoot()).fragmentsByName(fragmentsByName).coercedVariables(coercedVariables).document(document).operationDefinition(operationDefinition).dataLoaderRegistry(executionInput.getDataLoaderRegistry()).locale(executionInput.getLocale()).valueUnboxer(this.valueUnboxer).executionInput(executionInput).build();
        executionContext.getGraphQLContext().put("__RESULT_NODES_INFO", executionContext.getResultNodesInfo());
        InstrumentationExecutionParameters parameters = new InstrumentationExecutionParameters(executionInput, graphQLSchema);
        executionContext = this.instrumentation.instrumentExecutionContext(executionContext, parameters, instrumentationState);
        return this.executeOperation(executionContext, executionInput.getRoot(), executionContext.getOperationDefinition());
    }

    private CompletableFuture<ExecutionResult> executeOperation(ExecutionContext executionContext, Object root, OperationDefinition operationDefinition) {
        CompletionStage<ExecutionResult> result;
        GraphQLObjectType operationRootType;
        GraphQLContext graphQLContext = executionContext.getGraphQLContext();
        this.addExtensionsBuilderNotPresent(graphQLContext);
        InstrumentationExecuteOperationParameters instrumentationParams = new InstrumentationExecuteOperationParameters(executionContext);
        InstrumentationContext<ExecutionResult> executeOperationCtx = SimpleInstrumentationContext.nonNullCtx(this.instrumentation.beginExecuteOperation(instrumentationParams, executionContext.getInstrumentationState()));
        OperationDefinition.Operation operation = operationDefinition.getOperation();
        try {
            operationRootType = SchemaUtil.getOperationRootType(executionContext.getGraphQLSchema(), operationDefinition);
        }
        catch (RuntimeException rte) {
            if (rte instanceof GraphQLError) {
                ExecutionResultImpl executionResult = new ExecutionResultImpl(Collections.singletonList((GraphQLError)((Object)rte)));
                CompletableFuture<ExecutionResult> resultCompletableFuture = CompletableFuture.completedFuture(executionResult);
                executeOperationCtx.onDispatched();
                executeOperationCtx.onCompleted(executionResult, rte);
                return resultCompletableFuture;
            }
            throw rte;
        }
        FieldCollectorParameters collectorParameters = FieldCollectorParameters.newParameters().schema(executionContext.getGraphQLSchema()).objectType(operationRootType).fragments(executionContext.getFragmentsByName()).variables(executionContext.getCoercedVariables().toMap()).graphQLContext(graphQLContext).build();
        MergedSelectionSet fields = this.fieldCollector.collectFields(collectorParameters, operationDefinition.getSelectionSet(), (boolean)Optional.ofNullable(executionContext.getGraphQLContext()).map(graphqlContext -> graphqlContext.getBoolean("ENABLE_INCREMENTAL_SUPPORT")).orElse(false));
        ResultPath path = ResultPath.rootPath();
        ExecutionStepInfo executionStepInfo = ExecutionStepInfo.newExecutionStepInfo().type(operationRootType).path(path).build();
        NonNullableFieldValidator nonNullableFieldValidator = new NonNullableFieldValidator(executionContext, executionStepInfo);
        ExecutionStrategyParameters parameters = ExecutionStrategyParameters.newParameters().executionStepInfo(executionStepInfo).source(root).localContext(executionContext.getLocalContext()).fields(fields).nonNullFieldValidator(nonNullableFieldValidator).path(path).build();
        try {
            ExecutionStrategy executionStrategy = executionContext.getStrategy(operation);
            DataLoaderDispatchStrategy dataLoaderDispatchStrategy = this.createDataLoaderDispatchStrategy(executionContext, executionStrategy);
            executionContext.setDataLoaderDispatcherStrategy(dataLoaderDispatchStrategy);
            result = executionStrategy.execute(executionContext, parameters);
        }
        catch (NonNullableFieldWasNullException e) {
            result = CompletableFuture.completedFuture(new ExecutionResultImpl(null, executionContext.getErrors()));
        }
        executeOperationCtx.onDispatched();
        result = ((CompletableFuture)result).thenApply(er -> this.mergeExtensionsBuilderIfPresent((ExecutionResult)er, graphQLContext));
        result = ((CompletableFuture)result).whenComplete(executeOperationCtx::onCompleted);
        return this.incrementalSupport(executionContext, (CompletableFuture<ExecutionResult>)result);
    }

    private CompletableFuture<ExecutionResult> incrementalSupport(ExecutionContext executionContext, CompletableFuture<ExecutionResult> result) {
        return result.thenApply(er -> {
            IncrementalCallState incrementalCallState = executionContext.getIncrementalCallState();
            if (incrementalCallState.getIncrementalCallsDetected()) {
                Publisher<DelayedIncrementalPartialResult> publisher = incrementalCallState.startDeferredCalls();
                return IncrementalExecutionResultImpl.fromExecutionResult(er).hasNext(true).incrementalItemPublisher(publisher).build();
            }
            return er;
        });
    }

    private DataLoaderDispatchStrategy createDataLoaderDispatchStrategy(ExecutionContext executionContext, ExecutionStrategy executionStrategy) {
        if (executionContext.getDataLoaderRegistry() == EmptyDataLoaderRegistryInstance.EMPTY_DATALOADER_REGISTRY || this.doNotAutomaticallyDispatchDataLoader) {
            return DataLoaderDispatchStrategy.NO_OP;
        }
        if (executionStrategy instanceof AsyncExecutionStrategy) {
            return new PerLevelDataLoaderDispatchStrategy(executionContext);
        }
        return new FallbackDataLoaderDispatchStrategy(executionContext);
    }

    private void addExtensionsBuilderNotPresent(GraphQLContext graphQLContext) {
        Object builder = graphQLContext.get(ExtensionsBuilder.class);
        if (builder == null) {
            graphQLContext.put(ExtensionsBuilder.class, ExtensionsBuilder.newExtensionsBuilder());
        }
    }

    private ExecutionResult mergeExtensionsBuilderIfPresent(ExecutionResult executionResult, GraphQLContext graphQLContext) {
        Object builder = graphQLContext.get(ExtensionsBuilder.class);
        if (builder instanceof ExtensionsBuilder) {
            ExtensionsBuilder extensionsBuilder = (ExtensionsBuilder)builder;
            Map<Object, Object> currentExtensions = executionResult.getExtensions();
            if (currentExtensions != null) {
                extensionsBuilder.addValues(currentExtensions);
            }
            executionResult = extensionsBuilder.setExtensions(executionResult);
        }
        return executionResult;
    }
}

