/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.stark.io;

import com.complexible.common.rdf.model.RuleVocab;
import com.complexible.common.rdf.query.parser.sparql.ASTSPARQLRenderer;
import com.complexible.common.rdf.query.parser.sparql.BaseDeclProcessor;
import com.complexible.common.rdf.query.parser.sparql.PrefixDeclProcessor;
import com.complexible.common.rdf.query.parser.sparql.StringEscapesProcessor;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTIfThenQueryContainer;
import com.complexible.common.rdf.query.parser.sparql.ast.ParseException;
import com.complexible.common.rdf.query.parser.sparql.ast.SyntaxTreeBuilder;
import com.complexible.common.rdf.query.parser.sparql.ast.TokenMgrError;
import com.complexible.common.rdf.query.parser.sparql.ast.VisitorException;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.impl.NamespacesImpl;
import com.stardog.stark.io.IOParserContext;
import com.stardog.stark.io.InvalidRDF;
import com.stardog.stark.io.RDFHandlerException;
import com.stardog.stark.io.trig.TrigParser;
import com.stardog.stark.io.turtle.TurtleParserContext;
import com.stardog.stark.vocabs.RDF;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TrigParserWithRules
extends TrigParser {
    private static final int MAX_RULE_LENGTH = 1024;

    protected boolean parseDirective(TurtleParserContext theContext, String directive) throws IOException {
        int matchOffset;
        boolean turtleDirective = directive.startsWith("@");
        boolean ignoreCase = !turtleDirective || theContext.caseInsensitiveDirectives;
        int n = matchOffset = turtleDirective ? 1 : 0;
        if (directive.equalsIgnoreCase("rule")) {
            this.skipWSC((IOParserContext)theContext);
            Resource ruleID = this.parseRuleID((IOParserContext)theContext);
            this.skipWSC((IOParserContext)theContext);
            this.parseRule((IOParserContext)theContext, ruleID);
            return true;
        }
        if (directive.regionMatches(ignoreCase, matchOffset, "if ", 0, 2) && (directive.length() == 2 || directive.charAt(2) == '{')) {
            theContext.unread(directive);
            this.parseRule((IOParserContext)theContext, (Resource)Values.bnode());
            return true;
        }
        return super.parseDirective(theContext, directive);
    }

    protected Resource parseRuleID(IOParserContext theContext) throws IOException, InvalidRDF, RDFHandlerException {
        Value ruleID = this.parseValue(theContext);
        if (!(ruleID instanceof Resource)) {
            throw theContext.error("Illegal rule ID: " + String.valueOf(ruleID));
        }
        return (Resource)ruleID;
    }

    protected void parseRule(IOParserContext theContext, Resource ruleID) throws IOException, InvalidRDF, RDFHandlerException {
        StringBuilder sb = theContext.resetSB();
        this.parseBlock(theContext, sb, "IF");
        this.skipWSC(theContext);
        this.parseBlock(theContext, sb, "THEN");
        try {
            String ruleStr = sb.toString();
            ASTIfThenQueryContainer qc = SyntaxTreeBuilder.parseIfThenQuery(ruleStr);
            StringEscapesProcessor.process(qc);
            BaseDeclProcessor.process(qc, theContext.mBaseIRI.toString());
            PrefixDeclProcessor.process(qc, this.toMap(theContext.mNamespaces));
            ruleStr = new ASTSPARQLRenderer().render(qc);
            theContext.handle(Values.statement((Resource)ruleID, (IRI)RDF.TYPE, (Value)RuleVocab.SPARQLRule));
            theContext.handle(Values.statement((Resource)ruleID, (IRI)RuleVocab.content, (Value)Values.literal((String)ruleStr)));
        }
        catch (ParseException | TokenMgrError | VisitorException e) {
            throw theContext.error(e.getMessage());
        }
    }

    private Map<String, String> toMap(NamespacesImpl theNamespaces) {
        HashMap<String, String> aMap = new HashMap<String, String>();
        theNamespaces.forEach(ns -> aMap.put(ns.prefix(), ns.iri()));
        return aMap;
    }

    protected void parseBlock(IOParserContext theContext, StringBuilder sb, String blockName) throws IOException, InvalidRDF {
        this.parseKeyword(theContext, sb, blockName);
        this.skipWSC(theContext);
        this.parseKeyword(theContext, sb, "{");
        int curlyBracketCount = 1;
        int closingChar = -1;
        boolean longString = false;
        boolean maybeInIri = false;
        while (curlyBracketCount > 0) {
            int c = theContext.readCodePoint();
            if (c == -1) {
                throw theContext.error("Missing '}' for " + blockName);
            }
            if (closingChar == -1 && !maybeInIri && c == 35) {
                this.processComment(theContext);
                continue;
            }
            sb.append((char)c);
            if (sb.length() > 1024) {
                throw theContext.error("Rule length exceeds 1024");
            }
            if (c == 10) {
                ++theContext.mLineNumber;
                maybeInIri = false;
            } else if (closingChar != -1) {
                if (c == closingChar) {
                    if (longString) {
                        c2 = theContext.readCodePoint();
                        c3 = theContext.readCodePoint();
                        if (c == c2 && c == c3) {
                            sb.append((char)c);
                            sb.append((char)c);
                        } else {
                            theContext.unread(c3);
                            theContext.unread(c2);
                            continue;
                        }
                    }
                    closingChar = -1;
                    longString = false;
                }
            } else if (c == 60) {
                maybeInIri = true;
            } else if (c == 34 || c == 39) {
                closingChar = c;
                c2 = theContext.readCodePoint();
                c3 = theContext.readCodePoint();
                if (c == c2 && c == c3) {
                    longString = true;
                    sb.append((char)c2);
                    sb.append((char)c3);
                } else {
                    theContext.unread(c3);
                    theContext.unread(c2);
                }
            } else if (c == 123) {
                ++curlyBracketCount;
                maybeInIri = false;
            } else if (c == 125) {
                --curlyBracketCount;
                maybeInIri = false;
            } else if (c == 92) {
                c = theContext.readCodePoint();
                if (c == -1) {
                    throw new EOFException();
                }
                sb.append((char)c);
                maybeInIri = false;
            }
            if (c <= 20) {
                maybeInIri = false;
                continue;
            }
            switch (c) {
                case 32: 
                case 34: 
                case 62: 
                case 94: 
                case 96: 
                case 124: {
                    maybeInIri = false;
                }
            }
        }
    }

    protected void parseKeyword(IOParserContext theContext, StringBuilder sb, String expected) throws IOException, InvalidRDF, RDFHandlerException {
        int n = expected.length();
        for (int i = 0; i < n; ++i) {
            int c = theContext.readCodePoint();
            if (Character.toUpperCase(c) != expected.charAt(i)) {
                throw theContext.error("Expecting '" + expected + "' but found '" + expected.substring(0, i) + (char)c + "'");
            }
            sb.append((char)c);
        }
    }
}

