/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.model;

import com.complexible.common.rdf.rio.TurtleValueWriter;
import com.complexible.common.util.PrefixMapping;
import com.stardog.stark.Namespace;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import java.util.function.Function;

public class NameFormatters {
    public static final Function<String, String> localname() {
        return name -> {
            int index = name.indexOf(35);
            if (index < 0) {
                index = name.lastIndexOf(47);
            }
            if (index < 0) {
                index = name.lastIndexOf(58);
            }
            return index < 0 ? name : name.substring(index + 1);
        };
    }

    public static final Function<String, String> turtle(Iterable<Namespace> namespaces) {
        return new TurtleFormatter(namespaces);
    }

    public static final Function<String, String> auto(Iterable<Namespace> namespaces) {
        PrefixMapping prefixes = new PrefixMapping();
        namespaces.forEach(ns -> prefixes.addMapping(ns.prefix(), ns.iri()));
        return name -> prefixes.qname(name);
    }

    private static class TurtleFormatter
    implements Function<String, String> {
        private final TurtleValueWriter writer;

        public TurtleFormatter(Iterable<Namespace> namespaces) {
            this.writer = new TurtleValueWriter(namespaces);
        }

        @Override
        public String apply(String name) {
            return this.writer.write((Value)Values.iri((String)name));
        }
    }
}

