/*
 * Decompiled with CFR 0.152.
 */
package com.stardog.model;

import com.complexible.common.base.Bool;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.stardog.model.DataModel;
import com.stardog.model.DataModelBuilder;
import com.stardog.model.Property;
import com.stardog.model.Term;
import com.stardog.model.Type;
import com.stardog.stark.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;

public class DataModelBuilderImpl
implements DataModelBuilder {
    private final Set<Statement> statements = Sets.newHashSet();
    private final Map<String, TypeBuilderImpl> types = Maps.newHashMap();

    @Override
    public DataModel build() {
        return new DataModelImpl(Sets.newHashSet(this.statements), Maps.transformValues(this.types, typeImpl -> typeImpl.type));
    }

    @Override
    public void addStatement(Statement statement) {
        this.statements.add(statement);
    }

    @Override
    public DataModelBuilder.TypeBuilder newDatatype(String name) {
        return this.newType(name, Bool.TRUE);
    }

    @Override
    public DataModelBuilder.TypeBuilder newClass(String name) {
        return this.newType(name, Bool.FALSE);
    }

    private TypeBuilderImpl newType(String name, Bool isDatatype) {
        TypeBuilderImpl type = this.types.get(name);
        if (type != null) {
            if (isDatatype.isKnown()) {
                type.assertDatatype(isDatatype.isTrue());
            }
        } else {
            if (!isDatatype.isKnown() && Type.isBuiltinDatatype(name)) {
                isDatatype = Bool.TRUE;
            }
            type = new TypeBuilderImpl(name, isDatatype);
            this.types.put(name, type);
        }
        return type;
    }

    public String toString() {
        return this.types.size() + " types " + this.statements.size() + " statements";
    }

    private static class DataModelImpl
    implements DataModel {
        private final Set<Statement> statements;
        private final Map<String, Type> types;

        public DataModelImpl(Set<Statement> theStatements, Map<String, Type> theEntities) {
            this.statements = theStatements;
            this.types = theEntities;
        }

        @Override
        public Iterable<Statement> getStatements() {
            return this.statements;
        }

        @Override
        public Iterable<Type> getTypes() {
            return this.types.values();
        }

        @Override
        public Type getType(String name) {
            return this.types.get(name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DataModelImpl that = (DataModelImpl)obj;
            return Objects.equals(this.types, that.types);
        }

        public int hashCode() {
            return this.types.keySet().hashCode();
        }

        public String toString() {
            return "DefaultDataModel{\n" + Joiner.on((char)'\n').join(this.types.values()) + "}";
        }
    }

    private class TypeBuilderImpl
    extends TermBuilderImpl
    implements DataModelBuilder.TypeBuilder {
        private TypeImpl type;
        private Bool isDatatype;
        private Map<String, PropertyBuilderImpl> properties;

        private TypeBuilderImpl(String name, Bool isDatatype) {
            this.type = new TypeImpl(name, isDatatype.isTrue());
            this.isDatatype = isDatatype;
            this.properties = Maps.newHashMap();
        }

        @Override
        protected TermImpl term() {
            return this.type;
        }

        private void assertClass() {
            this.assertDatatype(false);
        }

        private void assertDatatype(boolean isDatatype) {
            if (this.isDatatype.isKnown()) {
                Preconditions.checkArgument((this.isDatatype.isTrue() == isDatatype ? 1 : 0) != 0, (Object)("Type cannot be both a class and datatype: " + this.getName()));
            } else {
                this.isDatatype = Bool.valueOf((boolean)isDatatype);
            }
        }

        @Override
        public PropertyBuilderImpl newProperty(String name) {
            this.assertClass();
            PropertyBuilderImpl builder = this.properties.get(name);
            if (builder == null) {
                builder = new PropertyBuilderImpl(name, this.type);
                this.properties.put(name, builder);
                this.type.properties.add(builder.property);
            }
            return builder;
        }

        @Override
        public DataModelBuilder.TypeBuilder addSuper(String superType) {
            this.assertClass();
            this.type.supers.add(DataModelBuilderImpl.this.newType((String)superType, (Bool)Bool.FALSE).type);
            return this;
        }
    }

    private static class TypeImpl
    extends TermImpl
    implements Type {
        private boolean datatype = false;
        private Set<Property> properties = Sets.newHashSet();
        private Set<Type> supers = Sets.newHashSet();

        public TypeImpl(String theName, boolean isDatatype) {
            super(theName);
            this.datatype = isDatatype;
        }

        @Override
        public boolean isDatatype() {
            return this.datatype;
        }

        @Override
        public boolean isClass() {
            return !this.isDatatype();
        }

        @Override
        public Set<Property> getProperties() {
            return this.properties;
        }

        @Override
        public Set<Type> getSupers() {
            return this.supers;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TypeImpl that = (TypeImpl)obj;
            return this.datatype == that.datatype && Objects.equals(this.name, that.name) && Objects.equals(this.supers, that.supers) && Objects.equals(this.properties, that.properties);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            if (this.datatype) {
                return "Datatype <" + this.name + ">";
            }
            String str = "Class <" + this.name + ">";
            if (!this.supers.isEmpty()) {
                str = str + " extends <" + Joiner.on((String)">, <").join(this.supers) + ">";
            }
            str = str + "\n";
            if (!this.properties.isEmpty()) {
                str = str + "\t" + Joiner.on((String)"\n\t").join(this.properties) + "\n";
            }
            return str;
        }
    }

    public static class PropertyImpl
    extends TermImpl
    implements Property {
        private final Type domain;
        private Optional<Type> range = Optional.empty();
        private OptionalInt minCardinality = OptionalInt.empty();
        private OptionalInt maxCardinality = OptionalInt.empty();

        public PropertyImpl(String name, Type domain) {
            super(name);
            this.domain = domain;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Type getDomain() {
            return this.domain;
        }

        @Override
        public Optional<Type> getRange() {
            return this.range;
        }

        @Override
        public OptionalInt getMinCardinality() {
            return this.minCardinality;
        }

        @Override
        public OptionalInt getMaxCardinality() {
            return this.maxCardinality;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyImpl that = (PropertyImpl)obj;
            return Objects.equals(this.name, that.name) && Objects.equals(this.domain, that.domain) && Objects.equals(this.range, that.range) && Objects.equals(this.minCardinality, that.minCardinality) && Objects.equals(this.maxCardinality, that.maxCardinality);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("<" + this.name + ">");
            if (this.getMinCardinality().isPresent() || this.getMaxCardinality().isPresent()) {
                sb.append("[");
                this.getMinCardinality().ifPresent(sb::append);
                sb.append("..");
                this.getMaxCardinality().ifPresent(sb::append);
                sb.append("]");
            }
            if (this.range.isPresent()) {
                sb.append(" <").append(this.range.get().getName()).append(">");
            }
            return sb.toString();
        }
    }

    private static abstract class TermImpl
    implements Term {
        protected final String name;
        private List<String> labels = Lists.newArrayList();
        private Optional<String> description = Optional.empty();

        public TermImpl(String theName) {
            this.name = theName;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<String> getLabels() {
            return this.labels;
        }

        @Override
        public Optional<String> getDescription() {
            return this.description;
        }
    }

    private class PropertyBuilderImpl
    extends TermBuilderImpl
    implements DataModelBuilder.PropertyBuilder {
        private PropertyImpl property;

        private PropertyBuilderImpl(String name, Type domain) {
            this.property = new PropertyImpl(name, domain);
        }

        @Override
        protected TermImpl term() {
            return this.property;
        }

        @Override
        public DataModelBuilder.PropertyBuilder range(String type) {
            this.property.range = Optional.of(DataModelBuilderImpl.this.newType((String)type, (Bool)Bool.UNKNOWN).type);
            return this;
        }

        @Override
        public Optional<Type> range() {
            return this.property.getRange();
        }

        @Override
        public DataModelBuilder.PropertyBuilder minCardinality(int cardinality) {
            this.property.minCardinality = OptionalInt.of(cardinality);
            return this;
        }

        @Override
        public OptionalInt minCardinality() {
            return this.property.minCardinality;
        }

        @Override
        public DataModelBuilder.PropertyBuilder maxCardinality(int cardinality) {
            this.property.maxCardinality = OptionalInt.of(cardinality);
            return this;
        }

        @Override
        public OptionalInt maxCardinality() {
            return this.property.maxCardinality;
        }
    }

    private static abstract class TermBuilderImpl
    implements DataModelBuilder.TermBuilder {
        private TermBuilderImpl() {
        }

        protected abstract TermImpl term();

        @Override
        public String getName() {
            return this.term().getName();
        }

        @Override
        public DataModelBuilder.TermBuilder addLabel(String label) {
            this.term().labels.add(label);
            return this;
        }

        @Override
        public List<String> labels() {
            return this.term().getLabels();
        }

        @Override
        public DataModelBuilder.TermBuilder description(String desc) {
            this.term().description = Optional.ofNullable(desc);
            return this;
        }

        @Override
        public Optional<String> description() {
            return this.term().getDescription();
        }
    }
}

