/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.rio;

import com.complexible.common.base.Options;
import com.stardog.stark.Namespace;
import com.stardog.stark.Value;
import com.stardog.stark.io.RDFHandlerException;
import com.stardog.stark.io.WriterOptions;
import com.stardog.stark.io.turtle.TurtleWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;

public final class TurtleValueWriter {
    private final ByteArrayOutputStream mStringWriter = new ByteArrayOutputStream();
    private final VisibleTurtleWriter mTurtleWriter;

    public TurtleValueWriter(Iterable<Namespace> theNamespaces) {
        this(theNamespaces, WriterOptions.defaults().set(WriterOptions.PRETTY_PRINT, (Object)false));
    }

    public TurtleValueWriter(Iterable<Namespace> theNamespaces, Options theConfig) {
        this.mTurtleWriter = new VisibleTurtleWriter(this.mStringWriter, theConfig);
        for (Namespace aNamespace : theNamespaces) {
            try {
                this.mTurtleWriter.namespace(aNamespace.prefix(), aNamespace.iri());
            }
            catch (RDFHandlerException rDFHandlerException) {}
        }
    }

    public String write(Value theValue) {
        try {
            this.mStringWriter.reset();
            this.mTurtleWriter.writeValue(theValue);
            return this.mStringWriter.toString();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static final class VisibleTurtleWriter
    extends TurtleWriter {
        public VisibleTurtleWriter(OutputStream theWriter, Options theOptions) {
            super(theWriter, theOptions);
        }

        public void writeValue(@Nonnull Value theValue) throws IOException {
            super.writeValue(theValue);
            this.mWriter.flush();
        }
    }
}

