/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.rio;

import com.complexible.common.base.AutoCloser;
import com.complexible.common.base.Disposables;
import com.complexible.common.base.Numbers;
import com.complexible.common.base.ProgressMonitor;
import com.complexible.common.base.ProgressReporter;
import com.complexible.common.base.ReportIntervalCounter;
import com.complexible.common.cancellation.CancelCheck;
import com.complexible.common.cancellation.CancellationPoint;
import com.complexible.common.collect.BoundedBuffer;
import com.complexible.common.dataexporter.TextTabularOutput;
import com.complexible.common.primitives.ArrayUtil;
import com.complexible.common.rdf.StatementIterator;
import com.complexible.common.rdf.rio.ProcessorContext;
import com.complexible.common.rdf.rio.RDFNamespaceHandler;
import com.complexible.common.rdf.rio.RDFStatementHandler;
import com.complexible.common.rdf.rio.RDFStatementList;
import com.complexible.common.rdf.rio.RDFStream;
import com.complexible.common.rdf.rio.RDFStreams;
import com.complexible.common.util.concurrent.ExecutionGroup;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Queues;
import com.google.common.primitives.Longs;
import com.stardog.stark.IRI;
import com.stardog.stark.Namespace;
import com.stardog.stark.Namespaces;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.impl.ImmutableNamespaces;
import com.stardog.stark.io.AbstractRDFHandler;
import com.stardog.stark.io.InvalidRDF;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFHandlerException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RDFStreamProcessor {
    private final ReportIntervalCounter mReportInterval = new ReportIntervalCounter(1000000L);
    private static final Logger LOGGER = LoggerFactory.getLogger(RDFStreamProcessor.class);
    private final ProcessorContext.Local mContext;
    private ConcurrentLoadManager mLoadManager;
    private RDFStatementHandler.Factory mConsumerFactory;
    private Supplier<ProgressReporter> mProgressReporterSupplier = () -> ProgressReporter.SILENT;
    private RDFNamespaceHandler mNamespaceHandler = (prefix, uri) -> {};
    private CancelCheck mCancelCheck = CancelCheck.DUMMY;
    private final Exception mCreatedTrace = LOGGER.isDebugEnabled() ? new Exception() : null;
    static final long SYNC_UPDATE_LIMIT = 65536L;
    private static final StatementList STOP_ALL_CONSUMERS = new StatementList(0);
    private static final StatementList STOP_ONE_CONSUMER = new StatementList(0);

    public static RDFStreamProcessor create(ProcessorContext cxt) {
        return new RDFStreamProcessor(cxt);
    }

    public static StatementIterator iteration(List<RDFStream> theStreams) {
        RDFStreamProcessor aProcessor = RDFStreamProcessor.create(ProcessorContext.shared()).handler(new NamespaceCollector()).add(theStreams);
        return aProcessor.getLoadManager().iteration();
    }

    private RDFStreamProcessor(ProcessorContext ctx) {
        this.mContext = new ProcessorContext.Local(ctx);
    }

    private ConcurrentLoadManager getLoadManager() {
        if (this.mLoadManager == null) {
            this.mLoadManager = new ConcurrentLoadManagerImpl();
        }
        return this.mLoadManager;
    }

    @VisibleForTesting
    int activeConsumers() {
        return this.getLoadManager().activeConsumers();
    }

    public RDFStreamProcessor handler(RDFStatementHandler.Factory theHandler) {
        this.mConsumerFactory = theHandler;
        return this;
    }

    public RDFStreamProcessor handler(RDFNamespaceHandler theNamespaceHandler) {
        this.mNamespaceHandler = theNamespaceHandler;
        return this;
    }

    public RDFStreamProcessor check(CancelCheck theCheck) {
        this.mCancelCheck = theCheck;
        return this;
    }

    public RDFStreamProcessor monitorOutput(OutputStream theStream, String theDBName) {
        if (theStream == null) {
            return this;
        }
        String temp = "Parsing ";
        if (!theDBName.isBlank()) {
            temp = temp.concat(theDBName);
            temp = temp.concat("'s ");
        }
        String title = temp.concat("triples");
        ProgressReporter reporter = this.mProgressReporterSupplier.get();
        this.mProgressReporterSupplier = () -> ProgressMonitor.builder((String)title).maxProgress(0L).output(theStream).reportIntervalPercent(1).reportingDelegate(Optional.of(reporter)).messageFormatter((ProgressMonitor.ProgressFormatter)new ProgressMonitor.DefaultProgressFormatter(){

            public String format(String theName, int theProgressPercentage, long theElapsedTime) {
                long aTripleCount = RDFStreamProcessor.this.mReportInterval.getCount();
                long aTime = RDFStreamProcessor.this.mReportInterval.getElapsedTime();
                float aSpeed = aTime == 0L ? 0.0f : (float)aTripleCount / (float)aTime;
                String aFormat = " (%s triples - %1.1fK triples/sec)";
                return super.format(theName, theProgressPercentage, theElapsedTime) + String.format(aFormat, Numbers.readable((long)aTripleCount), Float.valueOf(aSpeed));
            }
        }).build();
        return this;
    }

    public RDFStreamProcessor monitorOutput(ProgressReporter reporter) {
        this.mProgressReporterSupplier = () -> reporter;
        return this;
    }

    public RDFStreamProcessor maxParsers(int count) {
        this.mContext.setMaxProducers(count);
        return this;
    }

    public RDFStreamProcessor maxHandlers(int count) {
        this.mContext.setMaxConsumers(count);
        return this;
    }

    public RDFStreamProcessor resizeHandlers(boolean value) {
        this.mContext.setResizeConsumers(value);
        return this;
    }

    public RDFStreamProcessor add(RDFStream theStream) {
        this.getLoadManager().add(theStream);
        return this;
    }

    public RDFStreamProcessor add(Iterable<RDFStream> theStreams) {
        ConcurrentLoadManager aLoadManager = this.getLoadManager();
        for (RDFStream aStream : theStreams) {
            aLoadManager.add(aStream);
        }
        return this;
    }

    public Throwable anyException() {
        return this.getLoadManager().anyException();
    }

    public void process() throws InvalidRDF, IOException {
        Map<RDFStream, Exception> aExceptions = this.processSilently();
        if (!aExceptions.isEmpty()) {
            Throwable e = aExceptions.values().iterator().next();
            if (e instanceof RDFHandlerException && e.getCause() != null) {
                e = e.getCause();
            }
            Throwables.throwIfInstanceOf((Throwable)e, IOException.class);
            Throwables.throwIfInstanceOf((Throwable)e, InvalidRDF.class);
            Throwables.throwIfInstanceOf((Throwable)e, CancellationException.class);
            throw new InvalidRDF(e.getMessage(), -1L, -1L);
        }
    }

    public Map<RDFStream, Exception> processSilently() {
        Preconditions.checkState((this.mConsumerFactory != null ? 1 : 0) != 0, (Object)"No handler provided");
        return this.mLoadManager.processAndWait();
    }

    public void cancel(String theCause) {
        if (this.mLoadManager != null) {
            this.mLoadManager.cancel(theCause);
        }
    }

    public static void main(String[] args) {
        TextTabularOutput t = new TextTabularOutput((OutputStream)System.out, new String[]{"Processors", "Parser", "Handlers"});
        for (int availableProcessors : new int[]{2, 4, 8, 16, 32, 64, 128}) {
            int maxProcessors = (int)((double)availableProcessors * (1.0 - 0.1 * (Math.log(availableProcessors) / Math.log(2.0))));
            double maxConsumerRatio = 1.33;
            int maxParserCount = Math.max(1, (int)Math.floor((double)maxProcessors / (1.0 + maxConsumerRatio)));
            t.addRow(new Object[]{availableProcessors, maxParserCount, (int)Math.round(maxConsumerRatio * (double)maxParserCount)});
        }
        t.output();
    }

    private static class NamespaceCollector
    implements RDFNamespaceHandler {
        private final Queue<Namespace> mNamespaces = Queues.newArrayBlockingQueue((int)100);

        private NamespaceCollector() {
        }

        public Iterable<Namespace> namespaces() {
            return this.mNamespaces;
        }

        @Override
        public synchronized void handleNamespace(String prefix, String uri) {
            this.mNamespaces.offer(Values.namespace((String)prefix, (String)uri));
        }
    }

    private static interface ConcurrentLoadManager {
        public void putList(StatementList var1) throws InterruptedException;

        public void add(RDFStream var1);

        public StatementList takeList() throws InterruptedException;

        public void returnList(StatementList var1) throws InterruptedException;

        public StatementList newList(RDFStream var1) throws InterruptedException;

        public RDFStream nextStream();

        public void setException(RDFStream var1, Exception var2);

        public boolean isException(RDFStream var1);

        public Throwable getException(RDFStream var1);

        public Throwable anyException();

        public void handleNamespace(String var1, String var2);

        public Map<RDFStream, Exception> processAndWait();

        public StatementIterator iteration();

        public void incrementProgress(long var1);

        public void cancel(String var1);

        public void cancelAsync(String var1);

        @VisibleForTesting
        public int activeConsumers();
    }

    private class ConcurrentLoadManagerImpl
    implements ConcurrentLoadManager {
        private static final int MAX_STREAM_CAPACITY = 1024;
        private static final int MAX_QUEUE_CAPACITY = 16;
        private final BlockingQueue<RDFStream> mStreams;
        private final BoundedBuffer<StatementList> mWorkQueue = new BoundedBuffer(16);
        private final BlockingQueue<StatementList> mIdleQueue;
        private final ConcurrentMap<RDFStream, Exception> mExceptions = new ConcurrentHashMap<RDFStream, Exception>();
        private volatile boolean mClosed = false;
        private final CountDownLatch mNamespaceLatch;
        private final ProgressReporter mMonitor;
        private final Stopwatch logElapsedTime = Stopwatch.createStarted();
        private final ExecutionGroup mConsumerGroup;
        private final ExecutionGroup mProducerGroup;
        private final CancellationPoint mProducerCancellation;
        private final Runnable mProducerFinishedTask = new Runnable(){

            @Override
            public void run() {
                int aProducersRunning = RDFStreamProcessor.this.mContext.stoppedProducer();
                LOGGER.debug("Producer finished, remaining {}", (Object)aProducersRunning);
                if (ConcurrentLoadManagerImpl.this.mNamespaceLatch != null) {
                    ConcurrentLoadManagerImpl.this.mNamespaceLatch.countDown();
                }
                assert (aProducersRunning >= 0);
                if (aProducersRunning == 0 && ConcurrentLoadManagerImpl.this.mClosed || ConcurrentLoadManagerImpl.this.mProducerCancellation.isCancelled()) {
                    ConcurrentLoadManagerImpl.this.stopAllConsumers();
                } else {
                    ConcurrentLoadManagerImpl.this.stopConsumers();
                }
            }
        };

        private ConcurrentLoadManagerImpl() {
            LOGGER.debug("Loader initialized with {} max parsers and {} max handlers", (Object)RDFStreamProcessor.this.mContext.maxProducerCount(), (Object)RDFStreamProcessor.this.mContext.maxConsumerCount());
            this.mProducerCancellation = CancellationPoint.forCancelCheck((String)"RDF parser", (CancelCheck)RDFStreamProcessor.this.mCancelCheck);
            this.mStreams = new PriorityBlockingQueue<RDFStream>(16, (s1, s2) -> Longs.compare((long)s2.length(), (long)s1.length()));
            this.mIdleQueue = new ArrayBlockingQueue<StatementList>(16 + RDFStreamProcessor.this.mContext.maxProducerCount() + RDFStreamProcessor.this.mContext.maxConsumerCount());
            this.mNamespaceLatch = RDFStreamProcessor.this.mConsumerFactory != null ? null : new CountDownLatch(1);
            this.mConsumerGroup = ExecutionGroup.concurrent((ExecutorService)RDFStreamProcessor.this.mContext.getExecutor());
            this.mProducerGroup = ExecutionGroup.concurrent((ExecutorService)RDFStreamProcessor.this.mContext.getExecutor());
            this.mMonitor = RDFStreamProcessor.this.mProgressReporterSupplier.get();
        }

        @Override
        public int activeConsumers() {
            return RDFStreamProcessor.this.mContext.getRunningConsumers();
        }

        private void startConsumers() {
            if (RDFStreamProcessor.this.mConsumerFactory != null) {
                while (RDFStreamProcessor.this.mContext.mayStartConsumer()) {
                    this.startConsumer();
                }
            }
        }

        private void stopConsumers() {
            if (RDFStreamProcessor.this.mConsumerFactory != null) {
                while (RDFStreamProcessor.this.mContext.mustStopConsumer()) {
                    LOGGER.debug("Finishing a consumer, remaining {}", (Object)RDFStreamProcessor.this.mContext.getRunningConsumers());
                    this.mWorkQueue.putUninterruptibly((Object)STOP_ONE_CONSUMER);
                }
            }
        }

        @Override
        public synchronized void add(RDFStream theStream) {
            boolean small;
            Preconditions.checkState((!this.mClosed ? 1 : 0) != 0, (Object)"Already closed");
            long length = theStream.length();
            boolean bl = small = length > 0L && length < 65536L;
            if (RDFStreamProcessor.this.mConsumerFactory != null && (small || this.mStreams.size() >= 1024 || RDFStreamProcessor.this.mContext.wouldExceedProducerLimits())) {
                LOGGER.debug("Processing RDFStream on the calling thread");
                this.parseDirectly(theStream);
            } else {
                this.mStreams.add(theStream);
                this.mMonitor.incrementMaxProgress(theStream.length());
                if (RDFStreamProcessor.this.mContext.mayStartProducer()) {
                    this.startProducer();
                    this.startConsumers();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parseDirectly(RDFStream theStream) {
            RDFStatementHandler aStmtHandler = RDFStreamProcessor.this.mConsumerFactory.create();
            DirectProducer aProducer = new DirectProducer(this, theStream, aStmtHandler);
            try {
                theStream.parse((RDFHandler)aProducer);
            }
            catch (Exception e) {
                try {
                    this.setException(theStream, e);
                }
                catch (Throwable throwable) {
                    AutoCloser.close(err -> LOGGER.error("Unexpected error when closing an RDF stream"), (AutoCloseable[])new AutoCloseable[]{theStream});
                    throw throwable;
                }
                AutoCloser.close(err -> LOGGER.error("Unexpected error when closing an RDF stream"), (AutoCloseable[])new AutoCloseable[]{theStream});
            }
            AutoCloser.close(err -> LOGGER.error("Unexpected error when closing an RDF stream"), (AutoCloseable[])new AutoCloseable[]{theStream});
        }

        @Override
        public StatementList takeList() throws InterruptedException {
            return (StatementList)this.mWorkQueue.take();
        }

        @Override
        public void putList(StatementList theList) throws InterruptedException {
            assert (theList != null);
            assert (theList == STOP_ALL_CONSUMERS || theList.mSize > 0);
            if (theList != STOP_ALL_CONSUMERS && RDFStreamProcessor.this.mReportInterval.increment((long)theList.mSize)) {
                this.logStats();
                this.mMonitor.print();
            }
            this.mWorkQueue.put((Object)theList);
            if (this.mNamespaceLatch != null) {
                this.mNamespaceLatch.countDown();
            }
        }

        @Override
        public void returnList(StatementList theList) throws InterruptedException {
            if (!this.mIdleQueue.offer(theList) && RDFStreamProcessor.this.mContext.getRunningProducers() > 0) {
                this.mIdleQueue.offer(theList, 50L, TimeUnit.MILLISECONDS);
            }
        }

        @Override
        public StatementList newList(RDFStream theStream) {
            StatementList aList = (StatementList)this.mIdleQueue.poll();
            if (aList == null) {
                aList = new StatementList();
            }
            aList.reset(theStream);
            return aList;
        }

        @Override
        public void handleNamespace(String prefix, String uri) {
            RDFStreamProcessor.this.mNamespaceHandler.handleNamespace(prefix, uri);
        }

        @Override
        public RDFStream nextStream() {
            return (RDFStream)this.mStreams.poll();
        }

        @Override
        public void setException(RDFStream theStream, Exception theException) {
            String aMsg = RDFStreams.formatParseException(theStream, theException);
            Throwable aCause = Throwables.getRootCause((Throwable)theException);
            if (aCause instanceof FileNotFoundException || aCause instanceof InvalidRDF || aCause instanceof CancellationException) {
                LOGGER.warn("Error during loading {}", (Object)aMsg);
            } else {
                LOGGER.warn("Error during loading {}", (Object)aMsg, (Object)theException);
            }
            if (RDFStreamProcessor.this.mCreatedTrace != null) {
                LOGGER.warn("Parse process creator: ", (Throwable)RDFStreamProcessor.this.mCreatedTrace);
            }
            if (this.mNamespaceLatch != null) {
                this.mNamespaceLatch.countDown();
            }
            this.mExceptions.put(theStream != null ? theStream : RDFStreams.EMPTY, theException);
            if (aCause instanceof CancellationException || aCause instanceof Error) {
                this.stopAll(aCause.getMessage());
            }
        }

        private void setException(Exception theException) {
            this.setException(RDFStreams.EMPTY, theException);
        }

        @Override
        public boolean isException(RDFStream theStream) {
            return this.mExceptions.containsKey(theStream) || this.mExceptions.containsKey(RDFStreams.EMPTY);
        }

        @Override
        public Throwable getException(RDFStream theStream) {
            return this.mExceptions.getOrDefault(theStream, (Exception)this.mExceptions.get(RDFStreams.EMPTY));
        }

        @Override
        public Throwable anyException() {
            return this.mExceptions.values().stream().reduce((a, b) -> {
                a.addSuppressed((Throwable)b);
                return b;
            }).orElse(null);
        }

        @Override
        public void incrementProgress(long theProgress) {
            this.mMonitor.increment(theProgress);
        }

        private void startProducer() {
            int running = RDFStreamProcessor.this.mContext.startedProducer();
            ProducerThread aProducer = new ProducerThread(this, this.mProducerFinishedTask, this.mProducerCancellation);
            LOGGER.debug("Starting producer " + running);
            this.mProducerGroup.add((Callable)aProducer);
        }

        private void startConsumer() {
            int running = RDFStreamProcessor.this.mContext.startedConsumer();
            LOGGER.debug("Starting consumer " + running);
            Consumer aConsumer = new Consumer(this, RDFStreamProcessor.this.mContext::stoppedConsumer, RDFStreamProcessor.this.mConsumerFactory.create());
            this.mConsumerGroup.add((Callable)aConsumer);
        }

        private void stopAllConsumers() {
            RDFStreamProcessor.this.mContext.willStopAllConsumers();
            this.mWorkQueue.putUninterruptibly((Object)STOP_ALL_CONSUMERS);
            this.mIdleQueue.clear();
        }

        private void logStats() {
            if (LOGGER.isDebugEnabled() && this.logElapsedTime.elapsed(TimeUnit.SECONDS) > 600L) {
                this.logElapsedTime.reset().start();
                LOGGER.debug(String.format("Queue size: %,d Idle size: %,d (P=%d C=%d)", this.mWorkQueue.size(), this.mIdleQueue.size(), RDFStreamProcessor.this.mContext.getRunningProducers(), RDFStreamProcessor.this.mContext.getRunningConsumers()));
            }
        }

        private void stopAcceptingWork() {
            this.mClosed = true;
            if (RDFStreamProcessor.this.mContext.getRunningProducers() == 0) {
                this.stopAllConsumers();
            }
        }

        @Override
        public synchronized Map<RDFStream, Exception> processAndWait() {
            try {
                this.stopAcceptingWork();
                this.mConsumerGroup.executeAndWait();
                this.logStats();
                this.mMonitor.stop();
            }
            catch (Exception e) {
                this.setException(e);
            }
            return this.mExceptions;
        }

        void cancelQuietly() {
            this.cancel("Execution has been cancelled");
        }

        @Override
        public void cancelAsync(String theCause) {
            String aMsg = theCause == null ? "Processing canceled" : theCause;
            Exception prevException = this.mExceptions.putIfAbsent(RDFStreams.EMPTY, new CancellationException(aMsg));
            if (prevException == null) {
                LOGGER.debug("Canceling the concurrent RDF load manager, waiting for all producers and consumers to stop");
            }
            this.stopAll(theCause);
        }

        private void stopAll(String cause) {
            this.mClosed = true;
            this.mProducerCancellation.cancel(cause);
            this.mWorkQueue.clear();
            this.stopAllConsumers();
        }

        @Override
        public void cancel(String theCause) {
            this.cancelAsync(theCause);
            this.waitSilently(this.mProducerGroup, "producers");
            this.waitSilently(this.mConsumerGroup, "consumers");
        }

        private void waitSilently(ExecutionGroup group, String theTask) {
            try {
                group.executeAndWait();
            }
            catch (CancellationException cancellationException) {
            }
            catch (Exception t) {
                LOGGER.debug("Error while waiting for RDF " + theTask + " to stop on cancel", (Throwable)t);
            }
        }

        @Override
        public StatementIterator iteration() {
            this.stopAcceptingWork();
            return new StmtIter();
        }

        private final class StmtIter
        extends AbstractIterator<Statement>
        implements StatementIterator {
            private StatementList mList;
            private Iterator<Statement> mIter = ImmutableSet.of().iterator();
            private boolean mClosed = false;

            private StmtIter() {
                Disposables.markCreated((Object)this);
            }

            public void close() {
                Disposables.markReleased((Object)this);
                if (!this.mClosed) {
                    ConcurrentLoadManagerImpl.this.cancelQuietly();
                    this.mClosed = true;
                    ConcurrentLoadManagerImpl.this.mNamespaceLatch.countDown();
                }
            }

            private void checkException() {
                if (this.mClosed) {
                    throw new IllegalStateException("Closed iteration");
                }
                if (!ConcurrentLoadManagerImpl.this.mExceptions.isEmpty()) {
                    Iterator exceptionIterator = ConcurrentLoadManagerImpl.this.mExceptions.values().iterator();
                    Exception firstException = (Exception)exceptionIterator.next();
                    RDFStreamProcessorException rspe = new RDFStreamProcessorException(firstException.getClass().getSimpleName() + " processing RDF stream: " + firstException.getMessage(), firstException);
                    while (exceptionIterator.hasNext()) {
                        rspe.addSuppressed((Throwable)exceptionIterator.next());
                    }
                    throw rspe;
                }
            }

            public Statement computeNext() {
                try {
                    if (!this.mIter.hasNext()) {
                        if (this.mList != null) {
                            ConcurrentLoadManagerImpl.this.returnList(this.mList);
                        }
                        this.mList = (StatementList)ConcurrentLoadManagerImpl.this.mWorkQueue.take();
                        if (this.mList == STOP_ALL_CONSUMERS) {
                            this.checkException();
                            return (Statement)this.endOfData();
                        }
                        this.mIter = ArrayUtil.iterator((Object[])this.mList.statements(), (int)0, (int)this.mList.size());
                    }
                    this.checkException();
                    Statement aStmt = this.mIter.next();
                    if (this.mList.getContext() != null) {
                        aStmt = Values.statement((Resource)aStmt.subject(), (IRI)aStmt.predicate(), (Value)aStmt.object(), (Resource)this.mList.getContext());
                    }
                    return aStmt;
                }
                catch (Exception e) {
                    Throwables.throwIfInstanceOf((Throwable)e, RuntimeException.class);
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Namespaces namespaces() {
                try {
                    ConcurrentLoadManagerImpl.this.mNamespaceLatch.await();
                    return new ImmutableNamespaces(((NamespaceCollector)RDFStreamProcessor.this.mNamespaceHandler).namespaces());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException();
                }
            }
        }
    }

    private static class StatementList
    implements RDFStatementList {
        private static final int LIST_COUNT_CAPACITY = 10000;
        private static final int LIST_MEM_CAPACITY = 0x200000;
        private final Statement[] mData;
        private int mSize;
        private int mMemory;
        private RDFStream mStream;

        public StatementList() {
            this(10000);
        }

        public StatementList(int capacity) {
            this.mData = new Statement[capacity];
            this.mSize = 0;
        }

        private boolean add(Statement stmt) {
            this.mData[this.mSize++] = stmt;
            this.mMemory += Value.lexLength((Value)stmt.object());
            return this.mSize == this.mData.length || this.mMemory > 0x200000;
        }

        private void reset(RDFStream theStream) {
            this.mSize = 0;
            this.mMemory = 0;
            this.mStream = theStream;
        }

        @Override
        public Resource getContext() {
            return this.mStream.getContext();
        }

        @Override
        public Statement[] statements() {
            return this.mData;
        }

        @Override
        public int size() {
            return this.mSize;
        }
    }

    private static class Consumer
    extends Worker {
        private final RDFStatementHandler mHandler;

        private Consumer(ConcurrentLoadManager mManager, Runnable finalTask, RDFStatementHandler theHandler) {
            super(mManager, finalTask);
            this.mHandler = theHandler;
        }

        @Override
        protected void work() {
            boolean done = false;
            LOGGER.debug("Consumer started");
            while (!done) {
                StatementList aList = null;
                try {
                    aList = this.mManager.takeList();
                    if (aList == STOP_ONE_CONSUMER || aList == STOP_ALL_CONSUMERS) {
                        done = true;
                        this.mHandler.finish();
                        if (aList != STOP_ALL_CONSUMERS) break;
                        this.mManager.putList(STOP_ALL_CONSUMERS);
                        break;
                    }
                    this.mHandler.handleStatements(aList);
                    this.mManager.returnList(aList);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    done = true;
                }
                catch (Exception e) {
                    this.setManagerException(aList, e);
                }
                catch (Throwable e) {
                    this.setManagerException(aList, new RuntimeException(e));
                }
            }
            this.mHandler.close();
            LOGGER.debug("Consumer completed");
        }

        private void setManagerException(StatementList theList, Exception e) {
            if (theList != null) {
                this.mManager.setException(theList.mStream, e);
            } else {
                this.mManager.setException(RDFStreams.EMPTY, e);
            }
        }
    }

    private static class DirectProducer
    extends AbstractRDFHandler {
        private final ConcurrentLoadManager mManager;
        private final RDFStatementHandler mHandler;
        private final RDFStream mStream;
        private StatementList mCurrentList;

        public DirectProducer(ConcurrentLoadManager theManager, RDFStream theStream, RDFStatementHandler theHandler) {
            this.mManager = theManager;
            this.mStream = theStream;
            this.mHandler = theHandler;
        }

        public void start() throws RDFHandlerException {
            try {
                this.mCurrentList = this.mManager.newList(this.mStream);
            }
            catch (InterruptedException e) {
                throw new RDFHandlerException((Throwable)e);
            }
        }

        public void namespace(@Nonnull String prefix, @Nonnull String uri) throws RDFHandlerException {
            this.mManager.handleNamespace(prefix, uri);
        }

        public void handle(@Nonnull Statement theStatement) throws RDFHandlerException {
            try {
                if (this.mCurrentList.add(theStatement)) {
                    this.mHandler.handleStatements(this.mCurrentList);
                    this.mCurrentList = this.mManager.newList(this.mStream);
                }
            }
            catch (Exception e) {
                throw new RDFHandlerException((Throwable)e);
            }
        }

        public void end() throws RDFHandlerException {
            try {
                if (this.mCurrentList.mSize > 0) {
                    this.mHandler.handleStatements(this.mCurrentList);
                }
                this.mHandler.finish();
                this.mManager.returnList(this.mCurrentList);
            }
            catch (Exception e) {
                throw new RDFHandlerException((Throwable)e);
            }
        }
    }

    private static class Producer
    extends AbstractRDFHandler {
        private final ConcurrentLoadManager mManager;
        private final RDFStream mStream;
        private StatementList mCurrentList;
        private long mBytesRead = 0L;
        private final CancelCheck mCancel;

        public Producer(ConcurrentLoadManager theManager, RDFStream theStream, CancelCheck theCancel) {
            this.mManager = theManager;
            this.mStream = theStream;
            this.mCancel = theCancel;
        }

        public void start() throws RDFHandlerException {
            Preconditions.checkState((this.mCurrentList == null ? 1 : 0) != 0, (Object)"Handler has already been started");
            try {
                this.mCurrentList = this.mManager.newList(this.mStream);
            }
            catch (InterruptedException e) {
                throw new RDFHandlerException((Throwable)e);
            }
        }

        public void namespace(@Nonnull String prefix, @Nonnull String uri) throws RDFHandlerException {
            this.mManager.handleNamespace(prefix, uri);
        }

        public void handle(@Nonnull Statement theStatement) throws RDFHandlerException {
            try {
                if (this.mCurrentList.add(theStatement)) {
                    if (this.mManager.isException(this.mStream)) {
                        Throwable e = this.mManager.getException(this.mStream);
                        Throwables.throwIfInstanceOf((Throwable)e, RDFHandlerException.class);
                        Throwables.throwIfInstanceOf((Throwable)e, CancellationException.class);
                        throw new RDFHandlerException(e);
                    }
                    this.mCancel.check();
                    this.mManager.putList(this.mCurrentList);
                    this.mCurrentList = this.mManager.newList(this.mStream);
                    this.reportBytesRead();
                }
            }
            catch (InterruptedException e) {
                throw new CancellationException(e.getMessage());
            }
        }

        public void end() throws RDFHandlerException {
            try {
                if (this.mCurrentList.mSize > 0) {
                    this.mManager.putList(this.mCurrentList);
                    this.mCurrentList = null;
                }
                this.reportBytesRead();
            }
            catch (InterruptedException e) {
                throw new RDFHandlerException((Throwable)e);
            }
        }

        private void reportBytesRead() {
            long aBytesRead = this.mStream.bytesRead();
            this.mManager.incrementProgress(aBytesRead - this.mBytesRead);
            this.mBytesRead = aBytesRead;
        }
    }

    private static class ProducerThread
    extends Worker {
        private final CancellationPoint mCancel;

        private ProducerThread(ConcurrentLoadManager mManager, Runnable theFinalTask, CancellationPoint theCancel) {
            super(mManager, theFinalTask);
            this.mCancel = theCancel;
        }

        /*
         * Loose catch block
         */
        @Override
        protected void work() {
            while (true) {
                RDFStream aStream;
                block8: {
                    aStream = null;
                    aStream = this.mManager.nextStream();
                    if (aStream != null) break block8;
                    AutoCloser.close(err -> LOGGER.error("Unexpected error closing an RDF stream", err), (AutoCloseable[])new AutoCloseable[]{aStream});
                    break;
                }
                try {
                    LOGGER.debug("Start parsing {}", (Object)aStream.getName());
                    Producer aProducer = new Producer(this.mManager, aStream, (CancelCheck)this.mCancel);
                    aStream.parse((RDFHandler)aProducer);
                    LOGGER.debug("Finished parsing {}", (Object)aStream.getName());
                }
                catch (Exception e) {
                    block9: {
                        this.mManager.setException(aStream, e);
                        if (!(e instanceof CancellationException) && !(Throwables.getRootCause((Throwable)e) instanceof CancellationException)) break block9;
                        AutoCloser.close(err -> LOGGER.error("Unexpected error closing an RDF stream", err), (AutoCloseable[])new AutoCloseable[]{aStream});
                        break;
                    }
                    AutoCloser.close(err -> LOGGER.error("Unexpected error closing an RDF stream", err), (AutoCloseable[])new AutoCloseable[]{aStream});
                    continue;
                }
                catch (Throwable e2) {
                    this.mManager.setException(aStream, new RuntimeException(e2));
                    {
                        catch (Throwable throwable) {
                            AutoCloser.close(err -> LOGGER.error("Unexpected error closing an RDF stream", err), (AutoCloseable[])new AutoCloseable[]{aStream});
                            throw throwable;
                        }
                    }
                    AutoCloser.close(err -> LOGGER.error("Unexpected error closing an RDF stream", err), (AutoCloseable[])new AutoCloseable[]{aStream});
                    break;
                }
                AutoCloser.close(err -> LOGGER.error("Unexpected error closing an RDF stream", err), (AutoCloseable[])new AutoCloseable[]{aStream});
                continue;
                break;
            }
        }
    }

    private static abstract class Worker
    implements Callable<Void> {
        protected final ConcurrentLoadManager mManager;
        private final Runnable mFinalTask;

        public Worker(ConcurrentLoadManager theManager, Runnable theFinalTask) {
            this.mManager = theManager;
            this.mFinalTask = theFinalTask;
        }

        @Override
        public Void call() {
            try {
                this.work();
            }
            finally {
                if (this.mFinalTask != null) {
                    this.mFinalTask.run();
                }
            }
            return null;
        }

        protected abstract void work();
    }

    private static class RDFStreamProcessorException
    extends RuntimeException {
        RDFStreamProcessorException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

