/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.rio;

import com.complexible.common.base.Objects2;
import com.complexible.common.base.Options;
import com.complexible.common.cancellation.CancellationPoint;
import com.complexible.common.cancellation.DummyCancellationPoint;
import com.complexible.common.io.Files2;
import com.complexible.common.rdf.rio.RDFStream;
import com.complexible.common.rdf.rio.RDFStreamBase;
import com.complexible.common.rdf.rio.RDFStreamOptions;
import com.complexible.common.rdf.rio.RDFStreams;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closeables;
import com.google.common.io.CountingInputStream;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Values;
import com.stardog.stark.io.AbstractRDFHandler;
import com.stardog.stark.io.FileFormat;
import com.stardog.stark.io.ForwardingRDFHandler;
import com.stardog.stark.io.IOParserContext;
import com.stardog.stark.io.InvalidRDF;
import com.stardog.stark.io.LineSupplier;
import com.stardog.stark.io.LineSupplierParserContext;
import com.stardog.stark.io.ParserContext;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFHandler;
import com.stardog.stark.io.RDFHandlerException;
import com.stardog.stark.io.RDFParser;
import com.stardog.stark.io.RDFParsers;
import com.stardog.stark.io.ntriples.NTParser;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import org.apache.commons.io.input.BOMInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RDFStreamBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(RDFStreamBuilder.class);
    private RDFFormat mFormat;
    private Function<Path, Resource> mContexts = new ConstantResourceFunction(null);
    private Options mConfig = Options.create();
    private Collection<Path> mFiles;
    private InputStream mStream;
    private PrintStream mReporter = null;
    private CancellationPoint mCancellationPoint = null;
    private boolean mIgnoreFileErrors = false;
    private int bnodePrefixCounter = 0;

    RDFStreamBuilder(Collection<Path> theFiles) {
        this.mFiles = theFiles;
    }

    RDFStreamBuilder(InputStream theStream) {
        this.mStream = theStream;
    }

    public RDFStreamBuilder format(RDFFormat theFormat) {
        this.mFormat = theFormat;
        return this;
    }

    public RDFStreamBuilder config(Options theConfig) {
        Preconditions.checkNotNull((Object)theConfig, (Object)"Config cannot be null");
        this.mConfig = theConfig;
        return this;
    }

    public RDFStreamBuilder context(Resource theContext) {
        return this.contexts(new ConstantResourceFunction(theContext));
    }

    public RDFStreamBuilder contexts(Function<Path, Resource> theContexts) {
        this.mContexts = theContexts;
        return this;
    }

    public RDFStreamBuilder reporter(PrintStream theReporter) {
        this.mReporter = theReporter;
        return this;
    }

    public RDFStreamBuilder ignoreFileErrors(boolean theIgnoreFileErrors) {
        this.mIgnoreFileErrors = theIgnoreFileErrors;
        return this;
    }

    public RDFStreamBuilder setCancellationPoint(CancellationPoint theCancellationPoint) {
        this.mCancellationPoint = theCancellationPoint;
        return this;
    }

    public void parse(RDFHandler theHandler) throws InvalidRDF, RDFHandlerException, IOException {
        ForwardingRDFHandler aHandler = new ForwardingRDFHandler(this, theHandler){

            public void start() throws RDFHandlerException {
            }

            public void end() throws RDFHandlerException {
            }
        };
        theHandler.start();
        for (RDFStream aStream : this.build()) {
            aStream.parse((RDFHandler)aHandler);
        }
        theHandler.end();
    }

    public <T extends Collection<Statement>> T parseInto(final T theCollection) throws InvalidRDF, RDFHandlerException, IOException {
        this.parse((RDFHandler)new AbstractRDFHandler(this){

            public void handle(@Nonnull Statement theStatement) {
                theCollection.add(theStatement);
            }
        });
        return theCollection;
    }

    public List<RDFStream> build() {
        if (this.mStream != null) {
            Preconditions.checkNotNull((Object)this.mFormat, (Object)"No RDF format provided");
            Resource aContext = this.mContexts instanceof ConstantResourceFunction ? ((ConstantResourceFunction)this.mContexts).mContext : null;
            List<RDFStream> multiThreadedStreams = this.createMultiThreadedStreams((compression, queueSize) -> new LineSupplier(this.mStream, compression, queueSize.intValue()), aContext, this.mFormat, "InputStream", 0L);
            if (!multiThreadedStreams.isEmpty()) {
                return multiThreadedStreams;
            }
            return ImmutableList.of((Object)new RDFInputStream(this.mStream, aContext, this.newParserConfig(), this.mFormat, this.mCancellationPoint));
        }
        if (this.mFiles != null) {
            return this.mFiles.stream().flatMap(file -> this.createStreams((Path)file, this.mContexts.apply((Path)file), false).stream()).collect(Collectors.toList());
        }
        throw new IllegalArgumentException("No input provided");
    }

    private Options newParserConfig() {
        String bnodePrefix = (String)this.mConfig.get(ParserContext.BNODE_ID_PREFIX);
        if (bnodePrefix == null) {
            return this.mConfig;
        }
        Options newConfig = this.mConfig.copy();
        newConfig.set(ParserContext.BNODE_ID_PREFIX, (Object)(bnodePrefix + this.bnodePrefixCounter++));
        return newConfig;
    }

    private List<RDFStream> createStreams(Path theFile, Resource theContext, boolean theIgnoreUnsupported) {
        RDFFormat aFormat;
        if (Files.isDirectory(theFile, new LinkOption[0])) {
            List<RDFStream> list;
            block13: {
                Stream<Path> aStream = Files.list(theFile);
                try {
                    list = aStream.flatMap(aFile -> this.createStreams((Path)aFile, theContext, true).stream()).collect(Collectors.toList());
                    if (aStream == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (aStream != null) {
                            try {
                                aStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        if (this.mIgnoreFileErrors && this.mReporter != null) {
                            this.mReporter.println("Error while scanning " + String.valueOf(theFile) + ", some contents might be skipped");
                            e.printStackTrace(this.mReporter);
                            return List.of();
                        }
                        throw new UncheckedIOException(e);
                    }
                }
                aStream.close();
            }
            return list;
        }
        RDFFormat rDFFormat = aFormat = this.mFormat != null ? this.mFormat : (RDFFormat)RDFFormats.forFile((Path)Paths.get(theFile.getFileName().toString(), new String[0])).orElse(null);
        if (aFormat == null) {
            if (!theIgnoreUnsupported) {
                throw new IllegalArgumentException("No known format matches the file: " + String.valueOf(theFile));
            }
            return List.of();
        }
        List<RDFStream> multiThreadedStreams = this.createMultiThreadedStreams((compression, queueSize) -> new LineSupplier(theFile, compression, queueSize.intValue()), theContext, aFormat, theFile.toString(), Files2.size((Path)theFile));
        if (!multiThreadedStreams.isEmpty()) {
            return multiThreadedStreams;
        }
        RDFFileStream aStream = new RDFFileStream(theFile, theContext, this.newParserConfig(), aFormat, this.mCancellationPoint);
        return List.of(aStream);
    }

    private List<RDFStream> createMultiThreadedStreams(BiFunction<FileFormat.Compression, Integer, LineSupplier> supplierFactory, Resource context, RDFFormat format, String fileName, long fileSize) {
        Options aConfig = this.newParserConfig();
        int threadCount = (Integer)aConfig.get(RDFStreamOptions.THREAD_COUNT);
        RDFFormat baseFormat = RDFFormats.baseFormat((RDFFormat)format);
        if (threadCount > 1 && baseFormat != null && (RDFFormats.NTRIPLES.equals((Object)baseFormat) || RDFFormats.NQUADS.equals((Object)baseFormat)) && fileSize >= (Long)aConfig.get(RDFStreamOptions.MULTI_THREAD_FILE_SIZE)) {
            LOGGER.info("Multi-threaded parsing enabled with {} threads", (Object)threadCount);
            ArrayList<RDFStream> streams = new ArrayList<RDFStream>();
            int batchSize = (Integer)aConfig.get(RDFStreamOptions.BATCH_SIZE);
            int queueSize = (Integer)aConfig.get(RDFStreamOptions.QUEUE_SIZE);
            LineSupplier lineSupplier = supplierFactory.apply(RDFFormats.compressionOf((RDFFormat)format), queueSize);
            lineSupplier.setBatchSize(batchSize);
            if (!aConfig.contains(ParserContext.BNODE_ID_PREFIX)) {
                aConfig = aConfig.copy();
                aConfig.set(ParserContext.BNODE_ID_PREFIX, (Object)ParserContext.getRandomBnodeIdPrefix());
            }
            for (int i = 0; i < threadCount; ++i) {
                String name = fileName + "#" + i;
                streams.add(new NTStream(lineSupplier, name, fileSize, context, aConfig, format));
            }
            return streams;
        }
        return Collections.emptyList();
    }

    private static class ConstantResourceFunction
    implements Function<Path, Resource> {
        private final Resource mContext;

        public ConstantResourceFunction(Resource mContext) {
            this.mContext = mContext;
        }

        @Override
        public Resource apply(Path input) {
            return this.mContext;
        }
    }

    private static class RDFInputStream
    extends RDFAbstractStream {
        private final InputStream mStream;
        private final long mLength;

        private RDFInputStream(InputStream theStream, Resource theContext, Options theConfig, RDFFormat theFormat, CancellationPoint theCancellationPoint) {
            super(theContext, theConfig, theFormat, theCancellationPoint);
            this.mStream = theStream;
            this.mLength = RDFInputStream.available(theStream);
        }

        private static long available(InputStream theStream) {
            try {
                return theStream.available();
            }
            catch (IOException e) {
                return 0L;
            }
        }

        @Override
        protected InputStream openInputStream() {
            return this.mStream;
        }

        @Override
        public String getName() {
            return (this.mFormat == null ? "RDF" : this.mFormat.name()) + "Stream";
        }

        @Override
        public long length() {
            return this.mLength;
        }

        @Override
        public void close() throws IOException {
            Closeables.close((Closeable)this.mStream, (boolean)true);
        }
    }

    private static class RDFFileStream
    extends RDFAbstractStream {
        private final Path mFile;

        private RDFFileStream(Path theFile, Resource theContext, Options theConfig, RDFFormat theFormat, CancellationPoint theCancellationPoint) {
            super(theContext, theConfig, theFormat, theCancellationPoint);
            this.mFile = theFile;
        }

        @Override
        protected InputStream openInputStream() throws IOException {
            return Files.newInputStream(this.mFile, new OpenOption[0]);
        }

        @Override
        public String getName() {
            return this.mFile.toString();
        }

        @Override
        public long length() {
            return Files2.size((Path)this.mFile);
        }
    }

    private static class NTStream
    extends RDFStreamBase {
        private final LineSupplier mLineSupplier;
        private final String mName;
        private final long mLength;
        private final Resource mDefaultContext;
        protected final Options mConfig;
        protected RDFFormat mFormat;

        private NTStream(LineSupplier theLineSupplier, String theName, long theLength, Resource theContext, Options theConfig, RDFFormat theFormat) {
            this.mLineSupplier = theLineSupplier;
            this.mName = theName;
            this.mLength = theLength;
            this.mDefaultContext = theContext;
            this.mConfig = theConfig;
            this.mFormat = theFormat;
        }

        @Override
        public String getName() {
            return this.mName;
        }

        @Override
        public long length() {
            return this.mLength;
        }

        @Override
        public long bytesRead() {
            return this.mLineSupplier.bytesRead();
        }

        @Override
        public long estimatedCount() {
            return RDFStreams.estimatedCount(this.length(), this.mFormat);
        }

        @Override
        public Resource getContext() {
            return this.mDefaultContext;
        }

        @Override
        public boolean hasContext() {
            return this.mDefaultContext != null || RDFFormats.supportsContexts((RDFFormat)this.mFormat);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(RDFHandler theHandler) throws IOException, RDFHandlerException {
            RDFParser aRegisteredParser = RDFParsers.forFormat((RDFFormat)this.mFormat).orElse(null);
            NTParser aParser = (NTParser)Objects2.castTo((Object)aRegisteredParser, NTParser.class, (String)"Expecting NTriples or NQuads parser but got: {}", (Object[])new Object[]{aRegisteredParser});
            try {
                this.mLineSupplier.start();
                LineSupplierParserContext aContext = new LineSupplierParserContext((Supplier)this.mLineSupplier, theHandler, this.mConfig);
                aParser.parse((IOParserContext)aContext);
            }
            finally {
                this.mLineSupplier.stop();
            }
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static abstract class RDFAbstractStream
    implements RDFStream {
        private final Resource mDefaultContext;
        private final Options mConfig;
        protected RDFFormat mFormat;
        protected final FileFormat.Compression mCompression;
        private final CancellationPoint mCancellationPoint;
        private CountingInputStream mCountingInputStream;

        private RDFAbstractStream(Resource theContext, Options theConfig, RDFFormat theFormat, CancellationPoint theCancellationPoint) {
            this.mDefaultContext = theContext == Values.DEFAULT_GRAPH ? null : theContext;
            this.mConfig = theConfig;
            this.mFormat = theFormat;
            this.mCompression = RDFFormats.compressionOf((RDFFormat)this.mFormat);
            this.mCancellationPoint = theCancellationPoint != null ? theCancellationPoint : new DummyCancellationPoint();
        }

        protected abstract InputStream openInputStream() throws IOException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void parse(RDFHandler theHandler) throws InvalidRDF, IOException, RDFHandlerException {
            this.mCountingInputStream = new CountingInputStream(this.openInputStream());
            Object aInput = this.mCountingInputStream;
            try {
                if (this.mCompression == FileFormat.Compression.ZIP) {
                    ZipEntry aZipEntry;
                    ZipInputStream aZipInput = new ZipInputStream(new BufferedInputStream((InputStream)aInput));
                    aInput = aZipInput;
                    FilterInputStream aStream = new FilterInputStream(this, aZipInput){

                        @Override
                        public void close() {
                        }
                    };
                    while ((aZipEntry = aZipInput.getNextEntry()) != null) {
                        RDFFormat aFormat = RDFFormats.baseFormat((RDFFormat)this.mFormat);
                        if (aFormat == RDFFormats.UNKNOWN_BASE_FORMAT) {
                            aFormat = RDFFormats.forFile((Path)Paths.get(aZipEntry.getName(), new String[0])).orElse(null);
                            if (aZipEntry.isDirectory() || aFormat == null) continue;
                        }
                        this.parse(theHandler, aStream, aFormat);
                    }
                } else {
                    if (this.mCompression == FileFormat.Compression.NONE) {
                        aInput = new BufferedInputStream((InputStream)aInput);
                    }
                    this.parse(theHandler, (InputStream)aInput, this.mFormat);
                }
            }
            finally {
                try {
                    ((InputStream)aInput).close();
                }
                catch (IOException e) {
                    LOGGER.warn("Error closing the stream", (Throwable)e);
                }
            }
        }

        private void parse(RDFHandler theHandler, InputStream theStream, RDFFormat theFormat) throws InvalidRDF, RDFHandlerException, IOException {
            this.mCancellationPoint.check();
            FileFormat.Compression aComp = RDFFormats.compressionOf((RDFFormat)theFormat);
            if (aComp != FileFormat.Compression.NONE) {
                theStream = aComp.decompress(theStream);
            }
            RDFFormat aFormat = RDFFormats.baseFormat((RDFFormat)theFormat);
            RDFParser theParser = (RDFParser)RDFParsers.forFormat((RDFFormat)aFormat).get();
            if (aFormat == RDFFormats.BINARY || aFormat instanceof RDFFormat.BinaryRDFFormat) {
                theParser.parse(theStream, theHandler, this.mConfig);
            } else {
                theParser.parse((InputStream)new BOMInputStream(theStream, false), theHandler, this.mConfig);
            }
        }

        @Override
        public Resource getContext() {
            return this.mDefaultContext;
        }

        @Override
        public boolean hasContext() {
            return this.mDefaultContext != null || RDFFormats.supportsContexts((RDFFormat)this.mFormat) || this.mCompression != null && this.mCompression.supportsUnknownBaseFormat();
        }

        @Override
        public void close() throws IOException {
            if (this.mCountingInputStream != null) {
                Closeables.close((Closeable)this.mCountingInputStream, (boolean)true);
            }
        }

        @Override
        public long bytesRead() {
            return this.mCountingInputStream == null ? 0L : this.mCountingInputStream.getCount();
        }

        @Override
        public long estimatedCount() {
            return RDFStreams.estimatedCount(this.length(), this.mFormat);
        }

        public String toString() {
            return this.getName();
        }
    }
}

