/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.rio;

import com.complexible.common.base.Option;
import com.complexible.common.base.Options;
import com.stardog.stark.io.ParserOptions;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFParser;
import com.stardog.stark.io.RDFParsers;
import com.stardog.stark.io.TrigParserWithRules;
import javax.annotation.Nonnull;

public final class ParserConfigs {
    public static final Option<Boolean> STRICT_PARSING;

    private ParserConfigs() {
        throw new AssertionError();
    }

    public static Options strict() {
        return ParserConfigs.create(Options.of(STRICT_PARSING, (Object)true));
    }

    public static Options lax() {
        return ParserConfigs.create(Options.of(STRICT_PARSING, (Object)false));
    }

    public static Options defaults() {
        return ParserConfigs.create(Options.create());
    }

    public static Options create(Options theOptions) {
        boolean isStrict = theOptions.is(STRICT_PARSING);
        Options aOptions = isStrict ? ParserOptions.strict() : ParserOptions.lax();
        aOptions.setAll(theOptions);
        aOptions.set(ParserOptions.NORMALIZE_DATATYPES, (Object)false);
        return aOptions;
    }

    static {
        RDFParsers.register((RDFParser)new TrigParserWithRules());
        RDFParsers.register((RDFParser)new TrigParserWithRules(){

            @Nonnull
            public RDFFormat format() {
                return RDFFormats.TURTLE;
            }
        });
        STRICT_PARSING = Option.create((String)"strict.parsing", (Object)true);
    }
}

