/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.random;

import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import com.stardog.stark.BNode;
import com.stardog.stark.Datatype;
import com.stardog.stark.IRI;
import com.stardog.stark.Literal;
import com.stardog.stark.Resource;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;

public class RandomValueGenerator
extends UnmodifiableIterator<Value> {
    private final Random random;
    private int minLiteralLength = 4;
    private int maxLiteralLength = 32;
    private int minLocalNameLength = 4;
    private int maxLocalNameLength = 10;
    private int minBnodeLength = 4;
    private int maxBnodeLength = 10;
    private boolean builtinBnode = true;
    private float literalProbability = 0.5f;
    private float bnodeProbability = 0.05f;
    private float intProbability = 0.2f;
    private float floatProbability = 0.1f;
    private float doubleProbability = 0.1f;
    private float dateProbability = 0.1f;
    private float langStringProbability = 0.1f;
    private final int year = (int)TimeUnit.DAYS.toMillis(365L);
    private long now;
    private final String[] nameSpaces;
    private static final Locale[] LOCALES = Locale.getAvailableLocales();

    public RandomValueGenerator() {
        this(1);
    }

    public RandomValueGenerator(int nameSpaceCount) {
        this(System.currentTimeMillis(), nameSpaceCount);
    }

    public RandomValueGenerator(long randomSeed, int nameSpaceCount) {
        this(randomSeed, RandomValueGenerator.createNamespaces(nameSpaceCount));
    }

    private static String[] createNamespaces(int nameSpaceCount) {
        String[] nameSpaces = new String[nameSpaceCount];
        for (int i = 0; i < nameSpaces.length; ++i) {
            nameSpaces[i] = "http://stardog.com/test/ns" + i + "#";
        }
        return nameSpaces;
    }

    public RandomValueGenerator(long randomSeed, String[] nameSpaces) {
        this.random = new Random(randomSeed);
        this.nameSpaces = nameSpaces;
        this.now = randomSeed;
    }

    public String[] getNameSpaces() {
        return this.nameSpaces;
    }

    public boolean hasNext() {
        return true;
    }

    public Value next() {
        float f = this.random.nextFloat();
        if (f < this.literalProbability) {
            return this.nextLiteral();
        }
        if (f < this.literalProbability + this.bnodeProbability) {
            return this.nextBnode();
        }
        return this.nextURI();
    }

    public Resource nextResource() {
        float f = this.random.nextFloat();
        if (f < this.bnodeProbability) {
            return this.nextBnode();
        }
        return this.nextURI();
    }

    public Literal nextLiteral() {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6 = this.random.nextFloat();
        f6 -= this.intProbability;
        if (f5 < 0.0f) {
            return Values.literal((int)this.random.nextInt(1000000), (Datatype)Datatype.INTEGER);
        }
        f6 -= this.floatProbability;
        if (f4 < 0.0f) {
            return Values.literal((float)this.random.nextFloat());
        }
        f6 -= this.doubleProbability;
        if (f3 < 0.0f) {
            return Values.literal((double)this.random.nextDouble());
        }
        f6 -= this.dateProbability;
        if (f2 < 0.0f) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTimeInMillis(this.randomLong(this.now - (long)this.year, this.now + (long)this.year));
            return Values.literal((GregorianCalendar)cal);
        }
        int length = this.randomInt(this.minLiteralLength, this.maxLiteralLength);
        f6 -= this.langStringProbability;
        if (f < 0.0f) {
            String lang = LOCALES[this.random.nextInt(LOCALES.length)].toLanguageTag();
            return Values.literal((String)this.randomString(length), (String)lang);
        }
        return this.nextString(length);
    }

    public Literal nextString(int length) {
        return Values.literal((String)this.randomString(length));
    }

    public IRI nextURI() {
        int length = this.randomInt(this.minLocalNameLength, this.maxLocalNameLength);
        String localName = this.randomString(length);
        String nameSpace = this.nameSpaces[this.random.nextInt(this.nameSpaces.length)];
        return Values.iri((String)(nameSpace + localName));
    }

    public BNode nextBnode() {
        if (this.builtinBnode) {
            return Values.bnode();
        }
        int length = this.randomInt(this.minBnodeLength, this.maxBnodeLength);
        return Values.bnode((String)this.randomString(length));
    }

    private String randomString(int length) {
        return RandomStringUtils.random((int)length, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)this.random);
    }

    private int randomInt(int min, int max) {
        int range = max - min + 1;
        return this.random.nextInt(range) + min;
    }

    private long randomLong(long min, long max) {
        long range = max - min + 1L;
        return this.random.nextLong() % range + min;
    }

    public void setSeed(long theSeed) {
        this.random.setSeed(theSeed);
        this.now = theSeed;
    }

    public float nextFloat() {
        return this.random.nextFloat();
    }

    public int nextInt(int bound) {
        return this.random.nextInt(bound);
    }

    public boolean nextBoolean() {
        return this.random.nextBoolean();
    }

    public int getMinLiteralLength() {
        return this.minLiteralLength;
    }

    public void setMinLiteralLength(int minLiteralLength) {
        this.minLiteralLength = minLiteralLength;
    }

    public int getMaxLiteralLength() {
        return this.maxLiteralLength;
    }

    public void setMaxLiteralLength(int maxLiteralLength) {
        this.maxLiteralLength = maxLiteralLength;
    }

    public int getMinLocalNameLength() {
        return this.minLocalNameLength;
    }

    public void setMinLocalNameLength(int minLocalNameLength) {
        this.minLocalNameLength = minLocalNameLength;
    }

    public int getMaxLocalNameLength() {
        return this.maxLocalNameLength;
    }

    public void setMaxLocalNameLength(int maxLocalNameLength) {
        this.maxLocalNameLength = maxLocalNameLength;
    }

    public int getMinBnodeLength() {
        return this.minBnodeLength;
    }

    public void setMinBnodeLength(int minBnodeLength) {
        this.minBnodeLength = minBnodeLength;
    }

    public int getMaxBnodeLength() {
        return this.maxBnodeLength;
    }

    public void setMaxBnodeLength(int maxBnodeLength) {
        this.maxBnodeLength = maxBnodeLength;
    }

    public boolean isBuiltinBnode() {
        return this.builtinBnode;
    }

    public void setBuiltinBnode(boolean builtinBnode) {
        this.builtinBnode = builtinBnode;
    }

    public float getLiteralProbability() {
        return this.literalProbability;
    }

    public float getBnodeProbability() {
        return this.bnodeProbability;
    }

    public float getURIProbability() {
        return 1.0f - this.bnodeProbability - this.literalProbability;
    }

    public void setValueProbability(float uriProbability, float bnodeProbability, float literalProbability) {
        Preconditions.checkArgument((uriProbability + bnodeProbability + literalProbability == 1.0f ? 1 : 0) != 0, (Object)"Sum of probabilities should be equal to 1");
        this.literalProbability = literalProbability;
        this.bnodeProbability = bnodeProbability;
    }

    public void setLiteralProbability(float stringProbability, float langStringProbability, float intProbability, float floatProbability, float doubleProbability, float dateProbability) {
        float f = stringProbability + langStringProbability + intProbability + floatProbability + doubleProbability + dateProbability;
        Preconditions.checkArgument((Math.abs(f - 1.0f) <= 1.0E-5f ? 1 : 0) != 0, (Object)"Sum of probabilities should be equal to 1");
        this.intProbability = intProbability;
        this.floatProbability = floatProbability;
        this.doubleProbability = doubleProbability;
        this.dateProbability = dateProbability;
        this.langStringProbability = langStringProbability;
    }

    public float getIntProbability() {
        return this.intProbability;
    }

    public float getFloatProbability() {
        return this.floatProbability;
    }

    public float getDoubleProbability() {
        return this.doubleProbability;
    }

    public float getDateProbability() {
        return this.dateProbability;
    }

    public float getLangStringProbability() {
        return this.langStringProbability;
    }

    public float getStringProbability() {
        return 1.0f - (this.langStringProbability + this.intProbability + this.floatProbability + this.doubleProbability + this.dateProbability);
    }

    public static void main(String[] args) {
        RandomValueGenerator gen = new RandomValueGenerator(3);
        gen.bnodeProbability = 0.1f;
        for (int i = 0; i < 100; ++i) {
            System.out.println(gen.next());
        }
    }
}

