/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.random;

import com.complexible.common.rdf.random.RandomValueGenerator;
import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import com.stardog.stark.IRI;
import com.stardog.stark.Resource;
import com.stardog.stark.Statement;
import com.stardog.stark.Value;
import com.stardog.stark.Values;
import com.stardog.stark.io.RDFFormat;
import com.stardog.stark.io.RDFFormats;
import com.stardog.stark.io.RDFWriter;
import com.stardog.stark.io.RDFWriters;
import com.stardog.stark.vocabs.RDF;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class RandomStatementGenerator
extends UnmodifiableIterator<Statement> {
    private final RandomValueGenerator mValueGenerator;
    private int mNumberOfDistinctProperties = 100;
    private IRI[] mPredicates;
    private int mNumberOfDistinctClasses = 100;
    private IRI[] mClasses;
    private int mNumberOfStatementsPerSubject = 10;
    private int mCurrentSubjectRemaining = 0;
    private Resource mCurrentSubject;
    private int mNumberOfSubjectsPerGraph = 0;
    private int mCurrentGraphRemaining = 0;
    private IRI mCurrentGraph;

    public RandomStatementGenerator() {
        this(new RandomValueGenerator());
    }

    public RandomStatementGenerator(RandomValueGenerator theRandomValueGenerator) {
        this.mValueGenerator = theRandomValueGenerator;
    }

    public boolean hasNext() {
        return true;
    }

    private Resource generateSubject() {
        if (--this.mCurrentSubjectRemaining <= 0) {
            this.mCurrentSubjectRemaining = this.mNumberOfStatementsPerSubject;
            this.mCurrentSubject = this.mValueGenerator.nextResource();
        }
        return this.mCurrentSubject;
    }

    private IRI[] generateURIs(int theCount) {
        IRI[] aURIs = new IRI[theCount];
        for (int i = 0; i < theCount; ++i) {
            aURIs[i] = this.mValueGenerator.nextURI();
        }
        return aURIs;
    }

    private IRI chooseURI(IRI[] theURIs) {
        int aIndex = this.mValueGenerator.nextInt(theURIs.length);
        return theURIs[aIndex];
    }

    private IRI generatePredicate() {
        if (this.isType()) {
            return RDF.TYPE;
        }
        if (this.mNumberOfDistinctProperties == 0) {
            return this.mValueGenerator.nextURI();
        }
        if (this.mPredicates == null) {
            this.mPredicates = this.generateURIs(this.mNumberOfDistinctProperties);
        }
        return this.chooseURI(this.mPredicates);
    }

    private Value generateValue() {
        return this.isType() ? this.generateType() : this.mValueGenerator.next();
    }

    private IRI generateType() {
        if (this.mClasses == null) {
            this.mClasses = this.generateURIs(this.mNumberOfDistinctClasses);
        }
        return this.chooseURI(this.mClasses);
    }

    private IRI generateGraph() {
        if (this.mNumberOfSubjectsPerGraph > 0) {
            if (this.isFirstStatement()) {
                --this.mCurrentGraphRemaining;
            }
            if (this.mCurrentGraphRemaining <= 0) {
                this.mCurrentGraphRemaining = this.mNumberOfSubjectsPerGraph;
                this.mCurrentGraph = this.mValueGenerator.nextURI();
            }
        }
        return this.mCurrentGraph;
    }

    private boolean isFirstStatement() {
        return this.mCurrentSubjectRemaining == this.mNumberOfStatementsPerSubject;
    }

    private boolean isType() {
        return this.mNumberOfDistinctClasses > 0 && this.isFirstStatement();
    }

    public int getNumberOfDistinctProperties() {
        return this.mNumberOfDistinctProperties;
    }

    public void setNumberOfDistinctProperties(int theNumberOfDistinctProperties) {
        this.mNumberOfDistinctProperties = theNumberOfDistinctProperties;
    }

    public int getNumberOfStatementsPerSubject() {
        return this.mNumberOfStatementsPerSubject;
    }

    public void setNumberOfStatementsPerSubject(int theNumberOfStatementsPerSubject) {
        Preconditions.checkArgument((theNumberOfStatementsPerSubject > 0 ? 1 : 0) != 0, (Object)"Positive number required");
        this.mNumberOfStatementsPerSubject = theNumberOfStatementsPerSubject;
    }

    public int getNumberOfDistinctClasses() {
        return this.mNumberOfDistinctClasses;
    }

    public void setNumberOfDistinctClasses(int theNumberOfDistinctClasses) {
        this.mNumberOfDistinctClasses = theNumberOfDistinctClasses;
    }

    public int getNumberOfSubjectsPerGraph() {
        return this.mNumberOfSubjectsPerGraph;
    }

    public void setNumberOfSubjectsPerGraph(int theNumberOfSubjectsPerGraph) {
        Preconditions.checkArgument((theNumberOfSubjectsPerGraph > 0 ? 1 : 0) != 0, (Object)"Non-negative number required");
        this.mNumberOfSubjectsPerGraph = theNumberOfSubjectsPerGraph;
    }

    public Statement next() {
        Resource s = this.generateSubject();
        IRI p = this.generatePredicate();
        Value o = this.generateValue();
        IRI g = this.generateGraph();
        return Values.statement((Resource)s, (IRI)p, (Value)o, (Resource)g);
    }

    public static Set<Statement> randomGraph(Random rnd, int numNodes, int numEdges, List<IRI> predicates) {
        List nodes = IntStream.range(0, numNodes).mapToObj(i -> Values.iri((String)("urn:node:" + i))).collect(Collectors.toList());
        HashSet<Statement> edges = new HashSet<Statement>(numEdges);
        while (edges.size() <= numEdges) {
            IRI n1 = (IRI)RandomStatementGenerator.pickFrom(nodes, rnd);
            IRI n2 = (IRI)RandomStatementGenerator.pickFrom(nodes, rnd);
            IRI predicate = RandomStatementGenerator.pickFrom(predicates, rnd);
            edges.add(Values.statement((Resource)n1, (IRI)predicate, (Value)n2));
        }
        return edges;
    }

    public static List<Resource> randomSubjects(Set<Statement> data, Random rnd, int size) {
        List list = data.stream().map(Statement::subject).collect(Collectors.toList());
        Collections.shuffle(list, rnd);
        return list.subList(0, size);
    }

    public static <T> T pickFrom(List<? extends T> resources, Random rnd) {
        return resources.get(rnd.nextInt(resources.size()));
    }

    public static void main(String[] args) {
        RandomValueGenerator values = new RandomValueGenerator(4);
        RandomStatementGenerator stmts = new RandomStatementGenerator(values);
        stmts.setNumberOfSubjectsPerGraph(Integer.MAX_VALUE);
        RDFWriter writer = (RDFWriter)RDFWriters.to((OutputStream)System.out, (RDFFormat)RDFFormats.TRIG).get();
        writer.start();
        char prefix = 'a';
        for (String ns : values.getNameSpaces()) {
            char c = prefix;
            prefix = (char)(prefix + 1);
            writer.namespace(String.valueOf(c), ns);
        }
        for (int i = 0; i < 100; ++i) {
            writer.handle(stmts.next());
        }
        writer.end();
    }
}

