/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.query.resultio;

import com.complexible.common.base.Options;
import com.complexible.common.rdf.query.Edge;
import com.complexible.common.rdf.query.Path;
import com.complexible.common.rdf.query.resultio.PathQueryResultWriter;
import com.complexible.common.rdf.query.resultio.TextTableQueryResultWriter;
import com.google.common.collect.Lists;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.BindingSets;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public final class TextTablePathQueryResultWriter
extends TextTableQueryResultWriter
implements PathQueryResultWriter {
    private final BindingSet mDelimiter = BindingSets.empty();
    private final List<String> mBindingNames;
    private int mPathCount;

    public TextTablePathQueryResultWriter(OutputStream theOut, List<String> thePathStartVariableNames, List<String> thePathEndVariableNames, List<String> theEdgeVariableNames, Options theOptions) {
        super(theOut, theOptions);
        this.mBindingNames = this.createBindingNames(thePathStartVariableNames, thePathEndVariableNames, theEdgeVariableNames);
    }

    private List<String> createBindingNames(List<String> thePathStartVariableNames, List<String> thePathEndVariableNames, List<String> theEdgeVariableNames) {
        String aStart = thePathStartVariableNames.get(0);
        String aEnd = thePathEndVariableNames.get(0);
        ArrayList aNames = Lists.newArrayListWithExpectedSize((int)(thePathStartVariableNames.size() + thePathEndVariableNames.size() + theEdgeVariableNames.size()));
        thePathStartVariableNames.stream().skip(1L).forEach(aNames::add);
        aNames.add(aStart);
        theEdgeVariableNames.stream().filter(v -> !v.equals(aStart) && !v.equals(aEnd)).forEach(aNames::add);
        aNames.add(aEnd);
        thePathEndVariableNames.stream().skip(1L).forEach(aNames::add);
        return aNames;
    }

    @Override
    public void variables(@Nonnull List<String> theSelectVars) {
        super.variables(this.mBindingNames);
        this.mPathCount = 0;
    }

    @Override
    public void end() {
        this.mExporter.output();
        if (this.isShowSummary()) {
            long aTime = System.currentTimeMillis() - this.getStartTime();
            this.mOut.format("%nQuery returned %,d paths in %s%n", this.mPathCount, this.getTimeFormat().format(aTime));
        }
    }

    @Override
    public void handlePath(Path thePath) {
        if (thePath.getEdges().isEmpty()) {
            return;
        }
        if (this.mPathCount > 0) {
            this.handle(this.mDelimiter);
        }
        Iterator<Edge> aEdges = thePath.getEdges().iterator();
        if (thePath.getPathStartBindings().size() > 0) {
            this.handle(BindingSets.union((BindingSet)thePath.getPathStartBindings(), (BindingSet)aEdges.next().getBindings()));
        }
        while (aEdges.hasNext()) {
            Edge aEdge = aEdges.next();
            if (!aEdges.hasNext() && thePath.getPathEndBindings().size() > 0) {
                this.handle(BindingSets.union((BindingSet)aEdge.getBindings(), (BindingSet)thePath.getPathEndBindings()));
                continue;
            }
            this.handle(aEdge.getBindings());
        }
        ++this.mPathCount;
    }
}

