/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.query.resultio;

import com.complexible.common.base.Options;
import com.complexible.common.rdf.query.Edge;
import com.complexible.common.rdf.query.Path;
import com.complexible.common.rdf.query.resultio.PathQueryResultWriter;
import com.complexible.common.rdf.query.resultio.TextTableQueryResultWriter;
import com.stardog.stark.Value;
import com.stardog.stark.query.Binding;
import com.stardog.stark.query.BindingSet;
import com.stardog.stark.query.BindingSets;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;

public class TextPathQueryResultWriter
extends TextTableQueryResultWriter
implements PathQueryResultWriter {
    private static final BindingSet NO_NODE_ATTRIBUTES = BindingSets.empty();
    private final PrintStream mOut;
    private final String mStartVar;
    private final String mEndVar;
    private int mPathCount;

    public TextPathQueryResultWriter(OutputStream theOut, String theStartVar, String theEndVar) {
        super(null, Options.empty());
        this.mStartVar = theStartVar;
        this.mEndVar = theEndVar;
        this.mOut = theOut == null ? System.out : (theOut instanceof PrintStream ? (PrintStream)theOut : new PrintStream(theOut));
    }

    @Override
    public void handlePath(Path thePath) {
        if (this.mPathCount++ > 0) {
            this.mOut.println();
        }
        List<Edge> aEdges = thePath.getEdges();
        this.renderNode(aEdges.get(0).getStart(), thePath.getPathStartBindings());
        Iterator<Edge> aIter = aEdges.iterator();
        while (aIter.hasNext()) {
            Edge aEdge = aIter.next();
            this.renderEdge(aEdge);
            if (aIter.hasNext()) {
                this.renderNode(aEdge.getEnd(), NO_NODE_ATTRIBUTES);
                continue;
            }
            this.renderNode(aEdge.getEnd(), thePath.getPathEndBindings());
        }
        this.mOut.println();
    }

    private void renderEdge(Edge theEdge) {
        BindingSet aBindings = theEdge.getBindings();
        if (aBindings.size() > 2) {
            this.mOut.print("-");
            this.renderBindings(aBindings);
        }
        this.mOut.print("->");
    }

    private void renderBindings(BindingSet theBindings) {
        this.mOut.print("[");
        boolean first = true;
        for (Binding aBinding : theBindings) {
            String aVar = aBinding.name();
            if (aVar.equals(this.mStartVar) || aVar.equals(this.mEndVar)) continue;
            if (first) {
                first = false;
            } else {
                this.mOut.print(", ");
            }
            this.mOut.print(aVar + "=" + this.formatNode(aBinding.value()));
        }
        this.mOut.print("]");
    }

    private void renderNode(Value theNode, BindingSet theNodeBindings) {
        this.mOut.print("(" + this.formatNode(theNode));
        if (theNodeBindings.size() > 0) {
            this.mOut.print(" ");
            this.renderBindings(theNodeBindings);
        }
        this.mOut.print(")");
    }

    private String formatNode(Value theNode) {
        String str = this.mColumns[0].format(theNode);
        if (str.charAt(0) == '<') {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    @Override
    public void end() {
        if (this.isShowSummary()) {
            long aTime = System.currentTimeMillis() - this.getStartTime();
            this.mOut.format("%nQuery returned %,d paths in %s%n", this.mPathCount, this.getTimeFormat().format(aTime));
        }
    }
}

