/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.query.parser.sparql.ast;

import com.complexible.common.rdf.query.parser.sparql.ast.ParseException;
import com.complexible.common.rdf.query.parser.sparql.ast.SimpleNode;
import com.complexible.common.rdf.query.parser.sparql.ast.SyntaxTreeBuilder;
import com.complexible.common.rdf.query.parser.sparql.ast.SyntaxTreeBuilderVisitor;
import com.complexible.common.rdf.query.parser.sparql.ast.VisitorException;

public class ASTHint
extends SimpleNode {
    String key;
    String value = "";

    public ASTHint(int id) {
        super(id);
    }

    public ASTHint(SyntaxTreeBuilder p, int id) {
        super(p, id);
    }

    public void addHint(String hintString) throws ParseException {
        String[] parts = hintString.trim().split("\\s+");
        if (parts.length < 2) {
            throw new ParseException("Invalid hint string: " + hintString);
        }
        this.key = parts[1].trim();
        if (parts.length > 2) {
            this.value = parts[2].trim();
        }
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return "Hint(" + this.key + (String)(this.value.equals("") ? "" : " = " + this.value) + ")";
    }

    @Override
    public Object jjtAccept(SyntaxTreeBuilderVisitor visitor, Object data) throws VisitorException {
        return visitor.visit(this, data);
    }
}

