/*
 * Decompiled with CFR 0.152.
 */
package com.complexible.common.rdf.query.parser.sparql;

import com.complexible.common.rdf.query.parser.sparql.AbstractASTVisitor;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTDescribe;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTDescribeQuery;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTProjectionElem;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTQuery;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTQueryContainer;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTSelect;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTSelectQuery;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTUpdateContainer;
import com.complexible.common.rdf.query.parser.sparql.ast.ASTVar;
import com.complexible.common.rdf.query.parser.sparql.ast.Node;
import com.complexible.common.rdf.query.parser.sparql.ast.SimpleNode;
import com.complexible.common.rdf.query.parser.sparql.ast.VisitorException;
import com.stardog.stark.query.MalformedQuery;
import java.util.LinkedHashSet;
import java.util.Set;

public class WildcardProjectionProcessor
extends AbstractASTVisitor {
    public static void process(ASTQueryContainer qc) throws MalformedQuery {
        ASTDescribeQuery describeQuery;
        ASTDescribe describeClause;
        ASTQuery queryNode = qc.getQuery();
        if (queryNode != null) {
            WildcardProjectionProcessor.processWildcards(queryNode.getWhereClause());
        }
        if (queryNode instanceof ASTSelectQuery) {
            ASTSelectQuery selectQuery = (ASTSelectQuery)queryNode;
            ASTSelect selectClause = selectQuery.getSelect();
            if (selectClause.isWildcard()) {
                WildcardProjectionProcessor.addQueryVars(selectClause, selectQuery.getWhereClause(), selectQuery.getBindingsClause());
                selectClause.setWildcard(false);
            }
        } else if (queryNode instanceof ASTDescribeQuery && (describeClause = (describeQuery = (ASTDescribeQuery)queryNode).getDescribe()).isWildcard() && describeQuery.getWhereClause() != null) {
            WildcardProjectionProcessor.addQueryVars(describeClause, describeQuery.getWhereClause());
            describeClause.setWildcard(false);
        }
    }

    public static void process(ASTUpdateContainer uc) {
        WildcardProjectionProcessor.processWildcards(uc.getUpdate());
    }

    private static void processWildcards(SimpleNode root) {
        if (root != null) {
            try {
                root.jjtAccept(new AbstractASTVisitor(){

                    @Override
                    public Object visit(ASTSelectQuery node, Object data) throws VisitorException {
                        super.visit(node.getWhereClause(), data);
                        ASTSelect select = node.getSelect();
                        if (select.isWildcard()) {
                            WildcardProjectionProcessor.addQueryVars(select, node.getWhereClause(), node.getBindingsClause());
                            select.setWildcard(false);
                        }
                        return null;
                    }
                }, null);
            }
            catch (VisitorException e) {
                throw new MalformedQuery((Throwable)e);
            }
        }
    }

    private static void addQueryVars(Node wildcardNode, Node ... queryNodes) throws MalformedQuery {
        QueryVariableCollector visitor = new QueryVariableCollector();
        try {
            for (Node n : queryNodes) {
                if (n == null) continue;
                n.jjtAccept(visitor, null);
            }
            for (String varName : visitor.getVariableNames()) {
                ASTVar varNode = new ASTVar(72);
                ASTProjectionElem projectionElemNode = new ASTProjectionElem(17);
                varNode.setName(varName);
                projectionElemNode.jjtAppendChild(varNode);
                varNode.jjtSetParent(projectionElemNode);
                wildcardNode.jjtAppendChild(projectionElemNode);
                projectionElemNode.jjtSetParent(wildcardNode);
            }
        }
        catch (VisitorException e) {
            throw new MalformedQuery((Throwable)e);
        }
    }

    private static class QueryVariableCollector
    extends AbstractASTVisitor {
        private Set<String> variableNames = new LinkedHashSet<String>();

        private QueryVariableCollector() {
        }

        Set<String> getVariableNames() {
            return this.variableNames;
        }

        @Override
        public Object visit(ASTSelectQuery node, Object data) throws VisitorException {
            return this.visit(node.getSelect(), data);
        }

        @Override
        public Object visit(ASTProjectionElem node, Object data) throws VisitorException {
            String alias = node.getAlias();
            if (alias != null) {
                this.variableNames.add(alias);
                return null;
            }
            return super.visit(node, data);
        }

        @Override
        public Object visit(ASTVar node, Object data) throws VisitorException {
            if (!node.isAnonymous()) {
                this.variableNames.add(node.getName());
            }
            return super.visit(node, data);
        }
    }
}

